/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoInputStream;
import com.coremedia.iso.boxes.BitRateBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.BoxContainer;
import com.coremedia.iso.boxes.BoxInterface;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataEntryUrnBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.EditBox;
import com.coremedia.iso.boxes.EditListBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.FreeBox;
import com.coremedia.iso.boxes.FreeSpaceBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.HintMediaHeaderBox;
import com.coremedia.iso.boxes.HintTrackReferenceBox;
import com.coremedia.iso.boxes.ItemProtectionBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaDataBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MetaBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.OriginalFormatBox;
import com.coremedia.iso.boxes.ProtectionSchemeInformationBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.SchemeInformationBox;
import com.coremedia.iso.boxes.SchemeTypeBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.TrackReferenceBox;
import com.coremedia.iso.boxes.UnknownBox;
import com.coremedia.iso.boxes.UserBox;
import com.coremedia.iso.boxes.UserDataBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.rtp.TimeScaleEntry;
import com.coremedia.iso.boxes.sampleentry.AmrSpecificBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.TextSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.gui.Utils;

public class BoxFactory {
    public static String dumpBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = byArray.length;
        for (int j = 0; j < n; ++j) {
            byte by = byArray[j];
            String string = Integer.toHexString(256 + (by & 0xFF)).substring(1);
            stringBuffer.append(string.length() >= 2 ? "" : "0").append(string);
        }
        return stringBuffer.toString();
    }

    public Box createBox(byte[] byArray, byte[] object, byte[] byArray2) {
        Utils.equals(byArray2, IsoFile.fourCCtoBytes("ilst"));
        Utils.equals(byArray2, IsoFile.fourCCtoBytes("udta"));
        Utils.equals(byArray2, IsoFile.fourCCtoBytes("hnti"));
        Utils.equals(byArray2, IsoFile.fourCCtoBytes("hinf"));
        if (Utils.equals(byArray2, IsoFile.fourCCtoBytes("stsd"))) {
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("tx3g"))) {
                return new TextSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("samr"))) {
                return new AudioSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("sawb"))) {
                return new AudioSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("mp4a"))) {
                return new AudioSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("drms"))) {
                return new AudioSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("alac"))) {
                return new AudioSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("enca"))) {
                return new AudioSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("mp4v"))) {
                return new VisualSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("s263"))) {
                return new VisualSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("avc1"))) {
                return new VisualSampleEntry(byArray);
            }
            if (Utils.equals(byArray, IsoFile.fourCCtoBytes("encv"))) {
                return new VisualSampleEntry(byArray);
            }
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("btrt"))) {
            return new BitRateBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("ftyp"))) {
            return new FileTypeBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("mdat"))) {
            return new MediaDataBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("moov"))) {
            return new MovieBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("mvhd"))) {
            return new MovieHeaderBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("trak"))) {
            return new TrackBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("tkhd"))) {
            return new TrackHeaderBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("edts"))) {
            return new EditBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("elst"))) {
            return new EditListBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("mdia"))) {
            return new MediaBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("mdhd"))) {
            return new MediaHeaderBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("hdlr"))) {
            return new HandlerBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("minf"))) {
            return new MediaInformationBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("vmhd"))) {
            return new VideoMediaHeaderBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("smhd"))) {
            return new SoundMediaHeaderBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("hmhd"))) {
            return new HintMediaHeaderBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("hint"))) {
            return new HintTrackReferenceBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("dinf"))) {
            return new DataInformationBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("dref"))) {
            return new DataReferenceBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("url "))) {
            return new DataEntryUrlBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("urn "))) {
            return new DataEntryUrnBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("stbl"))) {
            return new SampleTableBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("stsd"))) {
            return new SampleDescriptionBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("stts"))) {
            return new TimeToSampleBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("stss"))) {
            return new SyncSampleBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("stsc"))) {
            return new SampleToChunkBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("stsz"))) {
            return new SampleSizeBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("stco"))) {
            return new StaticChunkOffsetBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("udta"))) {
            return new UserDataBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("skip"))) {
            return new FreeSpaceBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("tref"))) {
            return new TrackReferenceBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("tims"))) {
            return new TimeScaleEntry();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("damr"))) {
            return new AmrSpecificBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("meta"))) {
            return new MetaBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("ipro"))) {
            return new ItemProtectionBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("sinf"))) {
            return new ProtectionSchemeInformationBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("frma"))) {
            return new OriginalFormatBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("schi"))) {
            return new SchemeInformationBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("schm"))) {
            return new SchemeTypeBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("schm"))) {
            return new SchemeTypeBox();
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes("uuid"))) {
            return new UserBox((byte[])object);
        }
        if (Utils.equals(byArray, IsoFile.fourCCtoBytes(FreeBox.TYPE))) {
            return new FreeBox();
        }
        object = Integer.toHexString(byArray[0] >> 4 & 0xF) + Integer.toHexString(byArray[0] & 0xF) + Integer.toHexString(byArray[1] >> 4 & 0xF) + Integer.toHexString(byArray[1] & 0xF) + Integer.toHexString(byArray[2] >> 4 & 0xF) + Integer.toHexString(byArray[2] & 0xF) + Integer.toHexString(byArray[3] >> 4 & 0xF) + Integer.toHexString(byArray[3] & 0xF);
        System.out.println("Unknown box found: " + IsoFile.bytesToFourCC(byArray) + " 0x" + (String)object + "parent is: " + IsoFile.bytesToFourCC(byArray2));
        return new UnknownBox(byArray);
    }

    public Box parseBox(IsoInputStream isoInputStream, BoxInterface boxInterface) {
        long l;
        long l2 = isoInputStream.getStreamPosition();
        long l3 = isoInputStream.readUInt32();
        if (l3 < 8L && l3 > 1L) {
            return null;
        }
        Object object = isoInputStream.read(4);
        byte[] byArray = null;
        if (l3 == 1L) {
            l3 = isoInputStream.readUInt64();
            l = l3 - 16L;
        } else if (l3 == 0L) {
            l = -1L;
            l3 = 1L;
        } else {
            l = l3 - 8L;
        }
        if (Utils.equals((byte[])object, IsoFile.fourCCtoBytes("uuid"))) {
            byArray = isoInputStream.read(16);
            l -= 16L;
        }
        Box box = this.createBox((byte[])object, byArray, boxInterface != null ? boxInterface.getType() : null);
        object = box;
        box.setParent((BoxContainer)boxInterface);
        ((Box)object).parse(isoInputStream, l, this);
        if (isoInputStream.getStreamPosition() - l2 < l3 && l != -1L) {
            ((Box)object).setDeadBytes(isoInputStream.read((int)(l3 - (isoInputStream.getStreamPosition() - l2))));
        }
        if (l3 != ((Box)object).getSize()) {
            ((Box)object).getSize();
        }
        ((Box)object).offset = l2;
        return object;
    }
}

