/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.BoxFactory;
import com.coremedia.iso.IsoInputStream;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.BoxContainer;
import com.coremedia.iso.boxes.BoxInterface;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.DynamicChunkOffsetBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaDataBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.mdta.Chunk;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IsoFile
implements BoxContainer,
BoxInterface {
    private Box[] a;
    private BoxFactory a;
    private ByteArrayInputStream a = new BoxFactory();

    public static String bytesToFourCC(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(4);
        for (int j = 0; j < 4; ++j) {
            stringBuffer.append((char)byArray[j]);
        }
        return stringBuffer.toString();
    }

    public static byte[] fourCCtoBytes(String string) {
        byte[] byArray = new byte[4];
        for (int j = 0; j < 4; ++j) {
            byArray[j] = (byte)string.charAt(j);
        }
        return byArray;
    }

    public IsoFile(ByteArrayInputStream byteArrayInputStream) {
        this.a = byteArrayInputStream;
    }

    public void addBox(Box box) {
        Vector<Box> vector = new Vector<Box>();
        for (int j = 0; j < this.a.length; ++j) {
            vector.addElement(this.a[j]);
        }
        vector.addElement(box);
        this.a = new Box[vector.size()];
        vector.copyInto(this.a);
    }

    public long calculateOffset() {
        return 0L;
    }

    public Box[] getBoxes() {
        return this.a;
    }

    public Box[] getBoxes(String string) {
        System.out.println("IsoFile.getBoxes()");
        Vector<Box> vector = new Vector<Box>();
        Box[] boxArray = this.a;
        int n = this.a.length;
        for (int j = 0; j < n; ++j) {
            Box box = boxArray[j];
            if (!box.getDisplayName().equals(string)) continue;
            vector.addElement(box);
            System.out.println("name: " + box.getDisplayName() + " | size: " + box.getSize());
        }
        if (string.equals("Media Data Box")) {
            Object[] objectArray = new MediaDataBox[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        if (string.equals("Movie Box")) {
            Object[] objectArray = new MovieBox[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        if (string.equals("Track Box")) {
            Object[] objectArray = new TrackBox[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        if (string.equals("Media Information Box")) {
            Object[] objectArray = new MediaInformationBox[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        if (string.equals("Sample Table Box")) {
            Object[] objectArray = new SampleTableBox[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        System.out.println("IsoFile.getBoxes() return null;");
        return null;
    }

    public IsoFile getIsoFile() {
        return this;
    }

    public long getNumOfBytesToFirstChild() {
        return 0L;
    }

    public ByteArrayInputStream getOriginalIso() {
        return this.a;
    }

    public BoxContainer getParent() {
        return null;
    }

    public long getSize() {
        long l = 0L;
        Box[] boxArray = this.a;
        int n = this.a.length;
        for (int j = 0; j < n; ++j) {
            Box box = boxArray[j];
            l += box.getSize();
        }
        return l;
    }

    public Object getTrack(int n) {
        MediaDataBox[] mediaDataBoxArray = (MediaDataBox[])this.getBoxes("Media Data Box");
        Vector<Object> vector = new Vector<Object>();
        int n2 = mediaDataBoxArray.length;
        for (int j = 0; j < n2; ++j) {
            Object object = mediaDataBoxArray[j];
            System.out.println(((MediaDataBox)object).getTrack(n));
            object = (Vector)((MediaDataBox)object).getTrack(n).getChunks();
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                object = (Chunk)enumeration.nextElement();
                vector.addElement(((Chunk)object).getSamples());
            }
        }
        return vector;
    }

    public byte[] getType() {
        return new byte[0];
    }

    public void parse() {
        IsoInputStream isoInputStream = new IsoInputStream(this.a);
        Vector<Box> vector = new Vector<Box>();
        boolean bl = false;
        while (!bl) {
            try {
                isoInputStream.getStreamPosition();
                Box box = this.a.parseBox(isoInputStream, this);
                if (box != null) {
                    vector.addElement(box);
                    continue;
                }
                bl = true;
            }
            catch (EOFException eOFException) {
                bl = true;
            }
        }
        this.a = new Box[vector.size()];
        vector.copyInto(this.a);
    }

    public void parseMdats() {
        MediaDataBox[] mediaDataBoxArray = (MediaDataBox[])this.getBoxes("Media Data Box");
        MediaDataBox[] mediaDataBoxArray2 = mediaDataBoxArray;
        mediaDataBoxArray2 = mediaDataBoxArray;
        int n = mediaDataBoxArray.length;
        for (int j = 0; j < n; ++j) {
            MediaDataBox mediaDataBox = mediaDataBoxArray2[j];
            mediaDataBox.parseTrackChunkSample();
        }
    }

    public void removeBox(Box box) {
        Vector<Box> vector = new Vector<Box>();
        for (int j = 0; j < this.a.length; ++j) {
            vector.addElement(this.a[j]);
        }
        vector.removeElement(box);
        this.a = new Box[vector.size()];
        vector.copyInto(this.a);
    }

    public void switchToAutomaticChunkOffsetBox() {
        MovieBox[] movieBoxArray = (MovieBox[])this.getBoxes("Movie Box");
        MovieBox[] movieBoxArray2 = movieBoxArray;
        movieBoxArray2 = movieBoxArray;
        int n = movieBoxArray.length;
        for (int j = 0; j < n; ++j) {
            TrackBox[] trackBoxArray = movieBoxArray2[j];
            TrackBox[] trackBoxArray2 = (TrackBox[])trackBoxArray.getBoxes("Track Box");
            trackBoxArray = trackBoxArray2;
            trackBoxArray = trackBoxArray2;
            int n2 = trackBoxArray2.length;
            for (int k = 0; k < n2; ++k) {
                ContainerBox containerBox = trackBoxArray[k];
                containerBox = ((SampleTableBox[])((MediaInformationBox[])((MediaBox[])containerBox.getBoxes("Media Box"))[0].getBoxes("Media Information Box"))[0].getBoxes("Sample Table Box"))[0];
                ChunkOffsetBox chunkOffsetBox = ((SampleTableBox)containerBox).getChunkOffsetBox();
                ((SampleTableBox)containerBox).setChunkOffsetBox(new DynamicChunkOffsetBox(chunkOffsetBox));
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IsoFile[");
        if (this.a == null) {
            stringBuffer.append("unparsed");
        } else {
            for (int j = 0; j < this.a.length; ++j) {
                if (j > 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(this.a[j].toString());
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void write(OutputStream boxArray) {
        OutputStream outputStream = null;
        try {
            outputStream = new IsoOutputStream((OutputStream)boxArray, false);
            boxArray = this.a;
            int n = this.a.length;
            for (int j = 0; j < n; ++j) {
                Box box = boxArray[j];
                box.getBox((IsoOutputStream)outputStream);
            }
            outputStream.flush();
        }
        catch (Exception exception) {}
        outputStream.flush();
    }

    public byte[] writeAndCalculateHash(OutputStream boxArray) {
        OutputStream outputStream = null;
        try {
            outputStream = new IsoOutputStream((OutputStream)boxArray, true);
            boxArray = this.a;
            int n = this.a.length;
            for (int j = 0; j < n; ++j) {
                Box box = boxArray[j];
                box.getBox((IsoOutputStream)outputStream);
            }
            outputStream.flush();
        }
        catch (Exception exception) {}
        outputStream.flush();
        return ((IsoOutputStream)outputStream).getHash();
    }
}

