/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IsoInputStream
extends InputStream {
    private InputStream a;
    private long a = null;

    public IsoInputStream(InputStream inputStream) {
        this.a = inputStream;
        this.a = 0L;
    }

    public long getStreamPosition() {
        return this.a;
    }

    public int read() {
        int n = this.a.read();
        if (n == -1) {
            throw new EOFException();
        }
        ++this.a;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.a.read(byArray, n, n2);
        if (n3 == -1) {
            throw new EOFException();
        }
        this.a += (long)n3;
        return n3;
    }

    public byte[] read(int n) {
        byte[] byArray = new byte[n];
        for (int j = 0; j < n; j += this.read(byArray, j, n - j)) {
        }
        return byArray;
    }

    public double readFixedPoint1616() {
        byte[] byArray = this.read(4);
        int n = 0 | byArray[0] << 24 & 0xFF000000;
        n |= byArray[1] << 16 & 0xFF0000;
        n |= byArray[2] << 8 & 0xFF00;
        return (double)(n |= byArray[3] & 0xFF) / 65536.0;
    }

    public float readFixedPoint88() {
        byte[] byArray = this.read(2);
        short s = (short)(0 | byArray[0] << 8 & 0xFF00);
        s = (short)(s | byArray[1] & 0xFF);
        return (float)s / 256.0f;
    }

    public String readIso639() {
        int n = this.readUInt16();
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < 3; ++j) {
            int n2 = n >> (2 - j) * 5 & 0x1F;
            stringBuffer.append((char)(n2 + 96));
        }
        return stringBuffer.toString();
    }

    public String readString() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.a.read()) != 0) {
            byteArrayOutputStream.write(n);
        }
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
    }

    public String readString(int n) {
        byte[] byArray = new byte[n];
        if (this.read(byArray) != n) {
            throw new EOFException();
        }
        return new String(byArray, "UTF-8");
    }

    public int readUInt16() {
        int n = 0 + (this.readUInt8() << 8);
        return n += this.readUInt8();
    }

    public int readUInt24() {
        int n = 0 + (this.readUInt16() << 8);
        return n += this.readUInt8();
    }

    public long readUInt32() {
        long l = 0L + ((long)this.readUInt16() << 16);
        return l += (long)this.readUInt16();
    }

    public long readUInt64() {
        long l = 0L + (this.readUInt32() << 32);
        if (l < 0L) {
            throw new IOException("I don't know how to deal with UInt64! long is not sufficient and I don't want to use BigInt");
        }
        return l += this.readUInt32();
    }

    public int readUInt8() {
        return this.read();
    }

    public long skip(long l) {
        int n = 0;
        while ((long)n < l) {
            long l2 = this.a.skip(l - (long)n);
            if (l2 == -1L) {
                throw new EOFException();
            }
            this.a += l2;
            n = (int)((long)n + l2);
        }
        return l;
    }
}

