/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxFactory;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoInputStream;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.FullBox;
import java.util.Hashtable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HandlerBox
extends FullBox {
    public static final Hashtable hm = new Hashtable<String, String>();
    public static final String TYPE = "hdlr";
    private long a;
    private long b;
    private long c;
    private String a;
    private String b = "";

    public HandlerBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public boolean contains(String string, String string2) {
        return string.indexOf(string2) != -1;
    }

    protected final void a(IsoOutputStream isoOutputStream) {
        isoOutputStream.writeUInt32(0L);
        isoOutputStream.write(IsoFile.fourCCtoBytes(this.a));
        isoOutputStream.writeUInt32(this.a);
        isoOutputStream.writeUInt32(this.b);
        isoOutputStream.writeUInt32(this.c);
        isoOutputStream.writeStringZeroTerm(this.b);
    }

    protected final long a() {
        return 21 + HandlerBox.utf8StringLengthInBytes(this.b);
    }

    public String getDisplayName() {
        return "Handler Box";
    }

    public String getHandlerType() {
        return this.a;
    }

    public String getHumanReadableTrackType() {
        if (hm.get(this.a) == null) {
            return "Unknown Handler Type";
        }
        return (String)hm.get(this.a);
    }

    public String getName() {
        return this.b;
    }

    public void parse(IsoInputStream isoInputStream, long l, BoxFactory boxFactory) {
        super.parse(isoInputStream, l, boxFactory);
        isoInputStream.readUInt32();
        this.a = IsoFile.bytesToFourCC(isoInputStream.read(4));
        this.a = isoInputStream.readUInt32();
        this.b = isoInputStream.readUInt32();
        this.c = isoInputStream.readUInt32();
        this.b = isoInputStream.readString((int)(l - 24L));
        if (this.contains(this.b, "\u0000")) {
            if (this.b.indexOf("\u0000") != this.b.length() - 1) {
                this.a = (long)this.b.substring(this.b.indexOf(0) + 1).getBytes("UTF-8");
                this.b = this.b.substring(0, this.b.indexOf(0) + 1);
            }
            this.b = this.b.substring(0, this.b.indexOf(0));
            return;
        }
        this.b = this.b.substring(1);
    }

    public void setHandlerType(String string) {
        this.a = string;
    }

    public void setName(String string) {
        this.b = string;
    }

    public String toString() {
        return "HandlerBox[handlerType=" + this.getHandlerType() + ";name=" + this.getName() + "]";
    }

    static {
        hm.put("odsm", "ObjectDescriptorStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("crsm", "ClockReferenceStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("sdsm", "SceneDescriptionStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("m7sm", "MPEG7Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("ocsm", "ObjectContentInfoStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("ipsm", "IPMP Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("mjsm", "MPEG-J Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("mdir", "Apple Meta Data iTunes Reader");
        hm.put("mp7b", "MPEG-7 binary XML");
        hm.put("mp7t", "MPEG-7 XML");
        hm.put("vide", "Video Track");
        hm.put("soun", "Sound Track");
        hm.put("hint", "Hint Track");
        hm.put("appl", "Apple specific");
        hm.put("meta", "Timed Metadata track - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
    }
}

