/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxFactory;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoInputStream;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.FullBox;
import java.io.IOException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SampleSizeBox
extends FullBox {
    public static final String TYPE = "stsz";
    private int[] a;
    private long a;
    private long b;

    public SampleSizeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected final void a(IsoOutputStream isoOutputStream) {
        isoOutputStream.writeUInt32(this.b);
        isoOutputStream.writeUInt32(this.a);
        if (this.b == 0L) {
            int n = 0;
            while ((long)n < this.a) {
                isoOutputStream.writeUInt32(this.a[n]);
                ++n;
            }
        }
    }

    protected final long a() {
        return 8 + (this.b != 0L ? 0 : this.a.length << 2);
    }

    public String getDisplayName() {
        return "Sample Size Box";
    }

    public int[] getEntrySize() {
        return this.a;
    }

    public long getSampleCount() {
        return this.a;
    }

    public long getSampleSize() {
        return this.b;
    }

    public long getSampleSizeAtIndex(int n) {
        if (this.b > 0L) {
            return this.b;
        }
        return this.a[n];
    }

    public void parse(IsoInputStream isoInputStream, long l, BoxFactory boxFactory) {
        super.parse(isoInputStream, l, boxFactory);
        this.b = isoInputStream.readUInt32();
        this.a = isoInputStream.readUInt32();
        if (this.a > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE samples!");
        }
        if (this.b == 0L) {
            this.a = new int[(int)this.a];
            byte[] byArray = new byte[(int)(l - 12L)];
            isoInputStream.read(byArray);
            int n = 0;
            while ((long)n < this.a) {
                this.a[n] = ((byArray[n << 2] >= 0 ? byArray[n << 2] : byArray[n << 2] + 256) << 24) + ((byArray[(n << 2) + 1] >= 0 ? byArray[(n << 2) + 1] : byArray[(n << 2) + 1] + 256) << 16) + ((byArray[(n << 2) + 2] >= 0 ? byArray[(n << 2) + 2] : byArray[(n << 2) + 2] + 256) << 8) + (byArray[(n << 2) + 3] >= 0 ? byArray[(n << 2) + 3] : byArray[(n << 2) + 3] + 256);
                ++n;
            }
        }
    }

    public void setEntrySize(int[] nArray) {
        this.a = nArray;
    }

    public void setEntrySize(int n, int n2) {
        if (this.a == null) {
            this.a = new int[(int)this.a];
            this.b = 0L;
        }
        this.a[n] = n2;
    }

    public void setSampleSize(int n) {
        this.b = n;
    }

    public String toString() {
        return "SampleSizeBox[sampleSize=" + this.getSampleSize() + ";sampleCount=" + this.getSampleCount() + "]";
    }
}

