/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxFactory;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoInputStream;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.FullBox;
import java.io.IOException;

public class SampleToChunkBox
extends FullBox {
    public static final String TYPE = "stsc";
    private long[] a;
    private long[] b;
    private long[] c;

    public SampleToChunkBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected final void a(IsoOutputStream isoOutputStream) {
        isoOutputStream.getStreamPosition();
        isoOutputStream.writeUInt32(this.a.length);
        for (int j = 0; j < this.a.length; ++j) {
            isoOutputStream.writeUInt32(this.a[j]);
            isoOutputStream.writeUInt32(this.c[j]);
            isoOutputStream.writeUInt32(this.b[j]);
        }
    }

    protected final long a() {
        return this.a.length * 12 + 4;
    }

    public String getDisplayName() {
        return "Sample to Chunk Box";
    }

    public long[] getFirstChunk() {
        return this.a;
    }

    public long[] getSampleDescriptionIndex() {
        return this.b;
    }

    public long[] getSamplesPerChunk() {
        return this.c;
    }

    public void parse(IsoInputStream isoInputStream, long l, BoxFactory boxFactory) {
        super.parse(isoInputStream, l, boxFactory);
        long l2 = isoInputStream.readUInt32();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.a = new long[(int)l2];
        this.c = new long[(int)l2];
        this.b = new long[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            this.a[n] = isoInputStream.readUInt32();
            this.c[n] = isoInputStream.readUInt32();
            this.b[n] = isoInputStream.readUInt32();
            ++n;
        }
    }

    public String toString() {
        return "SampleToChunkBox[entryCount=" + this.a.length + "]";
    }
}

