/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxFactory;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoInputStream;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.FullBox;
import java.io.IOException;

public class SyncSampleBox
extends FullBox {
    public static final String TYPE = "stss";
    private long[] a;

    public SyncSampleBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected final void a(IsoOutputStream isoOutputStream) {
        isoOutputStream.writeUInt32(this.a.length);
        long[] lArray = this.a;
        int n = this.a.length;
        for (int j = 0; j < n; ++j) {
            long l = lArray[j];
            isoOutputStream.writeUInt32(l);
        }
    }

    protected final long a() {
        return (this.a.length << 2) + 4;
    }

    public String getDisplayName() {
        return "Sync Sample Box";
    }

    public long[] getSampleNumber() {
        return this.a;
    }

    public void parse(IsoInputStream isoInputStream, long l, BoxFactory boxFactory) {
        super.parse(isoInputStream, l, boxFactory);
        long l2 = isoInputStream.readUInt32();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.a = new long[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            this.a[n] = isoInputStream.readUInt32();
            ++n;
        }
    }

    public String toString() {
        return "SyncSampleBox[entryCount=" + this.a.length + "]";
    }
}

