/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxFactory;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoInputStream;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.FullBox;
import java.io.IOException;

public class TimeToSampleBox
extends FullBox {
    public static final String TYPE = "stts";
    private long[] a;
    private long[] b;

    public TimeToSampleBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected final void a(IsoOutputStream isoOutputStream) {
        isoOutputStream.writeUInt32(this.a.length);
        for (int j = 0; j < this.a.length; ++j) {
            isoOutputStream.writeUInt32(this.a[j]);
            isoOutputStream.writeUInt32(this.b[j]);
        }
    }

    protected final long a() {
        return 4 + (this.a.length << 2) + (this.b.length << 2);
    }

    public String getDisplayName() {
        return "Decoding Time to Sample Box";
    }

    public long[] getSampleCount() {
        return this.a;
    }

    public long[] getSampleDelta() {
        return this.b;
    }

    public void parse(IsoInputStream isoInputStream, long l, BoxFactory boxFactory) {
        super.parse(isoInputStream, l, boxFactory);
        long l2 = isoInputStream.readUInt32();
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.a = new long[(int)l2];
        this.b = new long[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            this.a[n] = isoInputStream.readUInt32();
            this.b[n] = isoInputStream.readUInt32();
            ++n;
        }
    }

    public String toString() {
        return "TimeToSampleBox[entryCount=" + this.a.length + "]";
    }
}

