/*
 * Decompiled with CFR 0.152.
 */
package all;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MyString {
    public static final byte FONT_ID_SMALL = 0;
    public static final byte FONT_ID_LARGE = 1;
    private static final String[] STR_IMG_NAMES = new String[]{"font-small", "font-large"};
    private static Image[] imgFonts = new Image[STR_IMG_NAMES.length];
    private static final String[] STR_ALPHABETES = new String[]{" !\\\"#%&()*+,-./:;?|@_=><0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz \u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u03bf\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f \u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", " !\\\"#%&()*+,-./:;?|@_=><0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz \u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f \u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f"};
    private static final String[] STR_ALPHABETES_2UPPER_CASE = new String[]{"\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0451abcdefghijklmnopqrstuvwxyz", "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0401ABCDEFGHIJKLMNOPQRSTUVWXYZ"};
    public static final short CODE_SPACE = 0;
    private static final byte[] CHAR_SPACE_WIDTH = new byte[]{5, 8};
    private static final short[][] LETTERS_OFFSETS_X = new short[][]{{0, 2, 8, 13, 22, 34, 43, 47, 51, 57, 65, 68, 73, 75, 81, 83, 86, 92, 94, 105, 114, 122, 129, 136, 143, 149, 156, 163, 171, 178, 185, 192, 199, 206, 0, 9, 16, 24, 32, 39, 46, 54, 62, 66, 71, 78, 85, 94, 102, 111, 118, 127, 135, 142, 150, 158, 167, 179, 186, 194, 201, 0, 7, 14, 20, 27, 34, 39, 46, 53, 55, 59, 65, 67, 77, 84, 91, 98, 105, 110, 116, 122, 129, 135, 145, 151, 157, 163, 0, 9, 16, 23, 30, 39, 46, 53, 65, 72, 80, 88, 95, 104, 113, 121, 130, 138, 145, 153, 161, 168, 178, 185, 193, 201, 213, 226, 235, 245, 252, 260, 271, 279, 0, 7, 14, 20, 26, 34, 41, 48, 58, 63, 70, 77, 83, 90, 97, 104, 111, 118, 125, 131, 137, 143, 153, 159, 167, 174, 184, 195, 203, 211, 217, 224, 234, 241}, {0, 3, 9, 17, 27, 40, 52, 57, 63, 70, 79, 83, 89, 93, 99, 103, 107, 116, 119, 135, 146, 156, 163, 171, 180, 187, 196, 204, 213, 222, 231, 240, 249, 258, 0, 11, 22, 33, 44, 54, 64, 76, 87, 91, 100, 111, 121, 134, 144, 156, 166, 178, 189, 200, 210, 220, 231, 247, 258, 269, 279, 0, 9, 18, 26, 36, 45, 51, 60, 69, 73, 78, 86, 90, 102, 111, 121, 130, 140, 146, 155, 161, 169, 178, 192, 200, 210, 219, 0, 11, 22, 33, 41, 54, 64, 74, 89, 99, 109, 119, 128, 139, 151, 162, 174, 184, 194, 205, 215, 225, 238, 249, 261, 271, 285, 301, 315, 329, 340, 351, 366, 377, 0, 8, 17, 27, 32, 43, 52, 61, 73, 82, 90, 99, 107, 117, 127, 136, 145, 153, 162, 171, 180, 189, 203, 212, 222, 230, 242, 255, 267, 279, 288, 297, 309, 319}};
    private static final byte[][] LETTERS_OFFSETS_Y_INDEXES = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}};
    public static final short[] FONT_HEIGHT = new short[]{14, 17};
    public static final short[] FONT_LETTER_SPACE = new short[]{0, 0};
    public static final byte PARSE_TYPE_BREAK = 0;
    public static final byte PARSE_TYPE_CONTINUE = 1;
    public static final byte PARSE_TYPE_CUT = 2;
    public static final byte PARSE_TYPE_CUT_DOTS = 3;
    private byte parseType = 0;
    private byte[][] bText;
    public static final int SIZE_OF_SHORT = 2;
    public short amountLines = 0;
    public byte curFontID = 0;
    public short curWidth = 0;
    private byte curFontID2 = 0;
    private short curWidth2 = 0;

    public MyString(String string, int n, int n2, byte by) {
        int n3;
        MyString.initFont(n);
        String[] stringArray = MyString.cutStringToSubStrings(string, "\n");
        Vector<byte[]> vector = new Vector<byte[]>();
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            byte[][] byArray = this.createLine(stringArray[n3], n, n2, by);
            for (int i = 0; i < byArray.length; ++i) {
                vector.addElement(byArray[i]);
            }
            byArray = (byte[][])MyString.clearArray((Object[])byArray);
        }
        this.bText = new byte[vector.size()][];
        for (n3 = 0; n3 < vector.size(); ++n3) {
            this.bText[n3] = (byte[])vector.elementAt(n3);
        }
        this.parseType = by;
        this.curFontID = this.curFontID2 = (byte)n;
        this.curWidth = this.curWidth2 = (short)n2;
        this.amountLines = (short)this.bText.length;
    }

    private byte[][] createLine(String string, int n, int n2, byte by) {
        Object object = null;
        switch (by) {
            case 0: {
                object = this.parseText(string, n, n2);
                break;
            }
            case 1: {
                object = this.parseText(string, n, Short.MAX_VALUE);
                break;
            }
            case 2: {
                byte[][] byArray = this.parseText(string, n, n2);
                object = new byte[1][];
                object[0] = byArray[0];
                byArray = (byte[][])MyString.clearArray((Object[])byArray);
                break;
            }
            case 3: {
                object = new byte[1][];
                byte[][] byArray = this.parseText(string, n, n2);
                if (byArray.length >= 2) {
                    int n3 = 3 * this.getCharWidth('.', n);
                    int n4 = MyString.getIndexLetter('.', n);
                    byArray = (byte[][])MyString.clearArray((Object[])byArray);
                    byArray = this.parseText(string, n, n2 - n3);
                    object[0] = new byte[2 + byArray[0].length + 3];
                    System.arraycopy(byArray[0], 0, object[0], 0, byArray[0].length);
                    byte by2 = (byte)n4;
                    object[0][byArray[0].length + 2] = by2;
                    object[0][byArray[0].length + 1] = by2;
                    object[0][byArray[0].length] = by2;
                    short s = this.getLineWidth(byArray[0]);
                    object[0][0] = (byte)((s + n3) / 256);
                    object[0][1] = (byte)((s + n3) % 256);
                } else {
                    object[0] = byArray[0];
                }
                byArray = (byte[][])MyString.clearArray((Object[])byArray);
            }
        }
        return object;
    }

    public void destroy() {
        this.bText = (byte[][])MyString.clearArray((Object[])this.bText);
    }

    public static void initFonts() {
        for (int i = 0; i < imgFonts.length; ++i) {
            MyString.initFont(i);
        }
    }

    private static void initFont(int n) {
        if (imgFonts[n] != null) {
            return;
        }
        String string = "/" + STR_IMG_NAMES[n] + ".png";
        try {
            MyString.imgFonts[n] = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            System.out.println("Can't to load file: " + string);
            iOException.printStackTrace();
        }
    }

    public int getHeight() {
        return FONT_HEIGHT[this.curFontID];
    }

    private byte getCharWidth(char c, int n) {
        int n2 = MyString.getIndexLetter(c, n);
        if (n2 == -1 || n2 == 0) {
            return CHAR_SPACE_WIDTH[n];
        }
        int n3 = LETTERS_OFFSETS_X[n][n2] - LETTERS_OFFSETS_X[n][n2 - 1] + FONT_LETTER_SPACE[n];
        return (byte)n3;
    }

    public short getLineWidth(int n) {
        if (n >= this.bText.length) {
            System.out.println("ERROR!!! getLineWidth: Invalide indxLine = " + n);
            return -1;
        }
        return this.getLineWidth(this.bText[n]);
    }

    private short getLineWidth(byte[] byArray) {
        short s = (short)(byArray[0] & 0xFF);
        short s2 = (short)(byArray[1] & 0xFF);
        return (short)((s << 8) + s2);
    }

    private byte[][] parseText(String string, int n, int n2) {
        String string2;
        int n3;
        int n4;
        if (string == null) {
            System.out.println("ERROR in parseTextNew!!! TEXT FOR PARSE IS EMPTY");
            return new byte[0][];
        }
        if (string.trim().equals("")) {
            byte[][] byArray = new byte[1][3];
            return byArray;
        }
        if (string.indexOf(10) != -1) {
            System.out.println("ERROR in parseTextNew!!! TEXT FOR PARSE IS CONTAINS EOL SYMBOL");
            return new byte[0][];
        }
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n5 = 0;
        int n6 = -1;
        int n7 = n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n3 = string.charAt(i);
            byte by = this.getCharWidth((char)n3, n);
            if (n2 <= n4 + by) {
                if (n6 <= n5) {
                    if (n2 == n4 + by) {
                        --i;
                    }
                    if (!(string2 = string.substring(n5, i)).trim().equals("")) {
                        vector.addElement(string2);
                        vector2.addElement(new Integer(n4 + (n2 == n4 + by ? (byte)0 : by)));
                    }
                    n5 = i + 1;
                    n6 = i;
                    n4 = 0;
                    continue;
                }
                string2 = string.substring(n5, n6 + 1);
                if (!string2.trim().equals("")) {
                    vector.addElement(string2);
                    vector2.addElement(new Integer(n7));
                }
                i = n6;
                n5 = i + 1;
                n4 = 0;
                continue;
            }
            n4 += by;
            switch (n3) {
                case 32: 
                case 33: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 58: 
                case 59: 
                case 63: {
                    n6 = i;
                    n7 = n4 - by;
                }
            }
        }
        String string3 = string.substring(n5);
        if (!string3.trim().equals("")) {
            vector.addElement(string3);
            vector2.addElement(new Integer(n4));
        }
        byte[][] byArrayArray = new byte[vector.size()][];
        for (n3 = 0; n3 < byArrayArray.length; ++n3) {
            String string4 = (String)vector.elementAt(n3);
            string2 = string4.trim();
            int n8 = CHAR_SPACE_WIDTH[n] * (string4.length() - string2.length());
            string4 = string2;
            byArrayArray[n3] = new byte[string4.length() + 2];
            short s = (short)(((Integer)vector2.elementAt(n3)).shortValue() - n8);
            byArrayArray[n3][0] = (byte)(s / 256);
            byArrayArray[n3][1] = (byte)(s % 256);
            for (int i = 0; i < string4.length(); ++i) {
                int n9 = MyString.getIndexLetter(string4.charAt(i), n);
                if (n9 == -1) {
                    n9 = 0;
                }
                byArrayArray[n3][i + 2] = (byte)n9;
            }
        }
        return byArrayArray;
    }

    public void drawLines(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 > this.bText.length || n4 >= this.bText.length || n3 > n4) {
            System.out.println("ERROR!!! drawFromLine: StartLine = " + n3 + "; EndLine = " + n4);
            return;
        }
        for (int i = n3; i <= n4; ++i) {
            int n7 = n2 + (i - n3) * n6;
            this.drawLine(graphics, n, n7, i, n5);
        }
    }

    public void drawLines(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.drawLines(graphics, n, n2, n3, n4, n5, FONT_HEIGHT[this.curFontID]);
    }

    public void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = n + this.getOffsetLineXAnchor(n3, n4);
        int n10 = n2;
        this.checkTextParams();
        if (n3 >= this.bText.length) {
            System.out.println("ERROR!!! drawLine: Invalide curLine = " + n3);
            return;
        }
        for (int i = 2; i < this.bText[n3].length; ++i) {
            n9 += this.drawChar(graphics, this.bText[n3][i] & 0xFF, n9, n10);
            graphics.setClip(n5, n6, n7, n8);
        }
    }

    private int drawChar(Graphics graphics, int n, int n2, int n3) {
        if (n == 0) {
            return CHAR_SPACE_WIDTH[this.curFontID];
        }
        short s = LETTERS_OFFSETS_X[this.curFontID][n - 1];
        int n4 = LETTERS_OFFSETS_X[this.curFontID][n] - s;
        int n5 = FONT_HEIGHT[this.curFontID] * LETTERS_OFFSETS_Y_INDEXES[this.curFontID][n];
        short s2 = FONT_HEIGHT[this.curFontID];
        graphics.clipRect(n2, n3, n4, (int)s2);
        if (imgFonts[this.curFontID] != null) {
            graphics.drawImage(imgFonts[this.curFontID], n2 - s, n3 - n5, 20);
        }
        return n4 + FONT_LETTER_SPACE[this.curFontID];
    }

    private static int getIndexLetter(char c, int n) {
        return STR_ALPHABETES[n].indexOf(c);
    }

    private int getOffsetLineXAnchor(int n, int n2) {
        switch (n2 & 0xD) {
            case 4: {
                return 0;
            }
            case 8: {
                return -this.getLineWidth(this.bText[n]);
            }
            case 1: {
                return -this.getLineWidth(this.bText[n]) >> 1;
            }
        }
        System.out.println("Error! Invalide value of anchor point = " + n2);
        return 0;
    }

    public char getFirstCharAtLine(int n) {
        if (n >= this.bText.length) {
            System.out.println("ERROR!!! getStringLine: Invalide curLine = " + n);
            return '\u0000';
        }
        int n2 = this.bText[n][2] & 0xFF;
        if (n2 == 0) {
            return ' ';
        }
        return STR_ALPHABETES[this.curFontID].charAt(n2);
    }

    public static String debugGetStringLine_(int n, byte[][] byArray, int n2) {
        if (n >= byArray.length) {
            System.out.println("ERROR!!! getStringLine: Invalide curLine = " + n);
            return "";
        }
        String string = "";
        for (int i = 2; i < byArray[n].length; ++i) {
            int n3 = byArray[n][i] & 0xFF;
            string = n3 == 0 ? string + " " : string + STR_ALPHABETES[n2].charAt(n3);
        }
        return string;
    }

    public String getStringLine(int n) {
        if (n >= this.bText.length) {
            System.out.println("ERROR!!! getStringLine: Invalide curLine = " + n);
            return "";
        }
        String string = "";
        for (int i = 2; i < this.bText[n].length; ++i) {
            int n2 = this.bText[n][i] & 0xFF;
            string = n2 == 0 ? string + " " : string + STR_ALPHABETES[this.curFontID].charAt(n2);
        }
        return string;
    }

    public String getStringAll() {
        String string = "";
        for (int i = 0; i < this.bText.length; ++i) {
            string = string + this.getStringLine(i) + "\n";
        }
        return string;
    }

    private void checkTextParams() {
        if (this.curFontID != this.curFontID2 || this.curWidth != this.curWidth2) {
            this.curFontID2 = this.curFontID;
            this.curWidth2 = this.curWidth;
        }
    }

    public byte[] getIndexedLine(int n) {
        if (n < 0 || n >= this.amountLines) {
            System.out.println("getIndexedLine: Invalide of required line number");
            return null;
        }
        return this.bText[n];
    }

    public void addLine(String string, boolean bl) {
        byte[][] byArray = this.createLine(string, this.curFontID, this.curWidth, this.parseType);
        byte[][] byArrayArray = new byte[this.bText.length + 1][];
        int n = bl ? 1 : 0;
        for (int i = 0; i < this.bText.length; ++i) {
            byArrayArray[i + n] = this.bText[i];
        }
        byArrayArray[bl ? 0 : this.bText.length] = byArray[0];
        byArray = (byte[][])MyString.clearArray((Object[])byArray);
        this.bText = (byte[][])MyString.clearArray((Object[])this.bText);
        this.bText = byArrayArray;
        this.amountLines = (short)this.bText.length;
    }

    public void deleteLine(int n) {
        if (n < 0 || n >= this.amountLines) {
            System.out.println("deleteStringLine: Invalide of required line number");
            return;
        }
        byte[][] byArrayArray = new byte[this.bText.length - 1][];
        int n2 = 0;
        for (int i = 0; i < this.bText.length; ++i) {
            if (i == n) continue;
            byArrayArray[n2] = this.bText[i];
            ++n2;
        }
        this.bText = (byte[][])MyString.clearArray((Object[])this.bText);
        this.bText = byArrayArray;
        this.amountLines = (short)this.bText.length;
    }

    public static String[] cutStringToSubStrings(String string, String string2) {
        int n;
        if (string == null || string2 == null || string.trim().equals("")) {
            System.out.println("cutStringToSubStrings: Error in arguments value");
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = string.indexOf(string2, i);
            if (n == -1) {
                vector.addElement(string.substring(n2));
                break;
            }
            vector.addElement(string.substring(n2, n));
            n2 = n + string2.length();
            i = n2 - 1;
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public static Object[] clearArray(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = null;
            }
        }
        objectArray = null;
        return objectArray;
    }

    public static String toUpperCase(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = STR_ALPHABETES_2UPPER_CASE[0].indexOf(c);
            string2 = n == -1 ? string2 + c : string2 + STR_ALPHABETES_2UPPER_CASE[1].charAt(n);
        }
        return string2;
    }

    public int searchLineWithFirstSymbol(char c) {
        char c2 = c;
        char c3 = c;
        int n = STR_ALPHABETES_2UPPER_CASE[0].indexOf(c);
        if (n == -1) {
            n = STR_ALPHABETES_2UPPER_CASE[1].indexOf(c);
        }
        if (n != -1) {
            c2 = STR_ALPHABETES_2UPPER_CASE[1].charAt(n);
            c3 = STR_ALPHABETES_2UPPER_CASE[0].charAt(n);
        }
        int n2 = -1;
        for (int i = 0; i < this.bText.length; ++i) {
            char c4 = this.getFirstCharAtLine(i);
            if (c4 != c2 && c4 != c3) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public static String sliceTwiddles(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            string2 = string.charAt(i) == '~' ? string2 + ' ' : string2 + string.charAt(i);
        }
        return string2;
    }
}

