/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.mixtools.resources;

import com.mcf.mixtools.common.SystemTools;
import com.mcf.mixtools.http.HttpManager;
import com.mcf.mixtools.storage.RmsManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class ResourceReader {
    protected MIDlet midlet;
    protected static final short XOR_SECRET_1 = 7;
    private static final String RESOURCE = "/zx.res";
    private long[] ofsMessages;
    private long ofsHelp;
    private long[] ofsCards;
    public String[] msgCapNames;
    public String[] cardCapNames;
    public int[] msgSecIds;
    public int[] cardSecIds;
    public int[] msgIds;
    public short[] cardSecLengths;
    public int[] cardIds;
    public boolean initialized;
    private static InputStream in;
    private static long ofs;
    public static final byte[] CARD_TYPES;
    public byte currentCardType;
    private static final short DEFAULT_CARD_SIZE = 20;
    private static int oneCardSize;
    public byte[] cardByteData = null;

    public ResourceReader(MIDlet mIDlet) {
        this.midlet = mIDlet;
        this.currentCardType = 0;
        this.initialRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialRead() {
        this.initialized = false;
        try {
            in = this.midlet.getClass().getResourceAsStream(RESOURCE);
            ofs = 0L;
            try {
                byte[] byArray = new byte[4];
                in.read(byArray, 0, 4);
                if (!"MCs0".equals(new String(byArray))) {
                    return;
                }
                byArray = null;
                ofs += 4L;
                this.preReadMessages();
                this.preReadHelp();
                this.preReadCards();
            }
            catch (Throwable throwable) {
            }
            finally {
                in.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.initialized = false;
            return;
        }
        this.initialized = true;
    }

    private void preReadMessages() throws RuntimeException, IOException {
        short s = this.readShort();
        if (s <= 0) {
            throw new RuntimeException();
        }
        this.msgCapNames = new String[s];
        this.ofsMessages = new long[s];
        this.msgSecIds = new int[s];
        for (short s2 = 0; s2 < s; s2 = (short)((byte)(s2 + 1))) {
            this.ofsMessages[s2] = ofs;
            this.msgSecIds[s2] = this.readInt();
            short s3 = this.readShort();
            this.msgCapNames[s2] = this.readString(s3);
            int n = this.readShort();
            for (int i = 0; i < n; ++i) {
                short s4 = this.readShort();
                this.skip(s4);
            }
        }
    }

    private void preReadHelp() throws RuntimeException, IOException {
        this.ofsHelp = ofs;
        short s = this.readShort();
        this.skip(s);
    }

    private void preReadCards() throws RuntimeException, IOException {
        short s = this.readShort();
        this.cardIds = new int[0];
        if (s <= 0) {
            throw new RuntimeException();
        }
        this.cardCapNames = new String[s];
        this.ofsCards = new long[s];
        this.cardSecIds = new int[s];
        this.cardSecLengths = new short[s];
        for (short s2 = 0; s2 < s; s2 = (short)((byte)(s2 + 1))) {
            int n;
            int n2;
            int n3;
            int n4;
            this.ofsCards[s2] = ofs;
            this.cardSecIds[s2] = n4 = this.readInt();
            short s3 = this.readShort();
            this.cardCapNames[s2] = this.readString(s3);
            this.cardSecLengths[s2] = n3 = this.readShort();
            int[] nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = n = this.readInt();
                short s4 = this.readShort();
                this.skip(s4);
                int n5 = this.readInt();
                this.skip(n5);
            }
            n2 = this.cardIds.length;
            n = nArray.length;
            int[] nArray2 = new int[n2];
            System.arraycopy(this.cardIds, 0, nArray2, 0, n2);
            this.cardIds = new int[n2 + n];
            System.arraycopy(nArray2, 0, this.cardIds, 0, nArray2.length);
            System.arraycopy(nArray, 0, this.cardIds, nArray2.length, nArray.length);
            nArray2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readHelp(String string) {
        try {
            in = this.midlet.getClass().getResourceAsStream(RESOURCE);
            in.skip(this.ofsHelp);
            String string2 = this.readString();
            return string2;
        }
        catch (Throwable throwable) {
            String string3 = string;
            return string3;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            in = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readCardList(short s) {
        String[] stringArray = null;
        try {
            in = this.midlet.getClass().getResourceAsStream(RESOURCE);
            in.skip(this.ofsCards[s]);
            this.skip(4);
            short s2 = this.readShort();
            this.skip(s2);
            short s3 = this.readShort();
            stringArray = new String[s3];
            for (short s4 = 0; s4 < s3; s4 = (short)(s4 + 1)) {
                this.skip(4);
                stringArray[s4] = this.readString();
                int n = this.readInt();
                this.skip(n);
            }
        }
        catch (Throwable throwable) {
            String[] stringArray2 = null;
            return stringArray2;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            in = null;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readMessageList(short s) {
        String[] stringArray = null;
        try {
            in = this.midlet.getClass().getResourceAsStream(RESOURCE);
            in.skip(this.ofsMessages[s]);
            this.skip(4);
            this.readString();
            short s2 = this.readShort();
            stringArray = new String[s2];
            for (short s3 = 0; s3 < s2; s3 = (short)(s3 + 1)) {
                stringArray[s3] = this.readString().replace('/', '\n');
            }
        }
        catch (Throwable throwable) {
            String[] stringArray2 = null;
            return stringArray2;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            in = null;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readCardPicture(short s, short s2) {
        try {
            in = this.midlet.getClass().getResourceAsStream(RESOURCE);
            in.skip(this.ofsCards[s]);
            this.skip(4);
            short s3 = this.readShort();
            this.skip(s3);
            short s4 = this.readShort();
            for (short s5 = 0; s5 < s4; s5 = (short)(s5 + 1)) {
                this.skip(4);
                short s6 = this.readShort();
                this.skip(s6);
                int n = this.readInt();
                if (s5 != s2) continue;
                if (n == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = this.readBytes(n);
                return byArray;
            }
        }
        catch (Throwable throwable) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            in = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCardPicture(short s, short s2) {
        int n;
        try {
            in = this.midlet.getClass().getResourceAsStream(RESOURCE);
            in.skip(this.ofsCards[s]);
            this.skip(4);
            this.skip(this.readShort());
            short s3 = this.readShort();
            n = 0;
            for (short s4 = 0; s4 < s3; s4 = (short)(s4 + 1)) {
                this.skip(4);
                this.skip(this.readShort());
                n = this.readInt();
                if (s4 == s2) {
                    boolean bl = n != 0;
                    return bl;
                }
                this.skip(n);
            }
        }
        catch (Throwable throwable) {
            n = 0;
            return n != 0;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            in = null;
            System.gc();
        }
        return false;
    }

    public int getCardId(short s, short s2) {
        short s3 = 0;
        for (short s4 = 0; s4 < s; s4 = (short)(s4 + 1)) {
            s3 = (short)(s3 + this.cardSecLengths[s4]);
        }
        return this.cardIds[s3 + s2];
    }

    public String[] readMessageSections() {
        String[] stringArray = new String[this.ofsMessages.length];
        for (int i = 0; i < this.ofsMessages.length; ++i) {
            stringArray[i] = this.msgCapNames[i];
        }
        return stringArray;
    }

    public String[] readCardSections() {
        String[] stringArray = new String[this.ofsCards.length];
        for (int i = 0; i < this.ofsCards.length; ++i) {
            stringArray[i] = this.cardCapNames[i];
        }
        return stringArray;
    }

    private byte getXorSecret() {
        return (byte)(SystemTools.getXorPart2() + 7);
    }

    private byte readByte() throws IOException {
        byte[] byArray = new byte[1];
        in.read(byArray);
        ++ofs;
        return this.decode(byArray[0]);
    }

    private short readShort() throws IOException {
        byte[] byArray = new byte[2];
        in.read(byArray);
        ofs += 2L;
        short s = (short)(this.byteFix(this.decode(byArray[0])) + (this.byteFix(this.decode(byArray[1])) << 8));
        byArray = null;
        return s;
    }

    private int readInt() throws IOException {
        byte[] byArray = new byte[4];
        in.read(byArray);
        ofs += 4L;
        int n = this.byteFix(this.decode(byArray[0])) + (this.byteFix(this.decode(byArray[1])) << 8) + (this.byteFix(this.decode(byArray[2])) << 16) + (this.byteFix(this.decode(byArray[3])) << 24);
        byArray = null;
        return n;
    }

    private short byteFix(byte n) {
        return (short)(n < 0 ? 256 + n : n);
    }

    private String readString() throws IOException {
        short s = this.readShort();
        return this.readString(s);
    }

    private byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        in.read(byArray);
        ofs += (long)n;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.decode(byArray[i]);
        }
        return byArray;
    }

    private String readString(int n) throws IOException {
        try {
            byte[] byArray = this.readBytes(n);
            return SystemTools.fixUtf8(byArray).toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "";
        }
    }

    private void skip(int n) throws IOException {
        in.skip(n);
        ofs += (long)n;
    }

    private byte decode(byte by) {
        return (byte)(by ^ this.getXorSecret());
    }

    private void dump(byte[] byArray) {
    }

    public final void setCardTypeNum(byte by) {
        this.currentCardType = by;
    }

    public final byte getCardType() {
        return CARD_TYPES[this.currentCardType];
    }

    public final String makeCardUrl(int n) {
        return this.makeCardUrl(n, null);
    }

    public final String makeCardUrl(int n, String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(SystemTools.propName("/h8dt{xtrHp I:?9/M9/q"));
            stringBuffer.append(SystemTools.propName("6c*BovRrmYe\u007f"));
            stringBuffer.append('.');
            stringBuffer.append(SystemTools.propName("OryYoFUsTgcXmoTgnrhtc_e8Ynl[tnc.e*rV-ux"));
            stringBuffer.append('/');
            stringBuffer.append(SystemTools.propName("Uf@JrEIe Ee|"));
            stringBuffer.append('/');
            stringBuffer.append("-");
            stringBuffer.append('/');
            stringBuffer.append("" + n);
            stringBuffer.append('/');
            stringBuffer.append(new Integer(this.getCardType()).toString());
            stringBuffer.append('/');
            stringBuffer.append("img");
            stringBuffer.append('.');
            stringBuffer.append("jpg");
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public int getCardRmsIdByNum(byte by, byte by2) {
        return by2 + 100 * by;
    }

    public int getCardIdByNum(byte by, byte by2) {
        return this.getCardId(by, by2);
    }

    public final String getCardName(byte by, byte by2) {
        return this.readCardList(by)[by2];
    }

    public final Image loadCard(byte by, byte by2) {
        Image image = null;
        this.cardByteData = null;
        int n = this.getCardIdByNum(by, by2);
        boolean bl = false;
        this.cardByteData = this.readCardFromResource(by, by2);
        System.gc();
        if (this.cardByteData == null) {
            if (RmsManager.useRms()) {
                this.cardByteData = RmsManager.read((byte)1, n);
                System.gc();
            }
            if (this.cardByteData == null) {
                String string = null;
                string = this.makeCardUrl(n);
                try {
                    this.cardByteData = HttpManager.doGet(string);
                    System.gc();
                    bl = true;
                }
                catch (Throwable throwable) {
                    this.cardByteData = null;
                    System.gc();
                    return null;
                }
            }
        }
        try {
            if (this.cardByteData != null) {
                image = Image.createImage((byte[])this.cardByteData, (int)0, (int)this.cardByteData.length);
                System.gc();
            }
        }
        catch (Throwable throwable) {
            this.cardByteData = null;
            return null;
        }
        if (bl && RmsManager.useRms() && RmsManager.getFreeBytes((byte)1) > (long)this.cardByteData.length) {
            RmsManager.store((byte)1, n, this.cardByteData);
        }
        return image;
    }

    public static final int getAvailableCards() {
        int n = (int)(RmsManager.getFreeBytes((byte)1) / (long)oneCardSize);
        return n;
    }

    public boolean isCardExists(byte by, byte by2) {
        if (this.checkCardInSharedResource(by, by2)) {
            return true;
        }
        if (this.checkCardInDedicatedResource(by, by2)) {
            return true;
        }
        return RmsManager.check((byte)1, this.getCardIdByNum(by, by2));
    }

    private byte[] readCardFromResource(byte by, byte by2) {
        byte[] byArray = null;
        byArray = this.readCardFromSharedResource(by, by2);
        if (byArray == null) {
            byArray = this.readCardFromDedicatedResource(by, by2);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readCardFromDedicatedResource(byte by, byte by2) {
        try {
            String string = "/c/" + by + "-" + by2 + ".png";
            InputStream inputStream = this.midlet.getClass().getResourceAsStream(string);
            int n = inputStream.available();
            if (n == 0) {
                n = 1024;
            }
            byte[] byArray = new byte[n];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            try {
                int n2;
                while ((n2 = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
            }
            finally {
                inputStream.close();
                inputStream = null;
                byArray = null;
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (NullPointerException nullPointerException) {}
        finally {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCardInDedicatedResource(byte by, byte by2) {
        InputStream inputStream = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("/c/");
            stringBuffer.append(by);
            stringBuffer.append('-');
            stringBuffer.append(by2);
            stringBuffer.append(".png");
            inputStream = this.midlet.getClass().getResourceAsStream(stringBuffer.toString());
            stringBuffer = null;
            inputStream.close();
            inputStream = null;
            boolean bl = true;
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (inputStream != null) {
                inputStream = null;
            }
        }
        return false;
    }

    private boolean checkCardInSharedResource(byte by, byte by2) {
        return this.checkCardPicture(by, by2);
    }

    private byte[] readCardFromSharedResource(byte by, byte by2) {
        return this.readCardPicture(by, by2);
    }

    public final byte[] readCard(byte by, byte by2) {
        byte[] byArray = this.readCardFromResource(by, by2);
        if (byArray != null) {
            return byArray;
        }
        try {
            byArray = RmsManager.read((byte)1, this.getCardIdByNum(by, by2));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byArray;
    }

    static {
        CARD_TYPES = new byte[]{17, 25, 10};
        oneCardSize = 20480;
    }
}

