/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.mixtools.storage;

import java.io.UnsupportedEncodingException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class RmsManager {
    private static final long MINIMUM_RMS = 100000L;
    private static RecordStore rsPrefs = null;
    private static RecordStore rsCards = null;
    private static RecordStore rsPhones = null;
    private static final String RS_PREFS = "Prefs";
    private static final String RS_CARDS = "Cards";
    private static final String RS_PHONES = "Phones";
    public static final byte STOR_PREFS = 0;
    public static final byte STOR_CARDS = 1;
    public static final byte STOR_PHONES = 2;
    private static final String RS_FAKE = "Fake";

    public static void open() {
        try {
            rsPrefs = RecordStore.openRecordStore((String)RmsManager.getRsName(RS_PREFS), (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            rsCards = RecordStore.openRecordStore((String)RmsManager.getRsName(RS_CARDS), (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            rsPhones = RecordStore.openRecordStore((String)RmsManager.getRsName(RS_PHONES), (boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void flush() {
        try {
            RmsManager.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Thread.sleep(100L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RmsManager.open();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getFreeBytes(String string, boolean bl) {
        long l = -1L;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            l = recordStore.getSizeAvailable();
            recordStore.closeRecordStore();
            if (!bl) return l;
        }
        catch (Throwable throwable) {
            try {
                long l2 = -1L;
                return l2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (bl) {
                    try {
                        RecordStore.deleteRecordStore((String)string);
                    }
                    catch (Throwable throwable3) {}
                }
            }
        }
        try {
            RecordStore.deleteRecordStore((String)string);
            return l;
        }
        catch (Throwable throwable) {
            return l;
        }
    }

    public static long getFreeBytes(String string) {
        return RmsManager.getFreeBytes(string, false);
    }

    public static long getFreeBytes(byte by) {
        return RmsManager.getFreeBytes(RmsManager.getStorageName(by), false);
    }

    public static long getFreeBytes() {
        return RmsManager.getFreeBytes(RmsManager.getRsName(RS_FAKE), true);
    }

    public static void store(byte by, int n, byte[] byArray) {
        try {
            RecordStore recordStore = RmsManager.getStorage(by);
            int n2 = byArray.length;
            byte[] byArray2 = RmsManager.createRecordBytes(n, byArray);
            for (int i = 0; i < 5; ++i) {
                byte by2 = byArray2[i];
            }
            recordStore.addRecord(byArray2, 0, n2 + 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte[] read(byte by, int n) {
        try {
            RecordStore recordStore = RmsManager.getStorage(by);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                if (RmsManager.bytes2int(byArray[0], byArray[1], byArray[2], byArray[3]) != n) continue;
                int n2 = byArray.length - 4;
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 4, byArray2, 0, n2);
                recordEnumeration = null;
                recordStore = null;
                return byArray2;
            }
            recordEnumeration = null;
            recordStore = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean check(byte by, int n) {
        try {
            byte[] byArray;
            RecordStore recordStore = RmsManager.getStorage(by);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            do {
                if (recordEnumeration.hasNextElement()) continue;
                return false;
            } while (RmsManager.bytes2int((byArray = recordEnumeration.nextRecord())[0], byArray[1], byArray[2], byArray[3]) != n);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String[] readPhones() {
        String[] stringArray = new String[]{};
        try {
            RecordStore recordStore = RmsManager.getStorage((byte)2);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                try {
                    String string = null;
                    try {
                        string = new String(recordEnumeration.nextRecord(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        try {
                            string = new String(recordEnumeration.nextRecord(), "UTF8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException2) {
                            string = new String(recordEnumeration.nextRecord());
                        }
                    }
                    String[] stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length] = string;
                    stringArray = stringArray2;
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringArray;
    }

    public static void addPhone(String string) {
        try {
            RecordStore recordStore = RmsManager.getStorage((byte)2);
            byte[] byArray = string.getBytes("UTF-8");
            recordStore.addRecord(byArray, 0, byArray.length);
            byArray = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void deletePhone(String string) {
        try {
            RecordStore recordStore = RmsManager.getStorage((byte)2);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                int n = recordStore.getNextRecordID();
                String string2 = new String(recordEnumeration.nextRecord());
                if (!string.equals(string2)) continue;
                recordStore.deleteRecord(n);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int bytes2int(byte[] byArray) {
        return RmsManager.byteFix(byArray[0]) + (RmsManager.byteFix(byArray[1]) << 8) + (RmsManager.byteFix(byArray[2]) << 16) + (RmsManager.byteFix(byArray[3]) << 24);
    }

    private static int bytes2int(byte by, byte by2, byte by3, byte by4) {
        return RmsManager.byteFix(by) + (RmsManager.byteFix(by2) << 8) + (RmsManager.byteFix(by3) << 16) + (RmsManager.byteFix(by4) << 24);
    }

    private static short byteFix(byte n) {
        return (short)(n < 0 ? 256 + n : n);
    }

    private static RecordStore getStorage(byte by) {
        return by == 2 ? rsPhones : (by == 1 ? rsCards : rsPrefs);
    }

    private static String getStorageName(byte by) {
        return by == 2 ? RmsManager.getRsName(RS_PHONES) : (by == 1 ? RmsManager.getRsName(RS_CARDS) : RmsManager.getRsName(RS_PREFS));
    }

    public static void delete(String string, long l) {
    }

    public static void close() {
        try {
            rsPrefs.closeRecordStore();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            rsCards.closeRecordStore();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static byte[] createRecordBytes(int n, byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 4];
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        int n3 = n;
        for (int n4 = 0; n4 < 4; n4 = (int)((byte)(n4 + 1))) {
            int n5 = n3 >> 8;
            System.out.println("byte " + (n4 + 1) + ": " + (n3 - (n5 << 8)));
            byArray2[n4] = (byte)(n3 - (n5 << 8));
            n3 = n5;
        }
        return byArray2;
    }

    public static final String getCardsRsName() {
        return RmsManager.getRsName(RS_CARDS);
    }

    public static final String getPrefsRsName() {
        return RmsManager.getRsName(RS_PREFS);
    }

    private static final String getRsName(String string) {
        return "Mcf" + string;
    }

    public static boolean useRms() {
        return RmsManager.getFreeBytes() > 100000L;
    }

    public static void storePreference(String string, String string2) {
        try {
            RecordStore recordStore = RmsManager.getStorage((byte)0);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append('|');
            stringBuffer.append(string2);
            byte[] byArray = stringBuffer.toString().getBytes();
            stringBuffer = null;
            recordStore.addRecord(byArray, 0, byArray.length);
            byArray = null;
            RmsManager.flush();
        }
        catch (Throwable throwable) {
            string2 = null;
        }
    }

    public static String readPreference(String string) {
        String string2 = null;
        try {
            RecordStore recordStore = RmsManager.getStorage((byte)0);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                String string3 = new String(recordEnumeration.nextRecord());
                if (string3.startsWith(string + "|")) {
                    string2 = string3.substring(string3.indexOf("|") + 1);
                    break;
                }
                string3 = null;
            }
            recordEnumeration = null;
            recordStore = null;
        }
        catch (Throwable throwable) {
            string2 = null;
        }
        return string2;
    }

    static {
        RmsManager.open();
    }
}

