/*
 * Decompiled with CFR 0.152.
 */
package sudokusolver;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDletStateChangeException;
import sudokusolver.Cell;
import sudokusolver.CellIndexes;
import sudokusolver.Location;
import sudokusolver.Rectangle;
import sudokusolver.SSMidlet;

public class SSCanvas
extends GameCanvas
implements Runnable {
    private static final int KEY_SOFT1 = -6;
    private static final int KEY_SOFT2 = -7;
    private static final int KEY_CLEAR = -8;
    private static final int GRADIENT_DIRECTION_LEFT_TO_RIGHT = 1;
    private static final int GRADIENT_DIRECTION_RIGHT_TO_LEFT = 2;
    private static final int GRADIENT_DIRECTION_TOP_TO_BOTTOM = 4;
    private static final int GRADIENT_DIRECTION_BOTTOM_TO_TOP = 8;
    private final Font messageFont = Font.getFont((int)0, (int)0, (int)8);
    private final Font menuFont = Font.getFont((int)0, (int)1, (int)0);
    private final Font confirmMessageFont = Font.getFont((int)0, (int)1, (int)8);
    private final Font confirmTitleFont = Font.getFont((int)0, (int)3, (int)0);
    private final int backgroundColor;
    private final int statusBarColor;
    private final int menuBarColor;
    private final int menuCommandColor;
    private final int cellLightColor1;
    private final int cellDarkColor1;
    private final int cellLightColor2;
    private final int cellDarkColor2;
    private final int selectedCellBackgroundColor1;
    private final int selectedCellBackgroundColor2;
    private final int selectedCellForegroundColor;
    private int locationIndicatorColor1 = 16371549;
    private int conflictIndicatorColor1 = 0xF96666;
    private int locationIndicatorColor2 = 16562695;
    private int conflictIndicatorColor2 = 15672613;
    private final int enteredNumbersColor;
    private final int determinedNumbersColor;
    private final int testingNumbersColor;
    private final int solvedNumbersColor;
    private final int confirmBackColor;
    private final int confirmMessageColor;
    private final int confirmTitleColor;
    private final String confirmOkText;
    private final String confirmCancelText;
    private final int confirmGradientSize;
    private final int selectedCellGrowSize;
    private final int selectedCellArcSize;
    private final int selectedCellGradientSize;
    private final boolean selectedCellIsOpaque;
    private final int leftGap;
    private final int rightGap;
    private final int topGap;
    private final int bottomGap;
    private final float menuBarHeightFactor;
    private String menuBarSOFT1CommandText = "\u0412\u044b\u0445\u043e\u0434";
    private String menuBarSOFT2CommandText = "\u0420\u0435\u0448\u0438\u0442\u044c";
    private String lastMenuBarSOFT1CommandText = null;
    private String lastMenuBarSOFT2CommandText = null;
    private String statusBarMessageText = null;
    private String confirmTitleText = null;
    private String confirmMessageText = null;
    private boolean inputEnabled = true;
    private boolean inViewMood = false;
    private boolean lastInputEnabled = false;
    private boolean errorReasonHighlighted = false;
    private boolean showSolutions = true;
    private boolean showConfirm = false;
    private boolean solverThreadPainting = false;
    private boolean solverThreadCanceled = false;
    private boolean mainThreadPainting = false;
    private int width;
    private int height;
    private int statusBarHeight;
    private int statusBarVerticalInset = 6;
    private int menuBarHeight;
    private Rectangle clientRect = null;
    private Rectangle cellsRect = null;
    private final int cellRectSmallGapSize;
    private final int cellRectBigGapSize;
    private Cell[] cells = new Cell[81];
    private byte[] cellsValuesCopy = new byte[81];
    byte[] rowValuesArray = new byte[9];
    byte[] columnValuesArray = new byte[9];
    byte[] squareValuesArray = new byte[9];
    Cell[] rowCellsArray = new Cell[9];
    Cell[] columnCellsArray = new Cell[9];
    Cell[] squareCellsArray = new Cell[9];
    private Thread solverThread = null;
    private int solutionCounter;
    private int statusBarMessageColor = 13554679;
    private int statusBarMessageShadowColor = 3416921;
    Vector enteredValues = new Vector();
    Vector determinedValues = new Vector();
    Vector solvedValuesCollections = new Vector();
    private byte selectedCellIndex = 0;
    private int currentResultViewIndex = 0;
    private SSMidlet parentMidlet = null;

    public SSCanvas(boolean suppressKeyEvents, SSMidlet parentMidlet) {
        super(suppressKeyEvents);
        this.backgroundColor = 9992702;
        this.statusBarColor = 8998625;
        this.menuBarColor = 3416921;
        this.menuCommandColor = 8998625;
        this.cellLightColor1 = 13554679;
        this.cellDarkColor1 = 12301292;
        this.cellLightColor2 = 12436726;
        this.cellDarkColor2 = 11313643;
        this.selectedCellBackgroundColor1 = -1997545210;
        this.selectedCellBackgroundColor2 = -1998071546;
        this.selectedCellForegroundColor = 9992702;
        this.enteredNumbersColor = 3416921;
        this.determinedNumbersColor = 0xC63333;
        this.testingNumbersColor = 9653985;
        this.solvedNumbersColor = 9653985;
        this.confirmBackColor = 10027179;
        this.confirmMessageColor = 13554679;
        this.confirmTitleColor = 12301292;
        this.confirmOkText = "\u0414\u0430";
        this.confirmCancelText = "\u041d\u0435\u0442";
        this.confirmGradientSize = 10;
        this.selectedCellGrowSize = 0;
        this.selectedCellArcSize = 8;
        this.selectedCellGradientSize = 100;
        this.selectedCellIsOpaque = false;
        this.leftGap = 2;
        this.rightGap = 2;
        this.topGap = 2;
        this.bottomGap = 2;
        this.menuBarHeightFactor = 0.065f;
        this.cellRectSmallGapSize = 1;
        this.cellRectBigGapSize = 2;
        this.parentMidlet = parentMidlet;
        this.initialize();
    }

    private void initialize() {
        this.setFullScreenMode(true);
        this.initializeCells();
    }

    private void initializeCells() {
        for (byte i = 0; i < this.cells.length; i = (byte)(i + 1)) {
            this.cells[i] = new Cell(i, this, 0, 0);
            byte rowIndex = this.getCellRowIndex(i);
            byte columnIndex = this.getCellColumnIndex(i);
            byte unit3x3index = this.get3x3SquareIndex(rowIndex, columnIndex);
            this.cells[i].originalBackgroundColor1 = unit3x3index % 2 == 0 ? 13554679 : 12301292;
            this.cells[i].originalBackgroundColor2 = unit3x3index % 2 == 0 ? 12436726 : 11313643;
            this.cells[i].currentBackgroundColor1 = this.cells[i].originalBackgroundColor1;
            this.cells[i].currentBackgroundColor2 = this.cells[i].originalBackgroundColor2;
            this.cells[i].value = 0;
        }
    }

    private synchronized void showConfirm(String title, String message, String leftOptionString, String rightOptionString) {
        this.lastInputEnabled = this.inputEnabled;
        this.inputEnabled = false;
        this.confirmTitleText = title;
        this.confirmMessageText = message;
        this.showConfirm = true;
        this.lastMenuBarSOFT1CommandText = this.menuBarSOFT1CommandText;
        this.lastMenuBarSOFT2CommandText = this.menuBarSOFT2CommandText;
        this.menuBarSOFT1CommandText = leftOptionString;
        this.menuBarSOFT2CommandText = rightOptionString;
        this.paint(this.getGraphics());
        this.flushGraphics();
    }

    private synchronized void hideConfirm() {
        this.showConfirm = false;
        this.menuBarSOFT1CommandText = this.lastMenuBarSOFT1CommandText;
        this.menuBarSOFT2CommandText = this.lastMenuBarSOFT2CommandText;
        this.paint(this.getGraphics());
        this.flushGraphics();
        if (!this.inputEnabled) {
            this.inputEnabled = this.lastInputEnabled;
        }
    }

    private void setCellColor(byte rowIndex, byte columnIndex, int color1, int color2) {
        byte cellIndex = this.getCellIndex(rowIndex, columnIndex);
        if (cellIndex != this.selectedCellIndex) {
            this.cells[cellIndex].currentBackgroundColor1 = color1;
            this.cells[cellIndex].currentBackgroundColor2 = color2;
        }
    }

    private void setRowColor(byte rowIndex, int color1, int color2) {
        for (byte i = 0; i < 9; i = (byte)(i + 1)) {
            byte columnIndex = i;
            byte cellIndex = this.getCellIndex(rowIndex, columnIndex);
            if (cellIndex == this.selectedCellIndex) continue;
            this.cells[cellIndex].currentBackgroundColor1 = color1;
            this.cells[cellIndex].currentBackgroundColor2 = color2;
        }
    }

    private void setColumnColor(byte columnIndex, int color1, int color2) {
        for (byte i = 0; i < 9; i = (byte)(i + 1)) {
            byte rowIndex = i;
            byte cellIndex = this.getCellIndex(rowIndex, columnIndex);
            if (cellIndex == this.selectedCellIndex) continue;
            this.cells[cellIndex].currentBackgroundColor1 = color1;
            this.cells[cellIndex].currentBackgroundColor2 = color2;
        }
    }

    private void set3x3SquareColor(byte squareIndex, int color1, int color2) {
        byte baseRow = (byte)(squareIndex / 3 * 3);
        byte baseColumn = (byte)(squareIndex % 3 * 3);
        for (byte i = baseRow; i < baseRow + 3; i = (byte)(i + 1)) {
            for (byte j = baseColumn; j < baseColumn + 3; j = (byte)(j + 1)) {
                byte cellIndex = this.getCellIndex(i, j);
                if (cellIndex == this.selectedCellIndex) continue;
                this.cells[cellIndex].currentBackgroundColor1 = color1;
                this.cells[cellIndex].currentBackgroundColor2 = color2;
            }
        }
    }

    private CellIndexes getCellIndexes(Cell cell) {
        return new CellIndexes(this.getCellRowIndex(cell.index), this.getCellColumnIndex(cell.index));
    }

    private void getCellIndexes(Location location, byte locationInnerIndex, CellIndexes resultCellIndexes) {
        if (1 == location.type) {
            resultCellIndexes.rowIndex = location.index;
            resultCellIndexes.columnIndex = locationInnerIndex;
        } else if (2 == location.type) {
            resultCellIndexes.rowIndex = locationInnerIndex;
            resultCellIndexes.columnIndex = location.index;
        } else if (3 == location.type) {
            resultCellIndexes.rowIndex = (byte)(location.index / 3 * 3 + locationInnerIndex / 3);
            resultCellIndexes.columnIndex = (byte)(location.index % 3 * 3 + locationInnerIndex % 3);
        }
    }

    private CellIndexes getCellIndexes(Location location, byte locationInnerIndex) {
        CellIndexes cellIndexes = new CellIndexes();
        this.getCellIndexes(location, locationInnerIndex, cellIndexes);
        return cellIndexes;
    }

    private void resetCellBackgroundColors() {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].currentBackgroundColor1 = this.cells[i].originalBackgroundColor1;
            this.cells[i].currentBackgroundColor2 = this.cells[i].originalBackgroundColor2;
        }
    }

    private void highLightErrorReason(byte rowIndex, byte columnIndex, byte value) {
        byte squareIndex;
        byte duplicatedCellIndex = this.getIndexOfElement((byte)1, rowIndex, value);
        if (duplicatedCellIndex >= 0) {
            this.setRowColor(rowIndex, this.locationIndicatorColor1, this.locationIndicatorColor2);
            this.setCellColor(rowIndex, columnIndex, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
            this.setCellColor(rowIndex, duplicatedCellIndex, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
        }
        if ((duplicatedCellIndex = this.getIndexOfElement((byte)2, columnIndex, value)) >= 0) {
            this.setColumnColor(columnIndex, this.locationIndicatorColor1, this.locationIndicatorColor2);
            this.setCellColor(rowIndex, columnIndex, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
            this.setCellColor(duplicatedCellIndex, columnIndex, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
        }
        if ((duplicatedCellIndex = this.getIndexOfElement((byte)3, squareIndex = this.get3x3SquareIndex(rowIndex, columnIndex), value)) >= 0) {
            this.set3x3SquareColor(squareIndex, this.locationIndicatorColor1, this.locationIndicatorColor2);
            this.setCellColor(rowIndex, columnIndex, this.conflictIndicatorColor1, this.locationIndicatorColor2);
            CellIndexes cellIndexes = this.getCellIndexes(new Location(3, squareIndex), duplicatedCellIndex);
            this.setCellColor(cellIndexes.rowIndex, cellIndexes.columnIndex, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
        }
        this.setMessage("\u042d\u0442\u043e \u043d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435!");
        this.errorReasonHighlighted = true;
    }

    byte getCellRowIndex(byte cellIndex) {
        return (byte)(cellIndex / 9);
    }

    byte getCellColumnIndex(byte cellIndex) {
        return (byte)(cellIndex % 9);
    }

    private byte getCellIndex(byte rowIndex, byte columnIndex) {
        return (byte)(rowIndex * 9 + columnIndex);
    }

    private Cell getCell(byte rowIndex, byte columnIndex) {
        return this.cells[this.getCellIndex(rowIndex, columnIndex)];
    }

    public byte get3x3SquareIndex(byte rowIndex, byte columnIndex) {
        if (rowIndex >= 0 && rowIndex < 9 && columnIndex >= 0 && columnIndex < 9) {
            return (byte)(rowIndex / 3 * 3 + columnIndex / 3);
        }
        return -1;
    }

    private void fillRect(Graphics g, int x, int y, int width, int height, int color, boolean hasGradient, int direction) {
        int[] colors = new int[width * height];
        int opacity = 255;
        for (int i = 0; i < width; ++i) {
            if (hasGradient) {
                if ((direction & 1) != 0) {
                    opacity = (int)((float)(width - i) / (float)width * 255.0f);
                } else if ((direction & 2) != 0) {
                    opacity = (int)((float)(i + 1) / (float)width * 255.0f);
                }
            }
            for (int j = 0; j < height; ++j) {
                int pixelColor = color;
                if (hasGradient) {
                    if ((direction & 8) != 0) {
                        opacity = (int)((float)(j + 1) / (float)height * 255.0f);
                    } else if ((direction & 4) != 0) {
                        opacity = (int)((float)(height - j) / (float)height * 255.0f);
                    }
                    int curOpacity = (pixelColor & 0xFF000000) >> 24;
                    int newOpacity = curOpacity + opacity;
                    if (newOpacity < 0) {
                        newOpacity = 0;
                    }
                    pixelColor &= 0xFFFFFF;
                    pixelColor += newOpacity << 24;
                }
                colors[j * width + i] = pixelColor;
            }
        }
        g.drawRGB(colors, 0, width, x, y, width, height, true);
    }

    private void paintBackground(Graphics g) {
        g.setColor(9992702);
        g.fillRect(0, 0, this.width, this.height);
    }

    private void paintCells(Graphics g) {
        g.setColor(3416921);
        g.fillRect(this.cellsRect.x, this.cellsRect.y, this.cellsRect.width, this.cellsRect.height);
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].paint(g, 0, 0);
        }
        if (this.selectedCellIndex >= 0 && this.inputEnabled && !this.inViewMood) {
            this.cells[this.selectedCellIndex].currentBackgroundColor1 = -1997545210;
            this.cells[this.selectedCellIndex].currentBackgroundColor2 = -1998071546;
            this.cells[this.selectedCellIndex].paintBackground(g, Cell.size, Cell.size);
            this.cells[this.selectedCellIndex].paintForeground(g);
            g.setColor(3416921);
            g.drawRect(this.cells[this.selectedCellIndex].x - 2, this.cells[this.selectedCellIndex].y - 2, Cell.size + 3, Cell.size + 3);
            g.drawRect(this.cells[this.selectedCellIndex].x - 3, this.cells[this.selectedCellIndex].y - 3, Cell.size + 5, Cell.size + 5);
        }
    }

    private void paintStatusBar(Graphics g) {
        g.setColor(8998625);
        this.statusBarHeight = this.messageFont.getHeight() + 2 * this.statusBarVerticalInset;
        g.fillArc(-this.width / 2, this.height - this.menuBarHeight - this.statusBarHeight, this.width * 2, this.statusBarHeight * 2, 0, 180);
        if (this.statusBarMessageText != null) {
            g.setFont(this.messageFont);
            int x = (this.width - this.messageFont.stringWidth(this.statusBarMessageText)) / 2;
            int y = this.height - this.menuBarHeight - this.statusBarVerticalInset;
            g.setColor(this.statusBarMessageShadowColor);
            g.drawString(this.statusBarMessageText, x + 1, y + 1, 36);
            g.setColor(this.statusBarMessageColor);
            g.drawString(this.statusBarMessageText, x, y, 36);
            if (this.inViewMood && this.solutionCounter > 1) {
                int triangleHeight;
                int triangleLeftGap = 5;
                int triangleRightGap = 3;
                int messageWidth = this.messageFont.stringWidth(this.statusBarMessageText);
                int leftTriangleXPos = (this.width - messageWidth) / 2 - triangleLeftGap;
                int rightTriangleXPos = this.width - (this.width - messageWidth) / 2 + triangleRightGap;
                int triangleYPos = this.height - this.menuBarHeight - this.statusBarHeight / 2;
                int triangleWidth = triangleHeight = this.statusBarHeight / 3;
                g.setColor(9992702);
                g.fillTriangle(leftTriangleXPos - triangleWidth, triangleYPos, leftTriangleXPos, triangleYPos - triangleHeight / 2, leftTriangleXPos, triangleYPos + triangleHeight / 2);
                g.fillTriangle(rightTriangleXPos + triangleWidth, triangleYPos, rightTriangleXPos, triangleYPos + triangleHeight / 2, rightTriangleXPos, triangleYPos - triangleHeight / 2);
            }
        }
    }

    private void paintMenuBar(Graphics g) {
        g.setColor(3416921);
        g.fillRect(0, this.height - this.menuBarHeight, this.width, this.menuBarHeight);
        int gradientHeight = this.statusBarVerticalInset * 3;
        this.fillRect(g, 0, this.height - this.menuBarHeight - gradientHeight, this.width, gradientHeight, 3416921, true, 8);
        g.setColor(8998625);
        g.setFont(this.menuFont);
        g.drawString(this.menuBarSOFT1CommandText, 2, this.getHeight() - 2, 36);
        g.drawString(this.menuBarSOFT2CommandText, this.getWidth() - 2, this.getHeight() - 2, 40);
    }

    private void paintConfirmMessage(Graphics g) {
        if (this.showConfirm) {
            int messageBottom = this.height - this.menuBarHeight - this.statusBarHeight;
            int x = 0;
            int y = messageBottom - 30;
            int rectWidth = this.width;
            int rectHeight = this.height - this.menuBarHeight - y;
            int backColor = -1147600691;
            this.fillRect(g, x, y, rectWidth, rectHeight, backColor, false, 0);
            this.fillRect(g, x, y - 10, rectWidth, 10, backColor, true, 8);
            g.setColor(13554679);
            g.setFont(this.confirmMessageFont);
            g.drawString(this.confirmMessageText, rectWidth / 2, y + rectHeight / 2, 65);
        }
    }

    public synchronized void paint(Graphics g) {
        if (!this.solverThreadPainting) {
            Thread currentThread = Thread.currentThread();
            if (currentThread != this.solverThread) {
                this.mainThreadPainting = true;
            }
            super.paint(g);
            this.paintBackground(g);
            this.paintCells(g);
            this.paintStatusBar(g);
            this.paintConfirmMessage(g);
            this.paintMenuBar(g);
            if (currentThread != this.solverThread) {
                this.mainThreadPainting = false;
            }
        }
    }

    private void showSolvingProgress() {
        if (!this.mainThreadPainting) {
            Thread currentThread = Thread.currentThread();
            this.paint(this.getGraphics());
            if (currentThread == this.solverThread) {
                this.solverThreadPainting = true;
            }
            if (this.showSolutions) {
                this.flushGraphics();
            } else {
                this.flushGraphics(0, this.height - this.menuBarHeight - this.statusBarHeight, this.width, this.height);
            }
            if (currentThread == this.solverThread) {
                this.solverThreadPainting = false;
            }
        }
    }

    private void calculatePosOfCells() {
        short sg = 1;
        int bg = 2;
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].x = (short)(this.cellsRect.x + bg + i % 9 / 3 * (3 * (Cell.size + sg) + (bg - sg)) + i % 9 % 3 * (Cell.size + sg));
            this.cells[i].y = (short)(this.cellsRect.y + bg + i / 9 / 3 * (3 * (Cell.size + sg) + (bg - sg)) + i / 9 % 3 * (Cell.size + sg));
        }
    }

    protected void sizeChanged(int w, int h) {
        super.sizeChanged(w, h);
        this.width = w;
        this.height = h;
        this.statusBarHeight = this.messageFont.getHeight() + 2 * this.statusBarVerticalInset;
        this.menuBarHeight = (int)(0.065f * (float)h);
        int clientWidth = w - 2 - 2;
        int clientHeight = h - 2 - 2 - this.statusBarHeight - this.menuBarHeight;
        this.clientRect = new Rectangle(2, 2, clientWidth, clientHeight);
        int maxClientSize = Math.min(clientWidth, clientHeight);
        Cell.size = (short)((maxClientSize - 6 - 8) / 9);
        int cellsRectSize = 9 * Cell.size + 6 + 8;
        this.cellsRect = new Rectangle(this.clientRect.x + (this.clientRect.width - cellsRectSize) / 2, this.clientRect.y + (this.clientRect.height - cellsRectSize) / 2, cellsRectSize, cellsRectSize);
        this.calculatePosOfCells();
    }

    private void selectCell(byte cellIndex) {
        this.selectedCellIndex = cellIndex;
    }

    private Cell[] getLocationCells(Location location) {
        Cell[] result = null;
        if (1 == location.type) {
            result = this.getRowCells(location.index);
        } else if (2 == location.type) {
            result = this.getColumnCells(location.index);
        } else if (3 == location.type) {
            result = this.get3x3SquareCells(location.index);
        }
        return result;
    }

    private byte[] getLocationValues(Location location) {
        Cell[] locCells = this.getLocationCells(location);
        byte[] result = new byte[locCells.length];
        for (int i = 0; i < result.length; i = (int)((byte)(i + 1))) {
            result[i] = locCells[i].value;
        }
        return result;
    }

    private Cell[] get3x3SquareCells(byte squareIndex) {
        if (squareIndex >= 0 && squareIndex < 9) {
            byte baseRow = (byte)(squareIndex / 3 * 3);
            byte baseColumn = (byte)(squareIndex % 3 * 3);
            int k = 0;
            for (byte i = baseRow; i < baseRow + 3; i = (byte)(i + 1)) {
                for (byte j = baseColumn; j < baseColumn + 3; j = (byte)(j + 1)) {
                    int n = k;
                    k = (byte)(k + 1);
                    this.squareCellsArray[n] = this.getCell(i, j);
                }
            }
            return this.squareCellsArray;
        }
        return null;
    }

    public byte[] get3x3SquareValues(byte squareIndex) {
        Cell[] sqCells = this.get3x3SquareCells(squareIndex);
        for (int i = 0; i < this.squareValuesArray.length; i = (int)((byte)(i + 1))) {
            this.squareValuesArray[i] = sqCells[i].value;
        }
        return this.squareValuesArray;
    }

    public void set3x3SquareValues(byte squareIndex, byte[] newValues) {
        Cell[] sqCells = this.get3x3SquareCells(squareIndex);
        for (int i = 0; i < sqCells.length; i = (int)((byte)(i + 1))) {
            sqCells[i].value = newValues[i];
        }
    }

    private Cell[] getRowCells(byte rowIndex) {
        if (rowIndex >= 0 && rowIndex < 9) {
            for (byte j = 0; j < 9; j = (byte)(j + 1)) {
                this.rowCellsArray[j] = this.getCell(rowIndex, j);
            }
            return this.rowCellsArray;
        }
        return null;
    }

    public byte[] getRowValues(byte rowIndex) {
        Cell[] rowCells = this.getRowCells(rowIndex);
        for (int i = 0; i < this.rowValuesArray.length; i = (int)((byte)(i + 1))) {
            this.rowValuesArray[i] = rowCells[i].value;
        }
        return this.rowValuesArray;
    }

    public void setRowValues(byte rowIndex, byte[] newValues) {
        Cell[] rowCells = this.getRowCells(rowIndex);
        for (int i = 0; i < rowCells.length; i = (int)((byte)(i + 1))) {
            rowCells[i].value = newValues[i];
        }
    }

    private Cell[] getColumnCells(byte columnIndex) {
        if (columnIndex >= 0 && columnIndex < 9) {
            for (byte i = 0; i < 9; i = (byte)(i + 1)) {
                this.columnCellsArray[i] = this.getCell(i, columnIndex);
            }
            return this.columnCellsArray;
        }
        return null;
    }

    public byte[] getColumnValues(byte columnIndex) {
        Cell[] columnCells = this.getColumnCells(columnIndex);
        for (int i = 0; i < this.columnValuesArray.length; i = (int)((byte)(i + 1))) {
            this.columnValuesArray[i] = columnCells[i].value;
        }
        return this.columnValuesArray;
    }

    public void setColumnValues(byte columnIndex, byte[] newValues) {
        Cell[] columnCells = this.getColumnCells(columnIndex);
        for (int i = 0; i < columnCells.length; i = (int)((byte)(i + 1))) {
            columnCells[i].value = newValues[i];
        }
    }

    public boolean isCompleted() {
        for (int i = 0; i < this.cells.length; i = (int)((byte)(i + 1))) {
            if (this.cells[i].value != 0) continue;
            return false;
        }
        return true;
    }

    private void setMessage(String message) {
        this.statusBarMessageText = message;
    }

    private void indicateInvalidValue(byte rowIndex, byte columnIndex, byte value) {
        this.highLightErrorReason(rowIndex, columnIndex, value);
        this.setMessage("\u042d\u0442\u043e \u043d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435!");
    }

    public boolean setCellValue(byte rowIndex, byte columnIndex, byte value, boolean isManually) {
        if (this.isAValidNumber(rowIndex, columnIndex, value)) {
            this.getCell((byte)rowIndex, (byte)columnIndex).currentForegroundColor = isManually ? 3416921 : 0xC63333;
            this.getCell((byte)rowIndex, (byte)columnIndex).value = value;
            return true;
        }
        this.indicateInvalidValue(rowIndex, columnIndex, value);
        return false;
    }

    private byte getIndexOfElement(byte locationType, byte locationIndex, byte elementValue) {
        byte value = 0;
        for (byte i = 0; i < 9; i = (byte)(i + 1)) {
            switch (locationType) {
                case 1: {
                    value = this.getCell((byte)locationIndex, (byte)i).value;
                    break;
                }
                case 2: {
                    value = this.getCell((byte)i, (byte)locationIndex).value;
                    break;
                }
                case 3: {
                    byte baseRowIndex = (byte)(locationIndex / 3 * 3);
                    byte baseColumnIndex = (byte)(locationIndex % 3 * 3);
                    byte rowIndex = (byte)(baseRowIndex + i / 3);
                    byte columnIndex = (byte)(baseColumnIndex + i % 3);
                    value = this.getCell((byte)rowIndex, (byte)columnIndex).value;
                }
            }
            if (value != elementValue) continue;
            return i;
        }
        return -1;
    }

    public boolean isAValidNumber(byte rowIndex, byte columnIndex, byte value) {
        if (value == 0) {
            return true;
        }
        byte squareIndex = this.get3x3SquareIndex(rowIndex, columnIndex);
        return this.getCell((byte)rowIndex, (byte)columnIndex).value == value || this.getIndexOfElement((byte)1, rowIndex, value) < 0 && this.getIndexOfElement((byte)2, columnIndex, value) < 0 && this.getIndexOfElement((byte)3, squareIndex, value) < 0;
    }

    public boolean setSelectedCellValue(byte value) {
        if (this.selectedCellIndex >= 0) {
            Cell selectedCell = this.cells[this.selectedCellIndex];
            CellIndexes selectedCellIndexes = this.getCellIndexes(selectedCell);
            boolean isValueEntered = this.setCellValue(selectedCellIndexes.rowIndex, selectedCellIndexes.columnIndex, value, true);
            if (isValueEntered) {
                this.caculatePossibleValues(this.selectedCellIndex);
                if (value > 0) {
                    selectedCell.type = 1;
                    selectedCell.currentForegroundColor = 3416921;
                } else {
                    selectedCell.type = 0;
                }
            }
            return isValueEntered;
        }
        return true;
    }

    private void exit() {
        try {
            this.parentMidlet.destroyApp(true);
        }
        catch (MIDletStateChangeException ex) {
            ex.printStackTrace();
        }
    }

    private void leftKeyPressed() {
        if (this.inputEnabled) {
            if (this.inViewMood) {
                this.currentResultViewIndex = (this.currentResultViewIndex - 1 + this.solutionCounter) % this.solutionCounter;
                String message = this.isSolverThreadCanceled() ? "\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e" : "\u041f\u043e\u043b\u043d\u044b\u0439";
                this.setMessage(message + " [ " + (this.currentResultViewIndex + 1) + " \u0438\u0437 " + this.solutionCounter + " ]");
                this.showCurrentResult();
            } else {
                byte nextSelectedCellIndex = (byte)((this.selectedCellIndex - 1 + 81) % 81);
                this.selectCell(nextSelectedCellIndex);
                if (!this.isCompleted()) {
                    this.menuBarSOFT2CommandText = "\u0420\u0435\u0448\u0438\u0442\u044c";
                }
            }
        }
    }

    private void rightKeyPressed() {
        if (this.inputEnabled) {
            if (this.inViewMood) {
                this.currentResultViewIndex = (this.currentResultViewIndex + 1) % this.solutionCounter;
                String message = this.isSolverThreadCanceled() ? "\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e" : "\u041f\u043e\u043b\u043d\u044b\u0439";
                this.setMessage(message + " [ " + (this.currentResultViewIndex + 1) + " \u0438\u0437 " + this.solutionCounter + " ]");
                this.showCurrentResult();
            } else {
                byte nextSelectedCellIndex = (byte)((this.selectedCellIndex + 1 + 81) % 81);
                this.selectCell(nextSelectedCellIndex);
                if (!this.isCompleted()) {
                    this.menuBarSOFT2CommandText = "\u0420\u0435\u0448\u0438\u0442\u044c";
                }
            }
        }
    }

    private void upKeyPressed() {
        if (this.inputEnabled && !this.inViewMood) {
            byte nextSelectedCellIndex;
            if (this.selectedCellIndex == 0) {
                nextSelectedCellIndex = 80;
            } else {
                nextSelectedCellIndex = (byte)(this.selectedCellIndex - 9);
                if (nextSelectedCellIndex < 0) {
                    nextSelectedCellIndex = (byte)(nextSelectedCellIndex + 80);
                }
            }
            this.selectCell(nextSelectedCellIndex);
            if (!this.isCompleted()) {
                this.menuBarSOFT2CommandText = "\u0420\u0435\u0448\u0438\u0442\u044c";
            }
        }
    }

    private void downKeyPressed() {
        if (this.inputEnabled && !this.inViewMood) {
            byte nextSelectedCellIndex;
            if (this.selectedCellIndex == 80) {
                nextSelectedCellIndex = 0;
            } else {
                nextSelectedCellIndex = (byte)(this.selectedCellIndex + 9);
                if (nextSelectedCellIndex > 80) {
                    nextSelectedCellIndex = (byte)(nextSelectedCellIndex - 80);
                }
            }
            this.selectCell(nextSelectedCellIndex);
            if (!this.isCompleted()) {
                this.menuBarSOFT2CommandText = "\u0420\u0435\u0448\u0438\u0442\u044c";
            }
        }
    }

    private void showPossibleValues() {
        if (this.selectedCellIndex >= 0) {
            Cell cell = this.cells[this.selectedCellIndex];
            String str = new String();
            Vector pv = cell.getPossibleValues();
            int pvSize = pv.size();
            for (int i = 0; i < pvSize; ++i) {
                str = str + String.valueOf(pv.elementAt(i));
                if (i >= pvSize - 1) continue;
                str = str + ", ";
            }
            this.setMessage(str);
        }
    }

    protected void keyPressed(int keyCode) {
        if (!this.errorReasonHighlighted && this.inputEnabled) {
            this.resetCellBackgroundColors();
            if (!this.inViewMood) {
                this.setMessage(null);
            }
        }
        if (this.getGameAction(keyCode) == 2 && keyCode != 52) {
            this.leftKeyPressed();
        } else if (this.getGameAction(keyCode) == 5 && keyCode != 54) {
            this.rightKeyPressed();
        } else if (this.getGameAction(keyCode) == 1 && keyCode != 50) {
            this.upKeyPressed();
        } else if (this.getGameAction(keyCode) == 6 && keyCode != 56) {
            this.downKeyPressed();
        } else if (keyCode >= 49 && keyCode <= 57) {
            if (this.inputEnabled && !this.inViewMood && this.setSelectedCellValue((byte)(keyCode - 48)) && this.isCompleted()) {
                this.menuBarSOFT2CommandText = "\u041d\u043e\u0432\u044b\u0439";
                this.setMessage("\u0423\u0441\u043f\u0435\u0448\u043d\u043e.");
            }
        } else if (keyCode == 48 || keyCode == -8) {
            if (this.inputEnabled && !this.inViewMood) {
                this.setSelectedCellValue((byte)0);
                this.menuBarSOFT2CommandText = "\u0420\u0435\u0448\u0438\u0442\u044c";
                this.setMessage(null);
            }
        } else if (keyCode == -6) {
            this.softKey1Pressed();
        } else if (keyCode == -7) {
            this.softKey2Pressed();
        }
        if (this.errorReasonHighlighted) {
            this.errorReasonHighlighted = false;
        }
        if (this.inputEnabled) {
            while (this.mainThreadPainting) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            this.paint(this.getGraphics());
            this.flushGraphics();
        }
    }

    public boolean isShowSolvingProgress() {
        return this.showSolutions;
    }

    public void setShowSolvingProgress(boolean showSolvingProgress) {
        this.showSolutions = showSolvingProgress;
    }

    private void getCellsValuesCopy() {
        for (int i = 0; i < this.cells.length; i = (int)((byte)(i + 1))) {
            this.cellsValuesCopy[i] = this.cells[i].value;
        }
    }

    private int getLocationValidPositionsNo(Location location, byte value) {
        int counter = 0;
        byte[] values = this.getLocationValues(location);
        CellIndexes resultCellIndexes = new CellIndexes();
        for (byte i = 0; i < values.length; i = (byte)(i + 1)) {
            this.getCellIndexes(location, i, resultCellIndexes);
            if (this.getCell((byte)resultCellIndexes.rowIndex, (byte)resultCellIndexes.columnIndex).value != 0 || !this.isAValidNumber(resultCellIndexes.rowIndex, resultCellIndexes.columnIndex, value)) continue;
            counter = (byte)(counter + 1);
        }
        return counter;
    }

    private boolean getNextLocation(Location location, Location resultLocation) {
        if (location.index < 8) {
            resultLocation.type = location.type;
            resultLocation.index = (byte)(location.index + 1);
        } else if (1 == location.type) {
            resultLocation.type = (byte)2;
            resultLocation.index = 0;
        } else if (2 == location.type) {
            resultLocation.type = (byte)3;
            resultLocation.index = 0;
        } else if (3 == location.type) {
            return false;
        }
        return true;
    }

    private boolean areValuesEqual(byte[] array1, Cell[] array2) {
        for (int i = 0; i < 81; i = (int)((byte)(i + 1))) {
            if (array1[i] == array2[i].value) continue;
            return false;
        }
        return true;
    }

    private boolean solveDeterminableCells() {
        Location location = new Location();
        CellIndexes cellIndexes = new CellIndexes();
        while (!this.isCompleted()) {
            location.type = 1;
            location.index = 0;
            this.getCellsValuesCopy();
            Cell cell = null;
            do {
                for (byte i = 0; i < 9; i = (byte)(i + 1)) {
                    this.getCellIndexes(location, i, cellIndexes);
                    for (byte k = 1; k <= 9; k = (byte)((byte)(k + 1))) {
                        cell = this.getCell(cellIndexes.rowIndex, cellIndexes.columnIndex);
                        if (cell.value != 0 || !this.isAValidNumber(cellIndexes.rowIndex, cellIndexes.columnIndex, k) || 1 != this.getLocationValidPositionsNo(location, k) || !this.setCellValue(cellIndexes.rowIndex, cellIndexes.columnIndex, k, false)) continue;
                        this.caculatePossibleValues(cell.index);
                        this.saveDeterminedValue(cell.index);
                    }
                }
            } while (this.getNextLocation(location, location));
            if (!this.areValuesEqual(this.cellsValuesCopy, this.cells)) continue;
            return false;
        }
        return true;
    }

    private void caculatePossibleValues(byte changedCellIndex) {
        byte r1 = 0;
        byte c1 = 0;
        byte s1 = 0;
        byte r2 = 0;
        byte c2 = 0;
        byte s2 = 0;
        if (changedCellIndex != -1) {
            r1 = this.getCellRowIndex(changedCellIndex);
            c1 = this.getCellColumnIndex(changedCellIndex);
            s1 = this.get3x3SquareIndex(r1, c1);
        }
        for (byte i = 0; i < this.cells.length; i = (byte)(i + 1)) {
            if (changedCellIndex != -1) {
                r2 = this.getCellRowIndex(i);
                c2 = this.getCellColumnIndex(i);
                s2 = this.get3x3SquareIndex(r2, c2);
            }
            if (changedCellIndex != -1 && (changedCellIndex == -1 || r1 != r2 && c1 != c2 && s1 != s2)) continue;
            this.cells[i].calculatePossibleValues();
        }
    }

    private Vector getEmptyCells() {
        Vector<Cell> result = new Vector<Cell>();
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i].value != 0) continue;
            result.addElement(this.cells[i]);
        }
        return result;
    }

    private byte[] getCellsValues(Vector cells) {
        byte[] result = new byte[cells.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Cell)cells.elementAt((int)i)).value;
        }
        return result;
    }

    private void setCellsValues(Vector cells, byte[] values) {
        for (int i = 0; i < values.length; ++i) {
            ((Cell)cells.elementAt(i)).setValue(values[i]);
        }
    }

    public synchronized boolean isSolverThreadCanceled() {
        return this.solverThreadCanceled;
    }

    private int check(Vector emptyCellsVector, int curEmptyCellIndex) {
        if (this.isSolverThreadCanceled()) {
            return this.solutionCounter;
        }
        Cell cell = (Cell)emptyCellsVector.elementAt(curEmptyCellIndex);
        int emptyCellsNo = emptyCellsVector.size();
        Vector possibleValues = cell.getPossibleValues();
        int possibleValuesNo = possibleValues.size();
        CellIndexes cellIndexes = this.getCellIndexes(cell);
        for (int i = 0; i < possibleValuesNo; ++i) {
            if (!this.isAValidNumber(cellIndexes.rowIndex, cellIndexes.columnIndex, (Byte)possibleValues.elementAt(i))) continue;
            byte[] lastCellsValuesMemory = this.getCellsValues(emptyCellsVector);
            ((Cell)emptyCellsVector.elementAt((int)curEmptyCellIndex)).currentForegroundColor = 9653985;
            ((Cell)emptyCellsVector.elementAt(curEmptyCellIndex)).setValue((Byte)possibleValues.elementAt(i));
            if (curEmptyCellIndex == emptyCellsNo - 1) {
                if (this.solveDeterminableCells()) {
                    this.solutionFound();
                    this.showSolvingProgress();
                }
            } else {
                this.check(emptyCellsVector, curEmptyCellIndex + 1);
            }
            this.setCellsValues(emptyCellsVector, lastCellsValuesMemory);
        }
        return this.solutionCounter;
    }

    private int check(Vector emptyCellsVector) {
        return this.check(emptyCellsVector, 0);
    }

    private short getCellInfoCode(byte cellIndex) {
        return (short)((cellIndex << 4) + this.cells[cellIndex].value);
    }

    private void saveSolvedValues() {
        byte i;
        int solvedCellsCounter = 0;
        for (i = 0; i < this.cells.length; i = (byte)((byte)(i + 1))) {
            if (this.cells[i].type == 1 || this.cells[i].type == 2) continue;
            this.cells[i].type = (byte)3;
            solvedCellsCounter = (byte)(solvedCellsCounter + 1);
        }
        short[] solvedValues = new short[solvedCellsCounter];
        int j = 0;
        for (i = 0; i < this.cells.length; i = (byte)((byte)(i + 1))) {
            if (this.cells[i].type != 3) continue;
            int n = j;
            j = (byte)(j + 1);
            solvedValues[n] = this.getCellInfoCode(i);
        }
        this.solvedValuesCollections.addElement(solvedValues);
    }

    private void saveDeterminedValue(byte cellIndex) {
        this.cells[cellIndex].type = (byte)2;
        short valueInfo = this.getCellInfoCode(cellIndex);
        this.determinedValues.addElement(new Short(valueInfo));
    }

    private void saveEnteredValues() {
        for (byte i = 0; i < this.cells.length; i = (byte)((byte)(i + 1))) {
            if (this.cells[i].value <= 0) continue;
            this.cells[i].type = 1;
            short valueInfo = this.getCellInfoCode(i);
            this.enteredValues.addElement(new Short(valueInfo));
        }
    }

    private void solutionFound() {
        ++this.solutionCounter;
        this.saveSolvedValues();
        this.setMessage("\u0412\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u043e... [ " + this.solutionCounter + "\u0420\u0435\u0448\u0435\u043d\u0438\u0435" + (this.solutionCounter > 1 ? "" : "") + " ]");
    }

    private boolean isSolvable() {
        for (int i = 0; i < this.cells.length; i = (int)((byte)(i + 1))) {
            if (!this.cells[i].possibleValues.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void indicateEnteredNumbers() {
        for (int i = 0; i < this.cells.length; i = (int)((byte)(i + 1))) {
            if (this.cells[i].value <= 0) continue;
            this.cells[i].currentForegroundColor = 3416921;
        }
    }

    public int solve() {
        this.solutionCounter = 0;
        this.indicateEnteredNumbers();
        if (!this.isSolvable()) {
            return 0;
        }
        this.enteredValues.removeAllElements();
        this.determinedValues.removeAllElements();
        this.solvedValuesCollections.removeAllElements();
        this.saveEnteredValues();
        this.caculatePossibleValues((byte)-1);
        if (this.solveDeterminableCells()) {
            this.solutionFound();
            this.showSolvingProgress();
            return this.solutionCounter;
        }
        Vector emptyCellsVector = this.getEmptyCells();
        return this.check(emptyCellsVector);
    }

    private void startSolving() {
        this.solverThreadCanceled = false;
        if (this.solverThread == null) {
            this.solverThread = new Thread(this);
            this.solverThread.start();
        }
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        if (currentThread == this.solverThread) {
            this.solve();
            if (this.showConfirm) {
                this.lastMenuBarSOFT2CommandText = "\u041d\u043e\u0432\u044b\u0439";
            } else {
                this.menuBarSOFT2CommandText = "\u041d\u043e\u0432\u044b\u0439";
            }
            if (this.solutionCounter == 0) {
                this.setMessage("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043d\u0430\u0439\u0442\u0438 \u0441\u043f\u043e\u0441\u043e\u0431 \u0440\u0435\u0448\u0435\u043d\u0438\u044f.");
            } else {
                this.enterViewMood();
            }
            this.solverThread = null;
            this.inputEnabled = true;
            this.showSolvingProgress();
        }
    }

    public void endSolving() {
        if (this.solverThread != null) {
            this.solverThreadCanceled = true;
            try {
                this.solverThread.join();
                this.solverThread = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void reset() {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].initialize();
        }
        this.setMessage(null);
        this.menuBarSOFT1CommandText = "\u0412\u044b\u0445\u043e\u0434";
        this.menuBarSOFT2CommandText = "\u0420\u0435\u0448\u0438\u0442\u044c";
        this.selectedCellIndex = 0;
        this.inViewMood = false;
    }

    private void restoreEnteredValues() {
        int enteredValuesSize = this.enteredValues.size();
        for (int i = 0; i < enteredValuesSize; ++i) {
            byte cellValue;
            short cellInfo = (Short)this.enteredValues.elementAt(i);
            byte cellIndex = (byte)(cellInfo >> 4);
            this.cells[cellIndex].value = cellValue = (byte)(cellInfo & 0xF);
            this.cells[cellIndex].currentForegroundColor = 3416921;
        }
    }

    private void restoreDeterminedValues() {
        int determinedValuesSize = this.determinedValues.size();
        for (int i = 0; i < determinedValuesSize; ++i) {
            byte cellValue;
            short cellInfo = (Short)this.determinedValues.elementAt(i);
            byte cellIndex = (byte)(cellInfo >> 4);
            this.cells[cellIndex].value = cellValue = (byte)(cellInfo & 0xF);
            this.cells[cellIndex].currentForegroundColor = 0xC63333;
        }
    }

    private void restoreCurrentSolvedValues() {
        short[] solvedValues = (short[])this.solvedValuesCollections.elementAt(this.currentResultViewIndex);
        for (int i = 0; i < solvedValues.length; ++i) {
            byte cellValue;
            short cellInfo = solvedValues[i];
            byte cellIndex = (byte)(cellInfo >> 4);
            this.cells[cellIndex].value = cellValue = (byte)(cellInfo & 0xF);
            this.cells[cellIndex].currentForegroundColor = 9653985;
        }
    }

    private void showCurrentResult() {
        this.restoreCurrentSolvedValues();
        if (this.solutionCounter == 1) {
            this.setMessage("\u0423\u0441\u043f\u0435\u0448\u043d\u043e.");
        } else {
            String message = this.solverThreadCanceled ? "\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e" : "\u041f\u043e\u043b\u043d\u044b\u0439";
            this.setMessage(message + " [ " + (this.currentResultViewIndex + 1) + " \u0438\u0437 " + this.solutionCounter + " ]");
        }
    }

    private void enterViewMood() {
        this.inViewMood = true;
        this.restoreEnteredValues();
        this.restoreDeterminedValues();
        this.showCurrentResult();
        if (this.showConfirm) {
            this.lastMenuBarSOFT2CommandText = "\u041d\u0430\u0437\u0430\u0434";
        } else {
            this.menuBarSOFT2CommandText = "\u041d\u0430\u0437\u0430\u0434";
        }
    }

    private void softKey1Pressed() {
        if (this.showConfirm) {
            if (this.confirmTitleText.equals("\u041e\u0442\u043c\u0435\u043d\u0430 \u0440\u0435\u0448\u0435\u043d\u0438\u044f")) {
                if (this.menuBarSOFT1CommandText.equals("\u0414\u0430")) {
                    this.endSolving();
                    this.hideConfirm();
                    if (this.solutionCounter == 0) {
                        this.setMessage("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e [ \u0420\u0435\u0448\u0435\u043d\u0438\u0435 ]");
                    } else {
                        this.enterViewMood();
                    }
                    this.inputEnabled = true;
                }
            } else if (this.confirmTitleText.equals("\u0412\u044b\u0445\u043e\u0434") && this.menuBarSOFT1CommandText.equals("\u041d\u0435\u0442")) {
                this.hideConfirm();
            }
        } else if (this.menuBarSOFT1CommandText.equals("\u0412\u044b\u0445\u043e\u0434")) {
            this.showConfirm("\u0412\u044b\u0445\u043e\u0434", "\u0412\u044b\u0439\u0442\u0438?", "\u041d\u0435\u0442", "\u0414\u0430");
        }
    }

    private void softKey2Pressed() {
        if (this.showConfirm) {
            if (this.confirmTitleText.equals("\u0412\u044b\u0445\u043e\u0434")) {
                if (this.menuBarSOFT2CommandText.equals("\u0414\u0430") && this.confirmTitleText.equals("\u0412\u044b\u0445\u043e\u0434")) {
                    this.exit();
                }
            } else if (this.confirmTitleText.equals("\u041e\u0442\u043c\u0435\u043d\u0430 \u0440\u0435\u0448\u0435\u043d\u0438\u044f") && this.menuBarSOFT2CommandText.equals("\u041d\u0435\u0442")) {
                this.hideConfirm();
            }
        } else if (this.menuBarSOFT2CommandText.equals("\u0420\u0435\u0448\u0438\u0442\u044c")) {
            this.inputEnabled = false;
            this.menuBarSOFT2CommandText = "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c";
            this.setMessage("\u0412\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435...");
            while (this.mainThreadPainting) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            this.paint(this.getGraphics());
            this.flushGraphics();
            this.startSolving();
        } else if (this.menuBarSOFT2CommandText.equals("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c")) {
            this.showConfirm("\u041e\u0442\u043c\u0435\u043d\u0430 \u0440\u0435\u0448\u0435\u043d\u0438\u044f", "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0445\u043e\u0434 \u0440\u0435\u0448\u0435\u043d\u0438\u044f?", "\u0414\u0430", "\u041d\u0435\u0442");
        } else if (this.menuBarSOFT2CommandText.equals("\u041d\u043e\u0432\u044b\u0439")) {
            this.reset();
        } else if (this.menuBarSOFT2CommandText.equals("\u041d\u0430\u0437\u0430\u0434")) {
            this.inViewMood = false;
            this.currentResultViewIndex = 0;
            this.setMessage(null);
            this.menuBarSOFT2CommandText = this.isCompleted() ? "\u041d\u043e\u0432\u044b\u0439" : "\u0420\u0435\u0448\u0438\u0442\u044c";
        }
    }
}

