/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class GameCanvas
extends FullCanvas {
    public static int gameState = 0;
    protected int fireKey;
    protected int leftKey;
    protected int rightKey;
    protected int upKey;
    protected int downKey;
    public int WIDTH;
    public int HEIGHT;
    Image offscreen;
    Timer timer = new Timer();
    public TankAttack parent;
    static final int TOTAL_MENU_ITEM = 6;
    public Image planeImg;
    public Image tankImg;
    public Image bg;
    public Image title;
    public Image[] trooperImgs;
    public Image expImg;
    public Image[] tankexp;
    public int tankWidth;
    public int tankHeight;
    Plane[] planes;
    Plane[] choppers;
    public static final int MAX_PLANES = 2;
    public static final int MAX_CHOPPERS = 2;
    public static final int mGunLength = 5;
    static int mDirection;
    static int mGunX;
    static int mGunY;
    static int mScore;
    static int mShells;
    static int mHealth;
    boolean mTurningLeft;
    boolean mTurningRight;
    boolean mShooting;
    int mDelayBetweenPlanes;
    int mMaxBullets;
    int mLastBullet;
    int mMaxExplosions;
    int mLastExplosion;
    int mMaxBomb;
    int mLastBomb;
    int mLevel;
    int mWave;
    SoundPlayer gamesnds;
    public static boolean sndEnable;
    public static final int MAX_SND = 3;
    int mMaxTroopersOnScreen;
    int mMaxTroopersOnThisLevel;
    int mNumTroopersKilled;
    int mNumTroopersToBeDeployedAtATime;
    int mStatusTimer;
    static int mTrooperYSpeed;
    int mDelayBetweenTroopers;
    int mMaxDelayBetweenTroopers;
    int mStatus;
    Explosion[] mExplosions;
    Bullet[] mBullets;
    Bullet[] mBombs;
    TrooperVector mTroopers;
    static GameDataManager gdm;
    static String rname;
    int rscore;
    int[] gunx;
    int[] guny;
    public static int MAX_EXP_IMGS;
    public Image[] expImgs;
    public Image heliImg;
    public Image missImg;
    public Image[] gunImgs;
    Random random;
    public static int totalMedia;
    public static int loadedMedia;
    Image scoreimg;
    Image[] bulletImgs;
    int PPage = 1;
    int[] dirx;
    int[] diry;
    int maxdir = 7;
    int atx;
    int aty;
    public static boolean medialoaded;
    int paraDown;
    int planeDown;
    int chopperDown;
    int paraEscaped;
    int tac;
    int delay = 0;
    int tef = 0;
    int ted = 1;
    int anic = 0;
    boolean ttgatd = true;
    int cpage = 0;
    boolean keyboardmode = false;
    boolean first = false;
    int inx = 0;
    int in1x = 0;
    private static int selRectPos;
    static int temk;
    int maxMove = 5;
    int mcounter = 0;
    boolean mMoveLeft = false;
    boolean mMoveRight = false;
    static int mDX;
    static int mDY;
    static int mMaxBombOnScreen;
    static int mMaxDelayBetweenBombs;
    static int mBombYSpeed;
    static int mNumBombsToBeDeployedAtATime;
    int helppage = 0;

    public GameCanvas(TankAttack tankAttack) {
        this.timer.schedule((TimerTask)new GameTimer(), 0L, 200L);
        this.parent = tankAttack;
        this.bulletImgs = new Image[5];
        this.random = new Random();
        this.WIDTH = this.getWidth();
        this.HEIGHT = this.getHeight();
        this.fireKey = -7;
        this.leftKey = this.getKeyCode(2);
        this.rightKey = this.getKeyCode(5);
        this.upKey = this.getKeyCode(1);
        this.downKey = this.getKeyCode(6);
        try {
            this.gamesnds = new SoundPlayer(tankAttack);
            if (this.isDoubleBuffered()) {
                this.offscreen = Image.createImage((int)this.WIDTH, (int)this.HEIGHT);
            }
            loadedMedia = 1;
            this.parent.lg.repaint();
            this.bulletImgs[0] = Image.createImage((String)"/bom0.png");
            this.bulletImgs[1] = Image.createImage((String)"/bom1.png");
            this.bulletImgs[2] = Image.createImage((String)"/bom2.png");
            loadedMedia = 2;
            this.parent.lg.repaint();
            this.bulletImgs[3] = Image.createImage((String)"/bom3.png");
            this.bulletImgs[4] = Image.createImage((String)"/bom4.png");
            Bullet.Setup(this.bulletImgs);
            this.bg = Image.createImage((String)"/Background.png");
            this.scoreimg = Image.createImage((String)"/score.png");
            loadedMedia = 3;
            this.parent.lg.repaint();
            this.title = Image.createImage((String)"/title-name.png");
            loadedMedia = 4;
            this.parent.lg.repaint();
            loadedMedia = 5;
            this.parent.lg.repaint();
            this.planeImg = Image.createImage((String)"/Plane.png");
            loadedMedia = 6;
            this.parent.lg.repaint();
            loadedMedia = 7;
            this.parent.lg.repaint();
            this.tankImg = Image.createImage((String)"/tank.png");
            loadedMedia = 8;
            this.parent.lg.repaint();
            this.missImg = Image.createImage((String)"/missile.png");
            loadedMedia = 9;
            this.parent.lg.repaint();
            this.heliImg = Image.createImage((String)"/h1.png");
            loadedMedia = 10;
            this.parent.lg.repaint();
            loadedMedia = 11;
            this.parent.lg.repaint();
            loadedMedia = 12;
            this.parent.lg.repaint();
            this.trooperImgs = new Image[4];
            this.trooperImgs[0] = Image.createImage((String)"/troop.png");
            loadedMedia = 13;
            this.parent.lg.repaint();
            this.trooperImgs[1] = Image.createImage((String)"/troop2.png");
            loadedMedia = 14;
            this.parent.lg.repaint();
            this.trooperImgs[2] = Image.createImage((String)"/troopd.png");
            loadedMedia = 15;
            this.parent.lg.repaint();
            this.trooperImgs[3] = Image.createImage((String)"/parasuit.png");
            loadedMedia = 16;
            this.parent.lg.repaint();
            this.expImg = Image.createImage((String)"/fire.png");
            loadedMedia = 17;
            this.parent.lg.repaint();
            this.gunImgs = new Image[5];
            this.gunx = new int[this.maxdir];
            this.guny = new int[this.maxdir];
            int n = 0;
            while (n < 5) {
                this.gunImgs[n] = Image.createImage((String)("/gun" + n + ".png"));
                loadedMedia = 24 + n;
                this.parent.lg.repaint();
                ++n;
            }
            this.expImgs = new Image[MAX_EXP_IMGS];
            int n2 = 0;
            while (n2 < MAX_EXP_IMGS) {
                this.expImgs[n2] = Image.createImage((String)("/top-exp" + (n2 + 1) + ".png"));
                loadedMedia = 30 + n2;
                this.parent.lg.repaint();
                ++n2;
            }
            ++loadedMedia;
            ++loadedMedia;
            this.tankexp = new Image[3];
            int n3 = 0;
            while (n3 < 3) {
                this.tankexp[n3] = Image.createImage((String)("/tank-exp" + (n3 + 1) + ".png"));
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR LOADING IMAGES");
        }
        this.createGame();
        loadedMedia = 40;
        this.parent.lg.repaint();
        mGunX = this.WIDTH - this.tankWidth;
        mGunY = this.HEIGHT - this.tankHeight - 5;
        mDirection = 1;
        medialoaded = true;
    }

    public void ResetGun() {
        mGunY = this.HEIGHT - this.scoreimg.getHeight() - this.tankHeight - 5;
        mGunX = this.WIDTH / 2 - this.tankWidth / 2;
    }

    public void createGame() {
        this.paraDown = 0;
        this.planeDown = 0;
        this.chopperDown = 0;
        this.paraEscaped = 0;
        this.tankWidth = this.tankImg.getWidth();
        this.tankHeight = this.tankImg.getHeight();
        mGunY = this.HEIGHT - 50;
        this.mStatus = 3;
        mGunX = this.WIDTH / 2;
        mShells = 50;
        mHealth = 100;
        this.gunx[0] = 11;
        this.gunx[1] = 11;
        this.gunx[2] = 15;
        this.gunx[3] = 24;
        this.gunx[4] = 23;
        this.gunx[5] = 11;
        this.gunx[6] = this.tankWidth / 2;
        this.guny[0] = 0;
        this.guny[1] = 1;
        this.guny[2] = 10;
        this.guny[3] = 10;
        this.guny[4] = 5;
        this.guny[5] = 4;
        this.guny[6] = 0;
        this.dirx = new int[this.maxdir];
        this.diry = new int[this.maxdir];
        this.atx = 50;
        this.aty = 100;
        this.dirx[0] = -3;
        this.diry[0] = 0;
        this.dirx[1] = -2;
        this.diry[1] = -1;
        this.dirx[2] = -1;
        this.diry[2] = -2;
        this.dirx[3] = 0;
        this.diry[3] = -3;
        this.dirx[4] = 1;
        this.diry[4] = -2;
        this.dirx[5] = 2;
        this.diry[5] = -1;
        this.dirx[6] = 3;
        this.diry[6] = 0;
        this.mMaxBullets = 20;
        this.mBullets = new Bullet[this.mMaxBullets];
        int n = 0;
        while (n < this.mMaxBullets) {
            this.mBullets[n] = new Bullet();
            ++n;
        }
        this.mLastBullet = 0;
        this.mMaxBomb = 10;
        this.mLastBomb = 0;
        this.mBombs = new Bullet[this.mMaxBomb];
        int n2 = 0;
        while (n2 < this.mMaxBomb) {
            this.mBombs[n2] = new Bullet();
            ++n2;
        }
        this.mTroopers = new TrooperVector(this.HEIGHT, this);
        Trooper.setup(this.trooperImgs, this, this.mTroopers);
        Explosion.setup(this.expImg, this.expImgs);
        this.mMaxExplosions = 5;
        this.mExplosions = new Explosion[this.mMaxExplosions];
        int n3 = 0;
        while (n3 < this.mMaxExplosions) {
            this.mExplosions[n3] = new Explosion();
            ++n3;
        }
    }

    public void init() {
        this.planes = new Plane[2];
        this.planes[0] = new Plane(this, this.planeImg, -1, 1);
        this.planes[1] = new Plane(this, this.planeImg, 1, 1);
        this.choppers = new Plane[2];
        this.choppers[0] = new Plane(this, this.heliImg, 1, 0);
        this.choppers[1] = new Plane(this, this.heliImg, -1, 0);
        System.gc();
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.offscreen != null) {
            graphics = this.offscreen.getGraphics();
        }
        graphics.setClip(0, 0, this.WIDTH, this.HEIGHT);
        switch (gameState) {
            case 0: {
                graphics.setColor(129, 183, 244);
                graphics.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                graphics.drawImage(this.bg, 0, 0, 20);
                graphics.drawImage(this.title, this.WIDTH / 2 - this.title.getWidth() / 2, 10, 0x10 | 4);
                if (sndEnable) {
                    this.gamesnds.playBg();
                }
                if (mGunX > 20) {
                    mGunX -= 10;
                } else if (this.anic <= 3) {
                    ++mDirection;
                    ++this.anic;
                } else if (this.anic > 2 && this.anic < 10) {
                    this.mShooting = true;
                    if (sndEnable) {
                        this.gamesnds.stopSounds();
                        this.gamesnds.playShoot();
                    }
                    this.mStatus = 2;
                    ++this.anic;
                } else {
                    this.mShooting = false;
                    if (this.anic == 10) {
                        graphics.drawImage(this.tankexp[this.tef], 80, 10, 20);
                    } else if (this.anic == 11) {
                        graphics.drawImage(this.tankexp[this.tef], 10, 20, 20);
                    } else if (this.anic == 12) {
                        graphics.drawImage(this.tankexp[this.tef], 100, 40, 20);
                    }
                    ++this.tef;
                    if (this.tef == 3) {
                        this.removeAllBullets();
                        this.ted = 1;
                        this.tef = 0;
                        ++this.anic;
                    }
                }
                this.DrawTank(graphics);
                this.handleGun();
                int n = 0;
                while (n < this.mMaxBullets) {
                    this.mBullets[n].handle(graphics);
                    ++n;
                }
                graphics.setColor(0, 0, 0);
                graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
                graphics.drawString("Next", this.WIDTH - 23, this.HEIGHT - 9, 0x10 | 4);
                break;
            }
            case 1: {
                this.drawMenu(graphics);
                break;
            }
            case 2: {
                this.DrawGamePlay(graphics);
                break;
            }
            case 3: {
                this.DrawControls(graphics);
                break;
            }
            case 4: {
                int n;
                int n2;
                int n3;
                int n4;
                graphics.drawImage(this.bg, 0, 0, 0x10 | 4);
                if (this.mStatus == 1) {
                    this.DrawTank(graphics);
                    graphics.drawImage(this.tankexp[this.tef], mGunX - this.tankexp[this.tef].getWidth() / 2, mGunY - this.tankexp[this.tef].getHeight() / 2, 20);
                    ++this.tef;
                    if (this.tef == 3) {
                        this.removeAllBullets();
                        this.removeAllBombs();
                        this.startAfterExploding();
                        this.mStatus = 6;
                        this.ted = 1;
                        this.tef = 0;
                    }
                } else if (this.mStatus == 6 && !this.keyboardmode) {
                    n4 = this.getWidth() - 10;
                    n3 = this.getHeight() - 35;
                    n2 = this.getWidth() / 2 - n4 / 2;
                    n = this.getHeight() / 2 - n3 / 2;
                    graphics.fillRoundRect(n2, n, n4, n3, 10, 10);
                    graphics.setColor(255, 255, 204);
                    graphics.fillRoundRect(n2 - 1, n - 1, n4 - 2, n3 - 2, 10, 10);
                    graphics.setColor(175, 39, 202);
                    graphics.setColor(0, 0, 0);
                    graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                    graphics.drawString("GAME OVER", n2 + 20, n + 5, 20);
                    graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
                    graphics.drawString("Total Score: " + mScore, n2 + 5, n + 20, 20);
                    graphics.drawString("" + this.paraDown, n2 + 5, n + 40, 20);
                    graphics.drawImage(this.trooperImgs[3], n2 + 25, n + 40, 20);
                    graphics.drawImage(this.trooperImgs[0], n2 + 25, n + 40 + 10, 20);
                    graphics.drawString("X  1   = " + this.paraDown * 1, n2 + 60, n + 40, 20);
                    graphics.drawString("" + this.planeDown, n2 + 5, n + 55, 20);
                    graphics.drawImage(this.planeImg, n2 + 25, n + 55, 20);
                    graphics.drawString("X  3   = " + this.planeDown * 3, n2 + 60, n + 55, 20);
                    if (this.mLevel > 1) {
                        graphics.drawString("" + this.chopperDown, n2 + 5, n + 70, 20);
                        graphics.drawImage(this.heliImg, n2 + 25, n + 70, 20);
                        graphics.drawString("X  2   = " + 2 * this.chopperDown, n2 + 60, n + 70, 20);
                    }
                    ++this.mStatusTimer;
                    if (this.mStatusTimer > 25) {
                        this.mStatusTimer = 0;
                        if (this.rscore == 0 || mScore > this.rscore) {
                            if (mScore > 0) {
                                this.rscore = mScore;
                                if (gdm != null) {
                                    this.keyboardmode = true;
                                    this.first = true;
                                }
                                if (sndEnable) {
                                    this.gamesnds.stopSounds();
                                    this.gamesnds.playHighScore();
                                }
                            } else {
                                this.PPage = 1;
                                gameState = 1;
                            }
                        } else {
                            this.PPage = 1;
                            gameState = 1;
                        }
                    }
                } else if (this.mStatus == 4) {
                    graphics.setColor(0, 0, 0);
                    n4 = 116;
                    n3 = 70;
                    n2 = this.getWidth() / 2 - n4 / 2;
                    n = this.getHeight() / 2 - n3 / 2;
                    graphics.fillRoundRect(n2, n, n4, n3, 10, 10);
                    graphics.setColor(255, 255, 204);
                    graphics.fillRoundRect(n2 - 1, n - 1, n4 - 2, n3 - 2, 10, 10);
                    graphics.setColor(175, 39, 202);
                    graphics.setColor(0, 0, 0);
                    graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                    graphics.drawString("Level " + this.mLevel, n2 + 32, n + 5, 20);
                    graphics.drawString("GET READY", n2 + 22, n + 25, 20);
                    graphics.drawString("" + this.mMaxTroopersOnThisLevel + " Troopers to shoot", n2 + 2, n + 45, 20);
                    ++this.mStatusTimer;
                    if (this.mStatusTimer > 10) {
                        this.mStatus = 2;
                        this.mStatusTimer = 0;
                    }
                } else if (this.mStatus == 2 || this.mStatus == 4) {
                    this.DrawTank(graphics);
                }
                if (this.mStatus != 4 && this.mStatus != 1 && !this.keyboardmode && this.mStatus != 6) {
                    int n5;
                    this.mTroopers.draw(graphics);
                    n4 = 0;
                    while (n4 < 2) {
                        this.planes[n4].draw(graphics);
                        this.planes[n4].update();
                        ++n4;
                    }
                    if (this.mLevel > 1) {
                        n3 = 0;
                        while (n3 < 2) {
                            this.choppers[n3].draw(graphics);
                            this.choppers[n3].update();
                            ++n3;
                        }
                    }
                    if (this.mStatus != 6 && TrooperVector.mDeadTroopers < this.mMaxTroopersOnThisLevel) {
                        this.deployTroopers();
                        this.mTroopers.move();
                        this.mTroopers.checkBulletHits(this.mBullets, this.mMaxBullets);
                        n3 = 0;
                        while (n3 < 2) {
                            this.planes[n3].checkBulletHits(this.mBullets, this.mMaxBullets);
                            ++n3;
                        }
                        if (this.mLevel > 1) {
                            n2 = 0;
                            while (n2 < 2) {
                                this.choppers[n2].checkBulletHits(this.mBullets, this.mMaxBullets);
                                ++n2;
                            }
                        }
                        n2 = 0;
                        while (n2 < this.mMaxBullets) {
                            this.mBullets[n2].handle(graphics);
                            ++n2;
                        }
                        n = 0;
                        while (n < this.mMaxBomb) {
                            this.mBombs[n].handle(graphics);
                            ++n;
                        }
                        n5 = 0;
                        while (n5 < this.mMaxExplosions) {
                            this.mExplosions[n5].drawStationary(graphics);
                            ++n5;
                        }
                    }
                    if (TrooperVector.mDeadTroopers >= this.mMaxTroopersOnThisLevel) {
                        n3 = this.getWidth() - 10;
                        n2 = this.getHeight() - 40;
                        n = this.getWidth() / 2 - n3 / 2;
                        n5 = this.getHeight() / 2 - n2 / 2;
                        graphics.setColor(0, 0, 0);
                        graphics.fillRoundRect(n, n5, n3, n2, 10, 10);
                        graphics.setColor(255, 255, 204);
                        graphics.fillRoundRect(n - 1, n5 - 1, n3 - 2, n2 - 2, 10, 10);
                        graphics.setColor(175, 39, 202);
                        graphics.setColor(0, 0, 0);
                        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                        graphics.drawString("Level " + this.mLevel + " Completed", n + 8, n5 + 5, 20);
                        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
                        graphics.drawString("" + this.paraDown, n + 5, n5 + 20, 20);
                        graphics.drawImage(this.trooperImgs[3], n + 25, n5 + 20, 20);
                        graphics.drawImage(this.trooperImgs[0], n + 25, n5 + 20 + 10, 20);
                        graphics.drawString("X  1   = " + this.paraDown * 1, n + 60, n5 + 20, 20);
                        graphics.drawString("" + this.planeDown, n + 5, n5 + 45, 20);
                        graphics.drawImage(this.planeImg, n + 25, n5 + 45, 20);
                        graphics.drawString("X  3   = " + this.planeDown * 3, n + 60, n5 + 45, 20);
                        if (this.mLevel > 1) {
                            graphics.drawString("" + this.chopperDown, n + 5, n5 + 65, 20);
                            graphics.drawImage(this.heliImg, n + 25, n5 + 65, 20);
                            graphics.drawString("X  2   = " + 2 * this.chopperDown, n + 60, n5 + 65, 20);
                        }
                        if (this.mStatus == 2) {
                            this.mStatus = 5;
                            this.mStatusTimer = 0;
                        } else {
                            ++this.mStatusTimer;
                            if (this.mStatusTimer > 25) {
                                this.startAfterExploding();
                                this.mStatus = 4;
                                this.newLevel();
                            }
                        }
                    }
                }
                graphics.setColor(255, 255, 0);
                graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
                n4 = 3;
                n3 = this.HEIGHT - this.scoreimg.getHeight();
                graphics.drawImage(this.scoreimg, 0, n3, 20);
                graphics.drawString("" + mScore, 24, n3 + n4, 20);
                graphics.drawString("" + mShells, 75, n3 + n4, 20);
                graphics.drawString("" + mHealth + "%", 108, n3 + n4, 20);
                if (!this.keyboardmode) break;
                if (this.first) {
                    this.first = false;
                }
                this.parent.ShowForm();
                break;
            }
            case 5: 
            case 51: {
                this.DrawHighScore(graphics);
                break;
            }
            case 25: {
                this.DrawSubMenu(graphics);
                break;
            }
            case 1001: 
            case 1011: {
                this.DrawSoundMenu(graphics);
                break;
            }
            case 88: {
                this.DrawCredits(graphics);
            }
        }
        if (graphics != graphics2) {
            graphics2.drawImage(this.offscreen, 0, 0, 20);
        }
    }

    private void DrawCredits(Graphics graphics) {
        this.DrawBGS(graphics);
        graphics.setColor(175, 39, 202);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        int n = 13;
        int n2 = 7;
        int n3 = 7;
        if (this.cpage == 0) {
            graphics.drawString("About", n2 + 40, n3 + n * 0, 20);
            graphics.drawString("Indiagames", n2, n3 + n * 1, 20);
            graphics.drawString("CombatTankAttack 1.1", n2, n3 + n * 2, 20);
            graphics.drawString("24th September 2002", n2, n3 + n * 3, 20);
            graphics.drawString("Indiagames Ltd.", n2, n3 + n * 4, 20);
            graphics.drawString("English Nokia 7210", n2, n3 + n * 5, 20);
            graphics.drawString("www.indiagames.com", n2, n3 + n * 6, 20);
            graphics.drawString("\u00a9 Indiagames 2002-03", n2, n3 + n * 7, 20);
            graphics.setColor(0, 0, 0);
            graphics.drawString("More", this.WIDTH - 23, this.HEIGHT - 9, 0x10 | 4);
        } else {
            graphics.drawString("About", n2 + 40, n3 + n * 0, 20);
            graphics.drawString("All rights reserved.", n2, n3 + n * 1, 20);
            graphics.drawString("By downloading this", n2 - 3, n3 + n * 2, 20);
            graphics.drawString("game you have accepted", n2 - 3, n3 + n * 3, 20);
            graphics.drawString("all terms & conditions", n2 - 3, n3 + n * 4, 20);
            graphics.drawString("of the END-USER ", n2 - 3, n3 + n * 5, 20);
            graphics.drawString("LICENSE AGREEMENT", n2 - 3, n3 + n * 6, 20);
            graphics.drawString("indiagames.com/eula.asp", n2 - 3, n3 + n * 7, 20);
            graphics.setColor(0, 0, 0);
            graphics.drawString("Exit", this.WIDTH - 23, this.HEIGHT - 9, 0x10 | 4);
        }
    }

    private void DrawHighScore(Graphics graphics) {
        this.DrawBGS(graphics);
        graphics.setColor(175, 39, 202);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.drawString("High score", 40, 7, 20);
        if (rname == null) {
            graphics.drawString("No records", 20, 40, 20);
        } else {
            graphics.drawString("Name :" + rname, 20, 40, 20);
            graphics.drawString("Score:" + this.rscore, 20, 60, 20);
        }
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.setColor(0, 0, 0);
        graphics.drawString("Exit", this.WIDTH - 23, this.HEIGHT - 9, 0x10 | 4);
    }

    private void DrawTank(Graphics graphics) {
        graphics.setColor(102, 102, 102);
        int n = 4;
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        switch (mDirection) {
            case 0: {
                break;
            }
            case 1: {
                graphics.drawImage(this.gunImgs[0], mGunX - this.gunImgs[0].getWidth() / 2 - 3, mGunY - this.gunImgs[0].getHeight() + n, 20);
                break;
            }
            case 2: {
                graphics.drawImage(this.gunImgs[1], mGunX - this.gunImgs[1].getWidth() / 4 - 5, mGunY - this.gunImgs[1].getHeight() + n, 20);
                break;
            }
            case 3: {
                graphics.drawImage(this.gunImgs[2], mGunX - this.gunImgs[2].getWidth() / 2, mGunY - this.gunImgs[2].getHeight() + n, 20);
                break;
            }
            case 4: {
                graphics.drawImage(this.gunImgs[3], mGunX + this.gunImgs[3].getWidth() / 4 - 7, mGunY - this.gunImgs[3].getHeight() + n, 20);
                break;
            }
            case 5: {
                graphics.drawImage(this.gunImgs[4], mGunX + this.gunImgs[4].getWidth() / 4 - 7, mGunY - this.gunImgs[4].getHeight() + n, 20);
                break;
            }
        }
        graphics.drawImage(this.tankImg, mGunX - this.tankWidth / 2, mGunY + 2, 20);
    }

    protected void hideNotify() {
        if (gameState == 4) {
            gameState = 25;
            selRectPos = 0;
            this.repaint();
        }
    }

    protected void keyPressed(int n) {
        if (temk == 0) {
            temk = 1;
            if (gameState == 4) {
                if (this.mStatus == 2 || this.mStatus == 4) {
                    if (n == -1 || n == 49) {
                        this.mMoveRight = false;
                        this.mMoveLeft = false;
                        this.mTurningRight = false;
                        this.mTurningLeft = true;
                    } else if (n == -2 || n == 51) {
                        this.mMoveRight = false;
                        this.mMoveLeft = false;
                        this.mTurningLeft = false;
                        this.mTurningRight = true;
                    } else if (n == -3 || n == 52) {
                        this.mTurningLeft = false;
                        this.mTurningRight = false;
                        this.mMoveRight = false;
                        this.mMoveLeft = true;
                    } else if (n == -4 || n == 54) {
                        this.mTurningLeft = false;
                        this.mTurningRight = false;
                        this.mMoveLeft = false;
                        this.mMoveRight = true;
                    } else {
                        if (n == -7 || n == 53) {
                            this.mMoveRight = false;
                            this.mMoveLeft = false;
                            this.mTurningRight = false;
                            this.mTurningLeft = false;
                            if (!this.mShooting && sndEnable && !this.mShooting) {
                                this.gamesnds.stopSounds();
                            }
                            this.mShooting = true;
                            return;
                        }
                        if (n == 50) {
                            this.mMoveRight = false;
                            this.mMoveLeft = false;
                            this.mTurningRight = false;
                            this.mTurningLeft = false;
                            this.mShooting = false;
                            mDirection = 3;
                        }
                    }
                } else if (this.mStatus == 0 && (n == this.fireKey || n == 56)) {
                    this.newGame();
                    this.newWave();
                    this.newLevel();
                }
            } else if (gameState == 1) {
                if (n == this.upKey || n == -1) {
                    selRectPos = selRectPos > 0 ? --selRectPos : 6;
                } else if (n == this.downKey || n == -2) {
                    selRectPos = selRectPos < 6 ? ++selRectPos : 0;
                }
            } else if (gameState == 25) {
                if (n == this.upKey || n == -1) {
                    selRectPos = selRectPos > 0 ? --selRectPos : 7;
                } else if (n == this.downKey || n == -2) {
                    selRectPos = selRectPos < 7 ? ++selRectPos : 0;
                }
            } else if (gameState == 1011 || gameState == 1001) {
                if (n == this.upKey || n == -1) {
                    selRectPos = selRectPos > 0 ? --selRectPos : 2;
                } else if (n == this.downKey || n == -2) {
                    selRectPos = selRectPos < 2 ? ++selRectPos : 0;
                }
            }
            if (n == -6 && gameState == 4) {
                this.PPage = 4;
                gameState = 25;
            }
            if (n == -11) {
                this.parent.exitMIDlet();
            }
            if (n == this.fireKey || n == 53) {
                if (gameState == 0) {
                    if (this.title != null) {
                        this.title = null;
                    }
                    System.gc();
                    gdm = new GameDataManager(this);
                    gdm.GetRecords();
                    gdm.getSettings();
                    gameState = 1;
                } else if (gameState == 3) {
                    gameState = this.PPage == 4 ? 25 : 1;
                } else if (gameState == 5 || gameState == 51) {
                    gameState = this.PPage == 4 ? 25 : 1;
                } else if (gameState == 2) {
                    if (this.helppage == 0) {
                        this.helppage = 1;
                    } else if (this.helppage == 1) {
                        this.helppage = 2;
                    } else if (this.helppage == 2) {
                        this.helppage = 0;
                        gameState = this.PPage == 4 ? 25 : 1;
                        return;
                    }
                } else {
                    if (gameState == 88) {
                        if (this.cpage == 0) {
                            ++this.cpage;
                        } else {
                            this.cpage = 0;
                            gameState = this.PPage == 4 ? 25 : 1;
                        }
                        return;
                    }
                    if (gameState == 1) {
                        switch (selRectPos) {
                            case 0: {
                                this.init();
                                this.newGame();
                                this.newWave();
                                this.newLevel();
                                System.gc();
                                gameState = 4;
                                break;
                            }
                            case 1: {
                                this.helppage = 0;
                                gameState = 2;
                                break;
                            }
                            case 2: {
                                gameState = 3;
                                break;
                            }
                            case 3: {
                                gameState = 5;
                                break;
                            }
                            case 4: {
                                selRectPos = sndEnable ? 1 : 0;
                                gameState = 1001;
                                break;
                            }
                            case 5: {
                                gameState = 88;
                                break;
                            }
                            case 6: {
                                this.parent.exitMIDlet();
                            }
                        }
                    } else if (gameState == 25) {
                        switch (selRectPos) {
                            case 0: {
                                gameState = 4;
                                break;
                            }
                            case 1: {
                                this.init();
                                this.newGame();
                                this.newWave();
                                this.newLevel();
                                System.gc();
                                gameState = 4;
                                break;
                            }
                            case 2: {
                                this.helppage = 0;
                                gameState = 2;
                                break;
                            }
                            case 3: {
                                gameState = 3;
                                break;
                            }
                            case 4: {
                                gameState = 51;
                                break;
                            }
                            case 5: {
                                selRectPos = sndEnable ? 1 : 0;
                                gameState = 1011;
                                break;
                            }
                            case 6: {
                                gameState = 88;
                                break;
                            }
                            case 7: {
                                this.parent.exitMIDlet();
                            }
                        }
                    } else if (gameState == 1001 || gameState == 1011) {
                        switch (selRectPos) {
                            case 0: {
                                sndEnable = true;
                                gdm.saveSettings(1);
                                break;
                            }
                            case 1: {
                                sndEnable = false;
                                gdm.saveSettings(0);
                                break;
                            }
                            case 2: {
                                if (gameState == 1001) {
                                    selRectPos = 4;
                                    gameState = 1;
                                    break;
                                }
                                selRectPos = 5;
                                gameState = 25;
                            }
                        }
                        return;
                    }
                }
            }
            if (gameState == 4) {
                if (!(this.mStatus != 2 && this.mStatus != 4 || n != this.fireKey && n != 56 && n != 53)) {
                    this.mShooting = false;
                }
                if (this.keyboardmode) {
                    this.repaint();
                }
            }
        }
    }

    protected void keyReleased(int n) {
        if (temk == 1) {
            temk = 0;
        }
    }

    public void resetMovement() {
        this.mShooting = false;
        this.mTurningRight = false;
        this.mTurningLeft = false;
        this.mMoveRight = false;
        this.mMoveLeft = false;
    }

    public void handleGun() {
        if (this.mStatus == 2 || this.mStatus == 4) {
            if (this.mTurningLeft) {
                if (mDirection > 1) {
                    --mDirection;
                }
                this.mTurningLeft = false;
            } else if (this.mTurningRight) {
                if (mDirection < 5) {
                    ++mDirection;
                }
                this.mTurningRight = false;
            } else if (this.mMoveLeft) {
                mGunX = mGunX > this.tankWidth / 2 ? (mGunX -= 5) : this.tankWidth / 2;
            } else if (this.mMoveRight) {
                mGunX = mGunX < this.getWidth() - this.tankWidth / 2 ? (mGunX += 5) : this.getWidth() - this.tankWidth / 2;
            }
            if (this.mShooting && this.mStatus == 2) {
                if (mShells == 0) {
                    return;
                }
                if (this.mLastBullet >= this.mMaxBullets) {
                    this.mLastBullet = 0;
                }
                switch (mDirection) {
                    case 0: {
                        this.mBullets[this.mLastBullet].fire(mGunX - 5 + 2, mGunY - 2, this.dirx[mDirection], this.diry[mDirection], mDirection);
                        break;
                    }
                    case 1: {
                        this.mBullets[this.mLastBullet].fire(mGunX - 10 + 2, mGunY - 13, this.dirx[mDirection], this.diry[mDirection], mDirection);
                        break;
                    }
                    case 2: {
                        this.mBullets[this.mLastBullet].fire(mGunX - 10, mGunY - 15, this.dirx[mDirection], this.diry[mDirection], mDirection);
                        break;
                    }
                    case 3: {
                        this.mBullets[this.mLastBullet].fire(mGunX - 2, mGunY - 5, this.dirx[mDirection], this.diry[mDirection], mDirection);
                        break;
                    }
                    case 4: {
                        this.mBullets[this.mLastBullet].fire(mGunX + 10, mGunY - 15, this.dirx[mDirection], this.diry[mDirection], mDirection);
                        break;
                    }
                    case 5: {
                        this.mBullets[this.mLastBullet].fire(mGunX + 8, mGunY - 14, this.dirx[mDirection], this.diry[mDirection], mDirection);
                        break;
                    }
                    case 6: {
                        this.mBullets[this.mLastBullet].fire(mGunX + 5, mGunY + 2, this.dirx[mDirection], this.diry[mDirection], mDirection);
                    }
                }
                this.mShooting = false;
                ++this.mLastBullet;
                if (--mShells <= 0) {
                    this.mStatus = 1;
                }
            }
        }
    }

    void addExplosion(int n, int n2) {
        if (this.mLastExplosion >= this.mMaxExplosions) {
            this.mLastExplosion = 0;
        }
        this.mExplosions[this.mLastExplosion].stationary(n, n2);
        ++this.mLastExplosion;
    }

    void startAfterExploding() {
        this.resetMovement();
        mDirection = 3;
        this.removeAllBullets();
        this.removeAllBombs();
        this.removeAllExplosions();
        int n = 0;
        while (n < 2) {
            this.planes[n].stop();
            ++n;
        }
        if (this.mLevel > 1) {
            int n2 = 0;
            while (n2 < 2) {
                this.choppers[n2].stop();
                ++n2;
            }
        }
        this.mStatusTimer = 0;
        this.mTroopers.removeAllElements();
    }

    private void removeAllExplosions() {
        int n = 0;
        while (n < this.mMaxExplosions) {
            this.mExplosions[n].mStatus = 0;
            ++n;
        }
    }

    public void newWave() {
        mMaxBombOnScreen = 5;
        mMaxDelayBetweenBombs = 10;
        mBombYSpeed = 5;
        mNumBombsToBeDeployedAtATime = 1;
        mTrooperYSpeed = 1;
        this.mMaxTroopersOnScreen = 5;
        this.mMaxDelayBetweenTroopers = 20;
        this.mDelayBetweenPlanes = 300;
        this.mNumTroopersToBeDeployedAtATime = 1;
        this.mWave = 0;
    }

    private void removeAllBullets() {
        int n = 0;
        while (n < this.mMaxBullets) {
            this.mBullets[n].hide();
            ++n;
        }
    }

    private void removeAllBombs() {
        int n = 0;
        while (n < this.mMaxBomb) {
            this.mBombs[n].hide();
            ++n;
        }
    }

    public void newGame() {
        this.mLevel = 0;
        this.mWave = 0;
        mScore = 0;
        mHealth = 100;
        mShells = 50;
        this.paraDown = 0;
        this.planeDown = 0;
        this.chopperDown = 0;
        this.paraEscaped = 5;
        Trooper.mTroopImage = this.trooperImgs[0];
        this.removeAllBullets();
    }

    public void newLevel() {
        this.paraDown = 0;
        this.planeDown = 0;
        this.chopperDown = 0;
        this.paraEscaped = 5;
        this.removeAllBullets();
        ++this.mLevel;
        if (this.mLevel == 1) {
            this.mTroopers.setZigZag(false);
        }
        if (this.mLevel == 4) {
            this.mNumTroopersToBeDeployedAtATime = 2;
        }
        if (this.mLevel > 6) {
            this.mNumTroopersToBeDeployedAtATime = 1;
        }
        if (this.mLevel >= 13) {
            this.mNumTroopersToBeDeployedAtATime = 2;
        }
        if (this.mLevel == 20) {
            this.mNumTroopersToBeDeployedAtATime = 2;
        }
        if (this.mLevel == 10) {
            this.newWave();
            mTrooperYSpeed += 3;
            this.mTroopers.setZigZag(true);
            Trooper.mTroopImage = this.trooperImgs[0];
        }
        if (this.mLevel == 20) {
            this.newWave();
            mTrooperYSpeed = 5;
            this.mTroopers.setZigZag(true);
        }
        ++this.mWave;
        this.ResetGun();
        this.mDelayBetweenPlanes += 25;
        if (this.mDelayBetweenPlanes > 700) {
            this.mDelayBetweenPlanes = 700;
        }
        if (this.mWave % 2 == 0) {
            ++this.mMaxTroopersOnScreen;
            if (this.mMaxTroopersOnScreen > 15) {
                this.mMaxTroopersOnScreen = 15;
            }
        }
        --this.mMaxDelayBetweenTroopers;
        if (this.mMaxDelayBetweenTroopers < 3) {
            this.mMaxDelayBetweenTroopers = 3;
        }
        this.mDelayBetweenTroopers = this.mMaxDelayBetweenTroopers;
        this.mMaxTroopersOnThisLevel = this.mWave * 10;
        if (this.mMaxTroopersOnThisLevel > 50) {
            this.mMaxTroopersOnThisLevel = 50;
        }
        this.mNumTroopersKilled = 0;
        if (++mTrooperYSpeed > 10) {
            mTrooperYSpeed = 10;
        }
        this.mTroopers.clear();
        this.mStatus = 4;
        this.mStatusTimer = 0;
        mDirection = 3;
        this.resetMovement();
        this.mLastExplosion = 0;
    }

    private void deployTroopers() {
        ++this.mDelayBetweenTroopers;
        if (this.mDelayBetweenTroopers > this.mMaxDelayBetweenTroopers && this.mTroopers.size() < this.mMaxTroopersOnScreen) {
            this.mDelayBetweenTroopers = 0;
            int n = TrooperVector.mDeadTroopers + this.mTroopers.size();
            int n2 = 0;
            while (n2 < this.mNumTroopersToBeDeployedAtATime && n < this.mMaxTroopersOnThisLevel) {
                int n3 = (this.random.nextInt() >>> 1) % this.WIDTH;
                if (n3 <= 0) {
                    n3 = Trooper.mChuteWidth + 25;
                }
                if (n3 >= this.WIDTH) {
                    n3 = this.WIDTH - 25;
                }
                this.mTroopers.add(new Trooper(n3, 0, mTrooperYSpeed));
                ++n;
                ++n2;
            }
        }
    }

    private void DrawGamePlay(Graphics graphics) {
        this.DrawBGS(graphics);
        graphics.setColor(175, 39, 202);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        int n = 11;
        int n2 = 5;
        int n3 = 7;
        if (this.helppage == 0) {
            graphics.drawString("Help", n2 + 40, n3 + n * 0, 20);
            graphics.drawString("You, the  leader  of  a", n2, n3 + n * 1 + 2, 20);
            graphics.drawString("tank unit are the sole", n2, n3 + n * 2 + 2, 20);
            graphics.drawString("survivor of a brutal", n2, n3 + n * 3 + 2, 20);
            graphics.drawString("enemy air attack and", n2, n3 + n * 4 + 2, 20);
            graphics.drawString("are stuck behind enemy", n2, n3 + n * 5 + 2, 20);
            graphics.drawString("lines. Your orders are", n2, n3 + n * 6 + 2, 20);
            graphics.drawString("to be there till backup", n2, n3 + n * 7 + 2, 20);
            graphics.drawString("arrives, irrespective of", n2, n3 + n * 8 + 2, 20);
            graphics.setColor(0, 0, 0);
            graphics.drawString("More", this.WIDTH - 23, this.HEIGHT - 9, 0x10 | 4);
        } else if (this.helppage == 1) {
            graphics.drawString("Help", n2 + 40, n3 + n * 0, 20);
            graphics.drawString("the consequences!!", n2, n3 + n * 1 + 2, 20);
            graphics.drawString("When you have no", n2, n3 + n * 2 + 2, 20);
            graphics.drawString("choice left, attack is the", n2, n3 + n * 3 + 2, 20);
            graphics.drawString("best form of defence.", n2, n3 + n * 4 + 2, 20);
            graphics.drawString("Maneuver your tank to", n2, n3 + n * 5 + 2, 20);
            graphics.drawString("fend off attacking", n2, n3 + n * 6 + 2, 20);
            graphics.drawString("paratroopers and aim", n2, n3 + n * 7 + 2, 20);
            graphics.drawString("well to blow off the", n2, n3 + n * 8 + 2, 20);
            graphics.setColor(0, 0, 0);
            graphics.drawString("More", this.WIDTH - 23, this.HEIGHT - 9, 0x10 | 4);
        } else if (this.helppage == 2) {
            graphics.drawString("Help", n2 + 40, n3 + n * 0, 20);
            graphics.drawString("planes and paratroopers", n2, n3 + n * 1 + 2, 20);
            graphics.drawString("out of the skies. Its time", n2, n3 + n * 2 + 2, 20);
            graphics.drawString("to launch a Tank Attack.", n2, n3 + n * 3 + 2, 20);
            graphics.setColor(0, 0, 0);
            graphics.drawString("Exit", this.WIDTH - 23, this.HEIGHT - 9, 0x10 | 4);
        }
    }

    private void DrawControls(Graphics graphics) {
        this.DrawBGS(graphics);
        int n = 60;
        int n2 = 20;
        int n3 = 30;
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.setColor(175, 39, 202);
        graphics.drawString("Game controls", 25, 65 - n, 0x10 | 4);
        graphics.drawString("Key   Action", 25 - n2, 80 - n, 0x10 | 4);
        graphics.drawString("1     Move gun left", 25 - n2, 92 - n, 0x10 | 4);
        graphics.drawString("3     Move gun right", 25 - n2, 104 - n, 0x10 | 4);
        graphics.drawString("2     Hold gun vertically", 25 - n2, 116 - n, 0x10 | 4);
        graphics.drawString("4     Move tank left", 25 - n2, 128 - n, 0x10 | 4);
        graphics.drawString("6     Move tank right", 25 - n2, 140 - n, 0x10 | 4);
        graphics.drawString("5     Shoot", 25 - n2, 152 - n, 0x10 | 4);
        graphics.setColor(0, 0, 0);
        graphics.drawString("Exit", this.WIDTH - 23, this.HEIGHT - 9, 0x10 | 4);
    }

    public void DrawBGS(Graphics graphics) {
        graphics.setColor(129, 183, 244);
        graphics.fillRect(0, 0, this.WIDTH, this.HEIGHT);
        graphics.setColor(255, 255, 204);
        graphics.fillRect(2, 3, this.WIDTH - 4, this.HEIGHT - 15);
    }

    public void drawMenu(Graphics graphics) {
        this.DrawBGS(graphics);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.setColor(0, 102, 204);
        graphics.setColor(175, 39, 202);
        int n = 10;
        int n2 = 10;
        int n3 = 13;
        graphics.drawString("     New game", n, n2 + n3 * 0, 0x10 | 4);
        graphics.drawString("     Help", n, n2 + n3 * 1, 0x10 | 4);
        graphics.drawString("     Game controls", n, n2 + n3 * 2, 0x10 | 4);
        graphics.drawString("     High score", n, n2 + n3 * 3, 0x10 | 4);
        graphics.drawString("     Settings", n, n2 + n3 * 4, 0x10 | 4);
        graphics.drawString("     About", n, n2 + n3 * 5, 0x10 | 4);
        graphics.drawString("     Exit", n, n2 + n3 * 6, 0x10 | 4);
        int n4 = 100;
        int n5 = 13;
        graphics.fillRoundRect(n - 2, n2 + n3 * selRectPos - 2, n4, n5, 5, 5);
        graphics.setColor(255, 255, 204);
        switch (selRectPos) {
            case 0: {
                graphics.drawString("     New game", n, n2 + n3 * 0, 0x10 | 4);
                break;
            }
            case 1: {
                graphics.drawString("     Help", n, n2 + n3 * 1, 0x10 | 4);
                break;
            }
            case 2: {
                graphics.drawString("     Game controls", n, n2 + n3 * 2, 0x10 | 4);
                break;
            }
            case 3: {
                graphics.drawString("     High score", n, n2 + n3 * 3, 0x10 | 4);
                break;
            }
            case 4: {
                graphics.drawString("     Settings", n, n2 + n3 * 4, 0x10 | 4);
                break;
            }
            case 5: {
                graphics.drawString("     About", n, n2 + n3 * 5, 0x10 | 4);
                break;
            }
            case 6: {
                graphics.drawString("     Exit", n, n2 + n3 * 6, 0x10 | 4);
            }
        }
        graphics.setColor(0, 0, 0);
        graphics.drawString("Select", this.WIDTH - 30, this.HEIGHT - 9, 0x10 | 4);
    }

    public void DrawSubMenu(Graphics graphics) {
        this.DrawBGS(graphics);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.setColor(175, 39, 202);
        int n = 10;
        int n2 = 10;
        int n3 = 13;
        graphics.drawString("     Continue", n, n2 + n3 * 0, 0x10 | 4);
        graphics.drawString("     New game", n, n2 + n3 * 1, 0x10 | 4);
        graphics.drawString("     Help", n, n2 + n3 * 2, 0x10 | 4);
        graphics.drawString("     Game controls", n, n2 + n3 * 3, 0x10 | 4);
        graphics.drawString("     High score", n, n2 + n3 * 4, 0x10 | 4);
        graphics.drawString("     Settings", n, n2 + n3 * 5, 0x10 | 4);
        graphics.drawString("     About", n, n2 + n3 * 6, 0x10 | 4);
        graphics.drawString("     Exit", n, n2 + n3 * 7, 0x10 | 4);
        int n4 = 100;
        int n5 = 13;
        graphics.fillRoundRect(n - 2, n2 + n3 * selRectPos - 2, n4, n5, 5, 5);
        graphics.setColor(255, 255, 204);
        switch (selRectPos) {
            case 0: {
                graphics.drawString("     Continue", n, n2 + n3 * 0, 0x10 | 4);
                break;
            }
            case 1: {
                graphics.drawString("     New game", n, n2 + n3 * 1, 0x10 | 4);
                break;
            }
            case 2: {
                graphics.drawString("     Help", n, n2 + n3 * 2, 0x10 | 4);
                break;
            }
            case 3: {
                graphics.drawString("     Game controls", n, n2 + n3 * 3, 0x10 | 4);
                break;
            }
            case 4: {
                graphics.drawString("     High score", n, n2 + n3 * 4, 0x10 | 4);
                break;
            }
            case 5: {
                graphics.drawString("     Settings", n, n2 + n3 * 5, 0x10 | 4);
                break;
            }
            case 6: {
                graphics.drawString("     About", n, n2 + n3 * 6, 0x10 | 4);
                break;
            }
            case 7: {
                graphics.drawString("     Exit", n, n2 + n3 * 7, 0x10 | 4);
            }
        }
        graphics.setColor(0, 0, 0);
        graphics.drawString("Select", this.WIDTH - 30, this.HEIGHT - 9, 0x10 | 4);
    }

    public void DrawSoundMenu(Graphics graphics) {
        this.DrawBGS(graphics);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.setColor(175, 39, 202);
        graphics.drawString("Settings", 40, 7, 20);
        int n = 10;
        int n2 = 35;
        int n3 = 15;
        if (sndEnable) {
            graphics.drawString("     Sound on <<", n, n2 + n3 * 0, 0x10 | 4);
        } else {
            graphics.drawString("     Sound on ", n, n2 + n3 * 0, 0x10 | 4);
        }
        if (!sndEnable) {
            graphics.drawString("     Sound off <<", n, n2 + n3 * 1, 0x10 | 4);
        } else {
            graphics.drawString("     Sound off", n, n2 + n3 * 1, 0x10 | 4);
        }
        graphics.drawString("     Menu", n, n2 + n3 * 2, 0x10 | 4);
        int n4 = 100;
        int n5 = 13;
        graphics.fillRoundRect(n - 2, n2 + n3 * selRectPos - 2, n4, n5, 5, 5);
        graphics.setColor(255, 255, 204);
        switch (selRectPos) {
            case 0: {
                if (sndEnable) {
                    graphics.drawString("     Sound on <<", n, n2 + n3 * 0, 0x10 | 4);
                    break;
                }
                graphics.drawString("     Sound on ", n, n2 + n3 * 0, 0x10 | 4);
                break;
            }
            case 1: {
                if (!sndEnable) {
                    graphics.drawString("     Sound off <<", n, n2 + n3 * 1, 0x10 | 4);
                    break;
                }
                graphics.drawString("     Sound off", n, n2 + n3 * 1, 0x10 | 4);
                break;
            }
            case 2: {
                graphics.drawString("     Menu", n, n2 + n3 * 2, 0x10 | 4);
            }
        }
        graphics.setColor(0, 0, 0);
        graphics.drawString("Select", this.WIDTH - 30, this.HEIGHT - 9, 0x10 | 4);
    }

    static {
        sndEnable = true;
        mTrooperYSpeed = 3;
        rname = new String();
        MAX_EXP_IMGS = 2;
        totalMedia = 40;
        loadedMedia = 0;
        medialoaded = false;
        selRectPos = 0;
        temk = 0;
        mDX = 0;
        mDY = -1;
        mMaxDelayBetweenBombs = 10;
        mBombYSpeed = 5;
        mNumBombsToBeDeployedAtATime = 1;
    }

    class GameTimer
    extends TimerTask {
        private GameCanvas game;

        public GameTimer() {
            this.game = GameCanvas.this;
        }

        public final void run() {
            if (this.game.parent.lg != null) {
                if (medialoaded) {
                    gameState = 0;
                    this.game.parent.display.setCurrent((Displayable)this.game);
                    this.game.parent.lg = null;
                    gameState = 0;
                    System.gc();
                }
            } else if (gameState == 4) {
                if (!GameCanvas.this.mShooting && sndEnable) {
                    SoundPlayer.shootSound.stop();
                }
                this.game.handleGun();
            }
            this.game.repaint();
        }
    }
}

