/*
 * Decompiled with CFR 0.152.
 */
package mw;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import mw.NokiaMain;
import mw.NokiaSketch;
import mw.Visualizer01;
import mw.util.ContactList;

public class ScreenMenu
extends NokiaSketch {
    public String NEW = "New Message";
    public String SAVE = "Save Image";
    public String SEND = "Send as MMS";
    public String ABOUT = "About";
    public String BLANK = "";
    public String SELECTED = "> ";
    public String EXIT = "Exit";
    public String[] menu;
    public int selected = 0;
    public int savingCnt = 0;

    public ScreenMenu(NokiaMain _p) {
        super(_p);
    }

    public void reinit() {
        this.log("menu.reinit()");
        this.img = this.p.imgScr;
        this.gr = this.img.getGraphics();
        this.drawBackgroundGradient();
        this.gr.drawImage(this.p.imgMenu, this.p.width - this.p.imgMenu.getWidth(), this.p.height - this.p.imgMenu.getHeight(), 20);
        this.gr.drawImage(this.p.imgTitle, 26, 23, 20);
        this.menu = new String[]{this.NEW, this.ABOUT, this.BLANK, this.EXIT};
        if (((Visualizer01)this.p.scr[NokiaMain.VISUAL]).img != null) {
            this.menu = new String[]{this.NEW, this.SAVE, this.SEND, this.ABOUT, this.BLANK, this.EXIT};
        }
        this.fnt = this.p.uiFntDark;
        this.px = this.p.width / 2 - 60;
        this.py = this.p.height / 2 - 65;
        this.px = 36;
        this.py = 70;
    }

    public void draw() {
        int y = this.py;
        this.p.canvas.bufferg.drawImage(this.img, 0, 0, 20);
        int i = 0;
        while (i < this.menu.length) {
            y += this.fnt.fontHeight;
            if (this.selected == i) {
                this.fnt.draw(String.valueOf(this.SELECTED) + this.menu[i], this.px, y);
            } else {
                this.fnt.draw(this.menu[i], this.px + 10, y);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMMS() {
        String tmp = String.valueOf(ContactList.numLists) + " lists: ";
        int i = 0;
        while (i < ContactList.numLists) {
            tmp = String.valueOf(tmp) + ContactList.n[i] + " | ";
            ++i;
        }
        this.log("sendMMS() - " + ContactList.num + " contacts found. " + tmp);
        MMSForm form = new MMSForm(this.p);
        ScreenMenu screenMenu = this;
        synchronized (screenMenu) {
            this.p.display.setCurrent((Displayable)form);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.p.display.setCurrent((Displayable)this.p.canvas);
        return true;
    }

    public void keyPressed(char key, int keyCode) {
        String keyName;
        try {
            keyName = this.p.canvas.getKeyName(keyCode);
        }
        catch (Exception e1) {
            keyName = "Nokey";
        }
        this.log("menu.keyPressed '" + key + "' " + keyCode + "," + this.p.keyCodeOriginal + " '" + keyName + "' ");
        if (keyCode == 1) {
            do {
                --this.selected;
                if (this.selected >= 0) continue;
                this.selected = this.menu.length - 1;
            } while (this.menu[this.selected].equals(this.BLANK));
        }
        if (keyCode == 6) {
            do {
                ++this.selected;
                if (this.selected != this.menu.length) continue;
                this.selected = 0;
            } while (this.menu[this.selected].equals(this.BLANK));
        }
        if (keyCode == NokiaMain.SELECT) {
            try {
                this.log("selected: " + this.menu[this.selected]);
                if (this.menu[this.selected].equals(this.NEW)) {
                    this.p.setCurrent(NokiaMain.MESSAGE);
                } else if (this.menu[this.selected].equals(this.SEND)) {
                    this.p.setCurrent(NokiaMain.MMS);
                } else if (this.menu[this.selected].equals(this.ABOUT)) {
                    this.p.setCurrent(NokiaMain.ABOUT);
                } else if (this.menu[this.selected].equals(this.EXIT)) {
                    this.p.exit();
                } else if (this.menu[this.selected].equals(this.SAVE)) {
                    this.p.setCurrent(NokiaMain.SAVING);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class MMSForm
    extends Form
    implements CommandListener {
        private NokiaMain midlet;
        private Command cmdOk;
        private Command cmdCancel;
        private boolean cancelled;
        private TextField mmsAddress;

        public MMSForm(NokiaMain midlet) {
            super("Send via MMS");
            this.midlet = midlet;
            this.mmsAddress = new TextField("Send to", null, 40, 3);
            this.append((Item)this.mmsAddress);
            String names = "";
            int i = 0;
            while (i < ContactList.num) {
                names = String.valueOf(names) + ContactList.name[i] + "\n\r";
                ++i;
            }
            TextField nameList = new TextField("Send to", names, 40, 3);
            this.append((Item)nameList);
            this.cmdOk = new Command("Send", 4, 1);
            this.cmdCancel = new Command("Cancel", 3, 2);
            this.addCommand(this.cmdOk);
            this.addCommand(this.cmdCancel);
            this.setCommandListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(Command c, Displayable d) {
            if (c == this.cmdCancel) {
                this.cancelled = true;
            }
            NokiaMain nokiaMain = this.midlet;
            synchronized (nokiaMain) {
                this.midlet.notifyAll();
            }
        }
    }
}

