/*
 * Decompiled with CFR 0.152.
 */
package mw;

import javax.microedition.lcdui.Image;
import mw.FontDark;
import mw.FontLight;
import mw.MWMidlet;
import mw.NokiaMain;
import mw.NokiaSketch;
import mw.PixelFont;
import mw.TypoAnim;
import mw.util.ColorPalette;
import mw.util.ColorSet;
import mw.util.ColorUtil;
import mw.util.SVGObject;

public class Visualizer01
extends NokiaSketch {
    SVGObject svg;
    int num;
    int palette;
    int numpal = 0;
    int[][] gradient;
    int[] fntCol;
    String[] s;
    Crawler[] word;
    TypoAnim typo;
    boolean doClear;
    int frameCnt;
    PixelFont fnt;
    PixelFont fntLight = new FontLight(this.p);
    PixelFont fntDark = new FontDark(this.p);
    PixelFont newFont;

    public Visualizer01(NokiaMain _p) {
        super(_p);
        this.typo = new TypoAnim(this, this.fntLight);
    }

    public void reinit() {
        int n;
        if (this.img == null) {
            this.img = Image.createImage((int)this.p.width, (int)this.p.height);
        }
        this.log("Visualizer.reinit - " + this.img.getWidth() + "x" + this.img.getHeight());
        this.gr = this.img.getGraphics();
        this.initColors();
        String tmp = "";
        String tmpIn = this.p.inputTxt.toLowerCase();
        int i = 0;
        while (i < tmpIn.length()) {
            char ch = tmpIn.charAt(i);
            if (this.isLetter(ch) || ch == ' ') {
                tmp = String.valueOf(tmp) + ch;
            }
            ++i;
        }
        this.doClear = true;
        this.frameCnt = 0;
        this.typo.reinit();
        this.fnt = this.newFont;
        this.typo.setFont(this.fnt);
        this.num = n = this.typo.n;
        if (n < 6) {
            this.num *= 3;
        } else if (n < 12) {
            this.num *= 2;
        }
        this.word = new Crawler[this.num];
        int i2 = 0;
        while (i2 < this.num) {
            int tmpN = i2 % n;
            System.out.println(String.valueOf(i2) + " " + n + " " + tmpN);
            this.word[i2] = new Crawler(this.typo.l[tmpN].x2 + this.typo.l[tmpN].w / 2, this.typo.l[tmpN].y2 + this.fnt.fontHeight / 2, this.typo.l[tmpN].ch);
            ++i2;
        }
    }

    public void draw() {
        if (this.svg == null) {
            this.svg = new SVGObject(this.p);
        } else {
            this.svg.clear();
        }
        if (this.doClear) {
            this.clear();
        }
        ++this.frameCnt;
        int i = this.num - 1;
        while (i > -1) {
            if (this.typo.l[i % this.typo.n].done && !this.word[i].done) {
                this.word[i].draw();
            }
            --i;
        }
        if (this.svg != null) {
            this.svg.draw(this.gr);
        }
        this.p.canvas.bufferg.drawImage(this.img, 0, 0, 20);
        this.typo.draw();
        this.p.drawButtons(1);
        this.p.canvas.bufferg.drawImage(this.p.imgNavikey, this.p.width / 2 - 8, this.p.height - 20, 20);
    }

    public void drawFlatType() {
        this.typo.draw(this.gr);
    }

    public void clear() {
        float ph = this.p.height - 1;
        this.log("clear() " + this.p.width + "x" + this.p.height + " - " + this.img.getWidth() + "x" + this.img.getHeight());
        float i = 0.0f;
        while (i < (float)this.p.height) {
            this.gr.setColor(ColorUtil.colorBlended(MWMidlet.sinf(180.0f * (i / (float)this.p.height)), this.gradient[this.palette][0], this.gradient[this.palette][1]));
            this.gr.fillRect(0, (int)i, this.p.width, 2);
            i += 1.0f;
        }
        this.doClear = false;
    }

    public void initColors() {
        if (this.pal == null) {
            this.pal = new ColorPalette();
            this.numpal = 2;
            this.gradient = new int[this.numpal][2];
            this.fntCol = new int[this.numpal];
            ColorSet set = new ColorSet();
            set.add(4, 7, "FFFF00", "FF8700");
            set.add(3, 4, "93FFFF", "FFFFFF");
            set.add(3, 6, "006EB9", "00D0FF");
            set.add(3, 6, "FF4397", "C90088");
            this.pal.addSet(set);
            this.gradient[0][0] = ColorUtil.color("94AAAD");
            this.gradient[0][1] = ColorUtil.color("FFFFFF");
            this.fntCol[0] = ColorUtil.color("000000");
            set = new ColorSet();
            set.add(3, 6, "325332", "AAE700");
            set.add(3, 6, "0C5F6D", "6AFFFF");
            set.add(3, 6, "E9E900", "D79B00");
            this.pal.addSet(set);
            this.gradient[1][0] = ColorUtil.color("000000");
            this.gradient[1][1] = ColorUtil.color("3B3E40");
            this.fntCol[1] = ColorUtil.color("FFFFFF");
            this.palette = -1;
        }
        this.palette = (this.palette + 1) % this.numpal;
        this.pal.initPalette(this.palette);
        this.newFont = this.palette < 1 ? this.fntDark : this.fntLight;
    }

    public void keyPressed(char key, int keyCode) {
        if (keyCode == 1 || keyCode == 6 || keyCode == 5 || keyCode == 2 || this.p.keyCodeOriginal == -5) {
            this.reinit();
        } else if (keyCode == -6) {
            this.p.setCurrent(NokiaMain.MENU);
        } else {
            String keyName;
            try {
                keyName = this.p.canvas.getKeyName(keyCode);
            }
            catch (Exception e1) {
                keyName = "Nokey";
            }
            this.log("menu.keyPressed '" + key + "' " + keyCode + "," + this.p.keyCodeOriginal + " '" + keyName + "' ");
        }
    }

    public class Crawler {
        char ch;
        int col;
        int r;
        int g;
        int b;
        float x;
        float y;
        float px1;
        float py1;
        float px2;
        float py2;
        float deg;
        float degD;
        float rad;
        float radD;
        float speed;
        boolean done = false;
        boolean first = true;
        int cnt;
        int doneCnt;
        int maxDoneCnt;
        int type;
        int interval;

        public Crawler(float _x, float _y, char _c) {
            this.x = _x;
            this.y = _y;
            this.ch = _c;
            this.cnt = Visualizer01.this.rnd.rndInt(60, 100);
            this.doneCnt = 0;
            this.maxDoneCnt = Visualizer01.this.rnd.rndInt(2, 4);
            this.deg = Visualizer01.this.rnd.rndFloat(360.0f);
            this.rad = 1.0f;
            this.radD = Visualizer01.this.rnd.rndFloat(5.0f, 15.0f) / (float)this.cnt;
            this.degD = Visualizer01.this.rnd.rndFloat(60.0f, 180.0f) / (float)this.cnt;
            this.speed = Visualizer01.this.rnd.rndFloat(0.75f, 1.5f);
            if (Visualizer01.this.rnd.probGt(90.0f)) {
                this.speed = Visualizer01.this.rnd.rndFloat(1.5f, 2.5f);
            }
            this.col = Visualizer01.this.pal.getRandomCol();
            this.r = ColorUtil.getRed(this.col);
            this.g = ColorUtil.getGreen(this.col);
            this.b = ColorUtil.getBlue(this.col);
            this.type = 0;
            if (Visualizer01.this.isVowel(this.ch)) {
                this.type = 1;
            }
            this.interval = Visualizer01.this.rnd.rndInt(1, 3);
        }

        public void draw() {
            Visualizer01.this.svg.stroke(this.r, this.g, this.b);
            if (this.type == 0 && (this.cnt % this.interval == 0 || this.cnt == 1)) {
                this.px1 = MWMidlet.cosfFix(this.deg + 90.0f) * this.rad;
                this.py1 = MWMidlet.sinfFix(this.deg + 90.0f) * this.rad;
                this.px2 = this.x - this.px1;
                this.py2 = this.y - this.py1;
                this.px1 += this.x;
                this.py1 += this.y;
                Visualizer01.this.svg.line(this.px1, this.py1, this.px2, this.py2);
            }
            if (this.type == 1) {
                this.px1 = this.x;
                this.py1 = this.y;
            }
            this.deg += this.degD;
            this.rad += this.radD;
            this.x += MWMidlet.cosfFix(this.deg) * this.speed;
            this.y += MWMidlet.sinfFix(this.deg) * this.speed;
            if (this.type == 1) {
                Visualizer01.this.svg.line(this.px1, this.py1, this.x, this.y);
            }
            if (this.x < -this.rad) {
                this.x = (float)Visualizer01.this.p.width + this.rad;
            }
            if (this.x > (float)Visualizer01.this.p.width + this.rad) {
                this.x = -this.rad;
            }
            if (this.y < -this.rad) {
                this.y = (float)Visualizer01.this.p.height + this.rad;
            }
            if (this.y > (float)Visualizer01.this.p.height + this.rad) {
                this.y = -this.rad;
            }
            --this.cnt;
            if (this.cnt < 1) {
                if (this.type == 1 && this.doneCnt > 0) {
                    Visualizer01.this.svg.noStroke();
                    Visualizer01.this.svg.fill(this.r, this.g, this.b);
                    Visualizer01.this.svg.circle(this.x, this.y, this.maxDoneCnt * 3 - this.doneCnt * 3 + 2);
                }
                ++this.doneCnt;
                this.cnt = Visualizer01.this.rnd.rndInt(40, 70);
                this.radD = (Visualizer01.this.rnd.rndFloat(5.0f, 15.0f) - this.rad) / (float)this.cnt;
                if (this.doneCnt == this.maxDoneCnt) {
                    this.radD = -this.rad / (float)this.cnt;
                }
                this.degD = this.degD > 0.0f ? (Visualizer01.this.rnd.rndFloat(this.deg - 60.0f, this.deg - 30.0f) - this.deg) / (float)this.cnt : (Visualizer01.this.rnd.rndFloat(this.deg + 30.0f, this.deg + 60.0f) - this.deg) / (float)this.cnt;
            }
            if (this.doneCnt > this.maxDoneCnt) {
                this.done = true;
            }
        }
    }
}

