/*
 * Decompiled with CFR 0.152.
 */
package mw.util;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Image;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.MultipartMessage;
import javax.wireless.messaging.SizeExceededException;
import net.sourceforge.mobilebio.png.Encoder;

public class MMS {
    public String addr;
    public String subj;
    public String msg;
    private MessageConnection connection;
    private MultipartMessage message;
    public boolean error = false;
    public String errMsg = "None";
    public int mmsSize;

    public MMS(String _addr, String _subj, String _msg, Image img) {
        this.addr = "mms://" + _addr;
        this.subj = _subj;
        this.msg = _msg;
        try {
            this.connection = (MessageConnection)Connector.open((String)"mms://:MyApp");
            this.message = (MultipartMessage)this.connection.newMessage("multipart");
            this.message.setAddress(this.addr);
            this.message.setSubject(this.subj);
            this.message.setHeader("X-Mms-Priority", "normal");
            byte[] buf = Encoder.toPNG(img);
            this.mmsSize = buf.length;
            MessagePart imgPart = new MessagePart(buf, "image/png", "NokiaConnections", "NokiaConnections.png", null);
            buf = _msg.getBytes("UTF-8");
            this.mmsSize += buf.length;
            MessagePart textPart = new MessagePart(buf, "text/plain", "id1", "message text", "UTF-8");
            this.message.addMessagePart(imgPart);
            this.message.addMessagePart(textPart);
        }
        catch (SizeExceededException ex) {
            ex.printStackTrace();
            this.setError("Message size too big. " + ex.toString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.setError("I/O error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setError("Error: " + ex.getMessage());
        }
        if (this.error) {
            System.out.println(this.errMsg);
        }
    }

    public void send() {
        try {
            this.connection.send((Message)this.message);
            this.connection.close();
        }
        catch (SizeExceededException ex) {
            ex.printStackTrace();
            this.setError("Message size is too big.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.setError("I/O exception on send. " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            this.setError("Phone number is missing.");
        }
    }

    public void setError(String err) {
        this.error = true;
        this.errMsg = err;
    }
}

