/*
 * Decompiled with CFR 0.152.
 */
package mw.util;

import javax.microedition.lcdui.Graphics;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPath;
import org.w3c.dom.svg.SVGRGBColor;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import processing.core.PMIDlet;

public class SVGObject {
    public static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    protected PMIDlet p;
    protected SVGImage svgImage;
    protected Document doc;
    public ScalableGraphics sg = ScalableGraphics.createInstance();
    protected SVGSVGElement svg;
    protected SVGSVGElement path;
    protected SVGPath svgpath;
    public SVGRGBColor fillColor;
    public SVGRGBColor strokeColor;
    public float strokeWeight = 1.0f;
    public static final String FILL = "fill";
    public static final String STROKE = "stroke";
    public static final String CIRCLE = "circle";
    public static final String RECT = "rect";
    public static final String LINE = "line";
    public static final String PATH = "path";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String CX = "cx";
    public static final String CY = "cy";
    public static final String RAD = "r";
    public static final String X1 = "x1";
    public static final String Y1 = "y1";
    public static final String X2 = "x2";
    public static final String Y2 = "y2";
    public static final String STROKEWEIGHT = "stroke-width";
    public static final String D = "d";

    public SVGObject(PMIDlet _p) {
        this.p = _p;
        this.svgImage = SVGImage.createEmptyImage(null);
        this.doc = this.svgImage.getDocument();
        this.svg = (SVGSVGElement)this.doc.getDocumentElement();
        this.fill(255, 255, 255);
        SVGRect vb = this.svg.createSVGRect();
        vb.setWidth((float)this.p.width);
        vb.setHeight((float)this.p.height);
        this.svg.setRectTrait("viewBox", vb);
    }

    public void clear() {
        this.svgImage = SVGImage.createEmptyImage(null);
        this.doc = this.svgImage.getDocument();
        this.svg = (SVGSVGElement)this.doc.getDocumentElement();
    }

    public void fill(int r, int g, int b) {
        this.fillColor = this.svg.createSVGRGBColor(r, g, b);
    }

    public void stroke(int r, int g, int b) {
        this.strokeColor = this.svg.createSVGRGBColor(r, g, b);
    }

    public void strokeWeight(float w) {
        this.strokeWeight = w;
    }

    public void noFill() {
        this.fillColor = null;
    }

    public void noStroke() {
        this.strokeColor = null;
    }

    public void draw(Graphics g) {
        this.sg.bindTarget((Object)g);
        this.svgImage.setViewportWidth(this.p.width);
        this.svgImage.setViewportHeight(this.p.height);
        this.sg.render(0, 0, (ScalableImage)this.svgImage);
        this.sg.releaseTarget();
    }

    public void newPath() {
        SVGElement path = (SVGElement)this.svgImage.getDocument().createElementNS(SVG_NAMESPACE_URI, PATH);
        this.svgpath = this.svg.createSVGPath();
    }

    public void moveTo(float x, float y) {
        this.svgpath.moveTo(x, y);
    }

    public void lineTo(float x, float y) {
        this.svgpath.lineTo(x, y);
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.svgpath.curveTo(x1, y1, x2, y2, x3, y3);
    }

    public void endPath() {
        if (this.fillColor != null) {
            this.path.setRGBColorTrait(FILL, this.fillColor);
        }
        if (this.strokeColor != null) {
            this.path.setRGBColorTrait(STROKE, this.strokeColor);
        }
        if (this.strokeWeight != 1.0f) {
            this.path.setFloatTrait(STROKEWEIGHT, this.strokeWeight);
        }
        this.path.setPathTrait(D, this.svgpath);
    }

    public void circle(float cx, float cy, float r) {
        SVGElement c = (SVGElement)this.doc.createElementNS(SVG_NAMESPACE_URI, CIRCLE);
        if (this.fillColor != null) {
            c.setRGBColorTrait(FILL, this.fillColor);
        }
        if (this.strokeColor != null) {
            c.setRGBColorTrait(STROKE, this.strokeColor);
        }
        if (this.strokeWeight != 1.0f) {
            c.setFloatTrait(STROKEWEIGHT, this.strokeWeight);
        }
        c.setFloatTrait(CX, cx);
        c.setFloatTrait(CY, cy);
        c.setFloatTrait(RAD, r);
        this.svg.appendChild((Node)c);
    }

    public void line(float x1, float y1, float x2, float y2) {
        SVGElement c = (SVGElement)this.doc.createElementNS(SVG_NAMESPACE_URI, LINE);
        if (this.fillColor != null) {
            c.setRGBColorTrait(FILL, this.fillColor);
        }
        if (this.strokeColor != null) {
            c.setRGBColorTrait(STROKE, this.strokeColor);
        }
        if (this.strokeWeight != 1.0f) {
            c.setFloatTrait(STROKEWEIGHT, this.strokeWeight);
        }
        c.setFloatTrait(X1, x1);
        c.setFloatTrait(Y1, y1);
        c.setFloatTrait(X2, x2);
        c.setFloatTrait(Y2, y2);
        this.svg.appendChild((Node)c);
    }

    public void rect(float x, float y, float w, float h) {
        SVGElement r = (SVGElement)this.doc.createElementNS(SVG_NAMESPACE_URI, RECT);
        if (this.fillColor != null) {
            r.setRGBColorTrait(FILL, this.fillColor);
        }
        if (this.strokeColor != null) {
            r.setRGBColorTrait(STROKE, this.strokeColor);
        }
        if (this.strokeWeight != 1.0f) {
            r.setFloatTrait(STROKEWEIGHT, this.strokeWeight);
        }
        r.setFloatTrait(X, x);
        r.setFloatTrait(Y, y);
        r.setFloatTrait(WIDTH, w);
        r.setFloatTrait(HEIGHT, h);
        this.svg.appendChild((Node)r);
    }
}

