/*
 * Decompiled with CFR 0.152.
 */
package mw.util;

import mw.util.Constants;
import mw.util.Util;

public class Vec2D
implements Constants {
    public static final float DEG = (float)Math.PI / 180;
    public static final float RADIAN = 57.295776f;
    public float x;
    public float y;

    public Vec2D() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vec2D(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vec2D(double x, double y) {
        this.x = (float)x;
        this.y = (float)y;
    }

    public Vec2D(Vec2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public static Vec2D nullvec() {
        return new Vec2D(0.0f, 0.0f);
    }

    public void set(Vec2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void set(float tx, float ty) {
        this.x = tx;
        this.y = ty;
    }

    public void add(Vec2D v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void add(float vx, float vy) {
        this.x += vx;
        this.y += vy;
    }

    public static Vec2D add(Vec2D v1, Vec2D v2) {
        return new Vec2D(v1.x + v2.x, v1.y + v2.y);
    }

    public void sub(Vec2D v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public void sub(float vx, float vy) {
        this.x -= vx;
        this.y -= vy;
    }

    public static Vec2D sub(Vec2D v1, Vec2D v2) {
        return new Vec2D(v1.x - v2.x, v1.y - v2.y);
    }

    public void mult(Vec2D v) {
        this.x *= v.x;
        this.y *= v.y;
    }

    public void mult(float vx, float vy) {
        this.x *= vx;
        this.y *= vy;
    }

    public void mult(float m) {
        this.x *= m;
        this.y *= m;
    }

    public void div(float d) {
        this.x /= d;
        this.y /= d;
    }

    public static Vec2D mult(Vec2D v, float m) {
        return new Vec2D(v.x * m, v.y * m);
    }

    public static Vec2D mult(Vec2D v1, Vec2D v2) {
        return new Vec2D(v1.x * v2.x, v1.y * v2.y);
    }

    public void norm() {
        float l = this.length();
        if (l > 0.0f) {
            this.x /= l;
            this.y /= l;
        }
    }

    public static Vec2D norm(Vec2D v1) {
        float l = Vec2D.length(v1);
        Vec2D v = l > 0.0f ? new Vec2D(v1.x / l, v1.y / l) : Vec2D.nullvec();
        return v;
    }

    public void norm(float m) {
        float l = this.length();
        if (l > 0.0f) {
            this.x /= l;
            this.y /= l;
        }
        this.x *= m;
        this.y *= m;
    }

    public void normMult(float m) {
        float l = this.length();
        if (l > 0.0f) {
            this.x /= l;
            this.y /= l;
        }
        this.x *= m;
        this.y *= m;
    }

    public static Vec2D normMult(Vec2D v1, float m) {
        float l = Vec2D.length(v1);
        Vec2D v = l > 0.0f ? new Vec2D(v1.x / l, v1.y / l) : Vec2D.nullvec();
        v.mult(m);
        return v;
    }

    public float findDistance(Vec2D v) {
        float xd = v.x - this.x;
        float yd = v.y - this.y;
        return (float)Math.sqrt(xd * xd + yd * yd);
    }

    public float findDistance(float _x, float _y) {
        return (float)Math.sqrt((_x -= this.x) * _x + (_y -= this.y) * _y);
    }

    public static float dotProduct(float x1, float y1, float x2, float y2) {
        return x1 * x2 + y1 * y2;
    }

    public static float dotProduct(Vec2D v1, Vec2D v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static float length(Vec2D v1) {
        return (float)Math.sqrt(v1.x * v1.x + v1.y * v1.y);
    }

    public static float length(float x, float y) {
        return (float)Math.sqrt(x * x + y * y);
    }

    public void rotate(float deg) {
        if (deg == 0.0f) {
            return;
        }
        if ((deg %= 360.0f) < 0.0f) {
            deg += 360.0f;
        }
        double cosval = Util.cos(deg);
        double sinval = Util.sin(deg);
        double tmpx = (double)this.x * cosval - (double)this.y * sinval;
        double tmpy = (double)this.x * sinval + (double)this.y * cosval;
        this.x = (float)tmpx;
        this.y = (float)tmpy;
    }

    public static Vec2D rotate(Vec2D v1, float deg) {
        if (deg == 0.0f) {
            return new Vec2D(v1);
        }
        double cosval = Util.cos(deg);
        double sinval = Util.sin(deg);
        return new Vec2D((float)((double)v1.x * cosval - (double)v1.y * sinval), (float)((double)v1.x * sinval + (double)v1.y * cosval));
    }
}

