/*
 * Decompiled with CFR 0.152.
 */
package toxi;

import processing.core.PImage;
import processing.core.PMIDlet;
import toxi.image.TImage;

public class ExpressMIDlet
extends PMIDlet {
    TImage img;
    PImage bg;
    Scribble[] scribbles;
    int framecount = 0;
    int sCount = 0;
    int numScribbles = 2;

    public void setup() {
        this.size(this.canvas.getWidth(), this.canvas.getHeight());
        this.bg = this.loadImage("express_176x208.png");
        this.img = new TImage(this.width, this.height);
        System.out.println("w x h: " + this.width + " x " + this.height);
        this.scribbles = new Scribble[this.numScribbles];
    }

    public void draw() {
        if (this.sCount < this.numScribbles) {
            this.scribbles[this.sCount++] = new Scribble();
        }
        this.canvas.fill(0);
        this.canvas.rect(0, 0, this.width, this.height);
        this.canvas.fill(100);
        this.canvas.stroke(0);
        this.canvas.ellipse(this.width / 2, this.height / 2, 100, 100);
        int i = 0;
        while (i < this.sCount) {
            this.scribbles[i].draw();
            ++i;
        }
        this.canvas.bufferg.drawRGB(this.img.pixels, 0, this.width, 0, 0, this.img.width, this.min(this.height, this.img.height), false);
    }

    public void background(PImage bg) {
        bg.image.getRGB(this.img.pixels, 0, this.img.width, 0, 0, this.min(bg.width, this.width), this.min(bg.height, this.height));
    }

    class Scribble {
        int[] pathx = new int[this.numP];
        int[] pathy = new int[this.numP];
        int[] offx = new int[this.numP];
        int[] offy = new int[this.numP];
        int numP = 24;
        int x;
        int y;
        int dx;
        int dy;
        int theta;
        int thMod;
        int thOrient;
        int radius;
        int baseR;
        int alpha;
        int col;

        Scribble() {
            this.init();
        }

        void init() {
            if (ExpressMIDlet.this.random(100) < 70) {
                this.x = 0;
                this.y = ExpressMIDlet.this.random(ExpressMIDlet.this.height);
                this.dx = ExpressMIDlet.this.random(1, 4);
                this.thOrient = -1;
            } else {
                this.x = ExpressMIDlet.this.width - 1;
                this.y = ExpressMIDlet.this.random(ExpressMIDlet.this.height);
                this.dx = -ExpressMIDlet.this.random(1, 4);
                this.thOrient = 1;
            }
            this.thMod = ExpressMIDlet.this.random(16, 128);
            int i = 0;
            while (i < this.numP - 1) {
                this.pathx[i] = this.x;
                this.pathy[i] = this.y;
                ++i;
            }
            this.y = ExpressMIDlet.this.random(ExpressMIDlet.this.height);
            this.x = ExpressMIDlet.this.random(ExpressMIDlet.this.width >> 2, ExpressMIDlet.this.width - (ExpressMIDlet.this.width >> 2));
            this.alpha = ExpressMIDlet.this.random(32, 160) << 24;
            this.baseR = ExpressMIDlet.this.random(10, ExpressMIDlet.this.width / 4);
            this.col = ExpressMIDlet.this.color(ExpressMIDlet.this.random(50, 255), ExpressMIDlet.this.random(50, 150));
            if (ExpressMIDlet.this.random(100) > 80) {
                this.col = ExpressMIDlet.this.color(ExpressMIDlet.this.random(200, 255), 0, ExpressMIDlet.this.random(100, 150), ExpressMIDlet.this.random(50, 150));
            }
        }

        void draw() {
            int i = 1;
            while (i < this.numP) {
                this.pathx[i - 1] = this.pathx[i];
                this.pathy[i - 1] = this.pathy[i];
                this.offx[i - 1] = this.offx[i];
                this.offy[i - 1] = this.offy[i];
                ++i;
            }
            if (this.x >= 0 && this.x < ExpressMIDlet.this.width) {
                this.radius = this.baseR + ExpressMIDlet.this.random(this.baseR);
                int nx = this.radius * PMIDlet.sin[(this.theta + 90) % 360] >> 8;
                int ny = this.radius * PMIDlet.sin[this.theta % 360] >> 8;
                this.theta = (this.theta + this.thOrient * ExpressMIDlet.this.random(this.thMod >> 1, this.thMod)) % 360;
                if (this.theta < 0) {
                    this.theta += 360;
                }
                this.pathx[this.numP - 1] = this.x + nx;
                this.pathy[this.numP - 1] = this.y + ny;
                this.offx[this.numP - 1] = nx / 32;
                this.offy[this.numP - 1] = ny / 32;
                this.x += this.dx;
            } else {
                this.init();
            }
            ExpressMIDlet.this.canvas.stroke(ExpressMIDlet.this.random(200, 255), ExpressMIDlet.this.random(100, 200), 0);
            ExpressMIDlet.this.beginShape(2);
            i = 0;
            while (i < this.numP) {
                ExpressMIDlet.this.curveVertex(this.pathx[i], this.pathy[i]);
                int n = i;
                this.pathx[n] = this.pathx[n] + this.offx[i];
                int n2 = i;
                this.pathy[n2] = this.pathy[n2] + this.offy[i];
                ++i;
            }
            int px = ExpressMIDlet.this.canvas.vertex[0];
            int py = ExpressMIDlet.this.canvas.vertex[1];
            int i2 = 4;
            while (i2 < ExpressMIDlet.this.canvas.vertexIndex) {
                ExpressMIDlet.this.img.line(px, py, ExpressMIDlet.this.canvas.vertex[i2], ExpressMIDlet.this.canvas.vertex[i2 + 1], this.alpha | this.col);
                px = ExpressMIDlet.this.canvas.vertex[i2];
                py = ExpressMIDlet.this.canvas.vertex[i2 + 1];
                i2 += 4;
            }
        }
    }
}

