/*
 * Decompiled with CFR 0.152.
 */
package toxi;

import processing.core.PImage;
import processing.core.PMIDlet;
import processing.phone.Phone;
import toxi.image.TImage;

public class TestMIDlet
extends PMIDlet {
    TImage img;
    PImage bg;
    Phone p;
    Drop[] drops;
    int numDrops = 4;
    int numRings = 5;
    int dropCount = 0;
    int framecount = 0;

    public void setup() {
        this.size(128, 128);
        this.p = new Phone(this);
        this.bg = this.loadImage("conn_176x208.png");
        this.img = new TImage(this.width, this.height);
        this.img.blendMode(TImage.ADD);
        this.drops = new Drop[this.numDrops];
        this.drops[this.dropCount++] = new Drop(this.width / 2, this.height / 2);
    }

    public void draw() {
        if (this.dropCount < this.numDrops && ++this.framecount % 50 == 0) {
            this.addDrop();
        }
        this.background(this.bg);
        int i = 0;
        while (i < this.dropCount) {
            this.drops[i].draw();
            ++i;
        }
        this.canvas.bufferg.drawRGB(this.img.pixels, 0, this.width, 0, 0, this.img.width, this.min(this.height, this.img.height), false);
    }

    public void addDrop() {
        if (this.dropCount == this.numDrops) {
            int i = 1;
            while (i < this.numDrops) {
                this.drops[i - 1] = this.drops[i];
                ++i;
            }
            this.drops[this.numDrops - 1] = new Drop();
        } else {
            this.drops[this.dropCount++] = new Drop();
        }
    }

    public void background(PImage bg) {
        bg.image.getRGB(this.img.pixels, 0, this.img.width, 0, 0, this.min(bg.width, this.width), this.min(bg.height, this.height));
    }

    public void ellipse(int x, int y, int rx, int ry, int col) {
        int px = x + rx;
        int py = y;
        int res = 15;
        int cx = 0;
        int cy = 0;
        int i = res;
        while (i < 360) {
            cx = x + this.fptoi(rx * PMIDlet.sin[(i + 90) % 360]);
            cy = y + this.fptoi(ry * PMIDlet.sin[i]);
            this.img.line(px += cx > px ? 1 : (cx < px ? -1 : 0), py += cy > py ? 1 : (cy < py ? -1 : 0), cx, cy, col);
            px = cx;
            py = cy;
            i += res;
        }
        this.img.line(px += cx > px ? 1 : (cx < px ? -1 : 0), py += cy > py ? 1 : (cy < py ? -1 : 0), x + rx, y, col);
    }

    class Drop {
        Ripple[] r;
        int x;
        int y;
        int radius;
        int count;
        int speed;

        Drop() {
            this.r = new Ripple[TestMIDlet.this.numRings];
            this.init();
        }

        Drop(int xx, int yy) {
            this.r = new Ripple[TestMIDlet.this.numRings];
            this.init();
            this.x = xx;
            this.y = yy;
        }

        void init() {
            this.x = TestMIDlet.this.random(TestMIDlet.this.width);
            this.y = TestMIDlet.this.random(TestMIDlet.this.height);
            this.count = 0;
            this.speed = TestMIDlet.this.random(24, 48);
        }

        void draw() {
            if (this.count < TestMIDlet.this.numRings) {
                this.addRing();
            }
            boolean isAlive = false;
            int i = 0;
            while (i < this.count) {
                this.r[i].draw();
                if (i > 0) {
                    isAlive |= this.r[i].isAlive;
                }
                ++i;
            }
            if (!isAlive && this.r[0].r >= TestMIDlet.this.max(TestMIDlet.this.width, TestMIDlet.this.height)) {
                this.init();
            }
        }

        private void addRing() {
            this.r[this.count] = new Ripple(this, this.x, this.y, this.speed, this.count);
            this.speed = TestMIDlet.this.max(8, this.speed - TestMIDlet.this.random(4));
            ++this.count;
        }
    }

    class Ripple {
        int theta;
        int speed;
        int x;
        int y;
        int r;
        int scale;
        int baseR;
        boolean isAlive;
        int id;
        Drop parent;

        Ripple(Drop p, int xx, int yy, int s, int idx) {
            this.baseR = TestMIDlet.this.random(35, 50);
            this.isAlive = true;
            this.parent = p;
            this.x = xx;
            this.y = yy;
            this.theta = 804;
            this.speed = s;
            this.id = idx;
            this.scale = 256;
        }

        void draw() {
            if (this.isAlive) {
                this.r = (this.baseR + TestMIDlet.this.fptoi(this.baseR * TestMIDlet.this.cos(this.theta))) * this.scale >> 8;
                if (this.theta < 3216) {
                    this.theta += this.speed;
                } else {
                    this.scale += 8 + (this.parent.r[0].scale - this.scale) / 4;
                    this.r -= this.id;
                }
                this.isAlive = this.id == 0 || this.r < TestMIDlet.this.max(TestMIDlet.this.width, TestMIDlet.this.height);
                TestMIDlet.this.ellipse(this.x, this.y, this.r, this.r, 0x40FFFFFF);
            }
        }
    }
}

