
import javax.microedition.media.MediaException;
import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.*;
import java.io.*;
import java.util.*;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
//import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import org.alablaster.io.FileManager;

public class KaraokeMIDlet extends MIDlet implements CommandListener,Runnable{	//,PlayerListener{
    
    /**
     *     , .
     */
    private String sVersion = getAppProperty("MIDlet-Version");
    
    /**
     *    (   .kar).
     */
    private String song = "";
    
    /**
     *        .
     */
    private double[] times = new double[0];
    
    /**
     *  ,       times.
     */
    private String[] words=new String[0];
    
    /**
     *    ,     times      words
     */
    private long time=0;

    /**
     *    ,    
     */
    private int postext=0;
    
     /**
     *   
     */
    private int posnext=0;
    
    /**
     *    ,     . ,       postext
     */
    private int pos=-1;
    
    /**
     *   ,   /.
     */
    private int vol=50;
    
    /**
     *     .
     */
    public int keyr=0;
    
    /**
     *    .
     */
    public long keyrtime=0;
    
    /**
     *       
     */
    private long dttime=0;
    
    /**
     *   /
     */
    private boolean work=false;
    
    /**
     * ,    ,     
     */
    boolean needpaint=true;
    
    /**
     *  
     */
    boolean light=false;
    
    /**
     *  .
     */
    private int w;
    
    /**
     *  .
     */
    private int h;
    
    /**
     *  .
     */
    private int fh;
    
    /**
     *  .
     */
    private int fhi;
    
    /**
     *     .
     */
    private int xt=0;
    
    Command openC = new Command("Open", 1, 1);
    Command stopC = new Command("Stop", 1, 2);
    Command randomC = new Command("Random", 1, 3);
    Command fontC = new Command("Font Medium", 1, 4);
    Command lightC = new Command("Light off", 1, 5);
    Command helpC = new Command("Help", 1, 6);
    Command exitC = new Command("Exit", 1, 7);
    
    Command okC = new Command("OK", 1, 0);
    Command cancelC = new Command("Cancel", 1, 1);
    
    MyCanvas myCanvas = null;		// 
    TextBox Tb = null; 		// FIX: , :        
    
    /**
     *  ,    .
     */
    public Image Im1 = null;
    
    /**
     *    .
     */
    Graphics G1 = null;
    
    Font F = null, Fi = null;		// ,    (   3 : ,   )
    
    /**
     *  .
     */
    List Flist = null;
    
    public Player aPlayer;
    public VolumeControl aVolumeControl;
    
    static Random rnd=new Random();
    String s="";
    
    /**
     *         Thread,
     *     :      ,
     *     myCanvas.repaint(),
     *    
     */
    public void run(){
        while (true) {							//  
            try {
                Thread.currentThread().setPriority(Thread.MIN_PRIORITY); 	//   
                
                //      
                if (time==-1 && aPlayer.getState()==aPlayer.STARTED) {time=System.currentTimeMillis(); work=true; needpaint=true;}
                
                if (work) {
                    long dt = System.currentTimeMillis()-time;
                    
                    //      
                    if ((keyr==Canvas.DOWN || keyr==Canvas.UP) && dt-keyrtime>300) {
                        if (keyr==Canvas.DOWN) scroll(1); else if (keyr==Canvas.UP) scroll(0);
                        keyrtime=dt;
                    }
                    
                    while (words.length>0 && pos+1<times.length && dt>times[pos+1]) {		//   
                        pos++;
                        if (pos>posnext) postext=posnext;		//  
                        needpaint=true;
                    }
                    
                    // ...
                    if (needpaint) {
                        
                        G1.setClip(0,0,w,h);
                        G1.setColor(255,220,177);						//  
                        G1.fillRect(0,0,w,h-fhi);						//    
                        G1.setFont(F);							//  
                        
                        if (words.length>0) {
                            int x1=0,x2=0;
                            int tpos=postext;
                            int tsel;
                            for (int n=0;n<3;n++) {
                                //          tsel
                                tsel=0;
                                if (words[tpos].charAt(0)=='\\' || words[tpos].charAt(0)=='/') s=words[tpos].substring(1,words[tpos].length()); else s=words[tpos];
                                //s=words[tpos];
                                if (tpos<=pos) tsel=s.length();
                                tpos++;
                                while(tpos<words.length && F.stringWidth(s)+F.stringWidth(words[tpos])<w && words[tpos].charAt(0)!='\\' && words[tpos].charAt(0)!='/') {
                                    s+=words[tpos]; 	// FIX: ,       
                                    if (tpos<=pos) tsel=s.length();
                                    tpos++;
                                }
                                if (n==1) posnext=tpos;	//    , ..  -       
                                // 
                                x1=w/2-F.stringWidth(s)/2;
                                x2=x1+F.substringWidth(s,0,tsel);
                                if (tsel>0) {
                                    G1.setColor(150,150,150);		//   
                                    G1.drawSubstring(s, 0, tsel, x1, h/2-fh+n*fh, 16|4);
                                }
                                if (tsel<s.length()) {
                                    G1.setColor(40,40,40);				//   
                                    G1.drawSubstring(s, tsel, s.length()-tsel, x2, h/2-fh+n*fh, 16|4);//
                                }
                                //   . , .   .  (  ,      n*fh)
                                if (tpos==words.length) break;	//  
                            }
                        } else {G1.setColor(150,150,150);G1.drawString("Karaoke "+sVersion,w/2,h/2,16|1);}
                        
                        
                        //     
                        G1.setColor(0,0,0);
                        G1.setFont(Fi);					//  
                        G1.drawString(song,0,0,16|4);
                        //G1.drawString(" v: "+String.valueOf(vol)+"% temp "+(int)(temp/1000)+" ticks "+timebase+" mul "+(int)mul*1000,0,fhi,16|4);
                        
                        //   ( 2 , ,  5:1)
                        //G1.fillRect(w-fhi*5,0,fhi*5,fhi*2);
                        G1.setColor(100,100,100);
                        for (int i=0;i<vol/10;i++) G1.fillRect(w-fhi*5+fhi*i/2,fhi*2-fhi*2*i/20-fhi/2,fhi/3,fhi*2*i/20+4);
                        if (vol<100) {G1.setColor(210,210,210); for (int i=vol/10;i<11;i++) G1.fillRect(w-fhi*5+fhi*i/2,fhi*2-fhi*2*i/20-fhi/2,fhi/3,fhi*2*i/20+4); }
                        G1.setColor(0,0,0);
                        
                        myCanvas.repaint();					//  ,    , .    
                        needpaint=false;
                    }//if needpaint
                    
                    if (dt-dttime>1000) {				//    
                        dttime=dt;
                        G1.setColor(255,220,177);			//  
                        G1.fillRect(0,h-fhi,w,h);
                        G1.setColor(0,0,0);
                        
//System.out.println("Time: "+aPlayer.getMediaTime()+", max: "+aPlayer.getDuration()+", temp: "+temp);
                        
                        //long ttime=aPlayer.getMediaTime();	// FIX:     ,      .   ,    000, ..  ,   ,   
                        //long mtime=aPlayer.getDuration();
                        
                        if (words.length>0) {
                            //    
                            long ttime=dt;
                            long mtime=(long)times[times.length-1];
                            if (ttime>mtime) ttime=mtime;
                            long perc = (long)ttime*100/mtime;
                            long min=ttime/60000;
                            long sec=(ttime-min*60000)/1000;
                            G1.fillRect(5,h-fhi/2-fhi/8,xt-5,fhi/4);
                            G1.fillRect((int)(5+perc*(xt-10)/100-4),h-fhi/2-fhi/4,8,fhi/2);
                            G1.drawString(" "+min+":"+sec+"/"+(mtime/60000)+":"+((mtime-(mtime/60000)*60000)/1000),xt,h-fhi,16|4);	//String.valueOf(perc)+"%  "
                        }
                        myCanvas.repaint();
                    }
                    
                    
                }
                
                try {Thread.sleep(20);}catch (Exception e){} 	//  20 
                //    (ThreadPriority)  
                Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
            }catch (Exception e){} //System.out.println("error run()"); System.out.println("error run() "+words[postext]+" "+words[postext+1]+" sel: "+words[pos]+" "+words[pos+1]+"\n s = "+s);
        }// while(true)
    }
    
    /**
     *  .
     */
    public void volume(int b) {
        if (b==1) vol+=10; else vol-=10;
        if (vol<0) vol=0;
        if (vol>100) vol=100;
        if (aVolumeControl!=null) aVolumeControl.setLevel(vol);
        needpaint=true;
    }
    
    public void scroll(int b) {		//   !
        if (times==null) return;
        try{
            long mTime = aPlayer.getMediaTime();
            // default
            long jump = 500000;
            long duration = aPlayer.getDuration();
            if (duration>0) {		//     
                if (b==0) {	// 
                    jump*=5;
                    aPlayer.setMediaTime(mTime-jump);
                    postext=0;
                    posnext=0;
                    pos=0;
                    dttime=-2000;
                } else {
                    // 
                    aPlayer.setMediaTime(mTime+jump);
                }
                time=System.currentTimeMillis()-aPlayer.getMediaTime()/1000;
            }//if
        }catch (Exception e){}//System.out.println("err 1 ");
        needpaint=true;
    }
    
    int vldt,vlc,vlt,tsize=0;
    public int readvarlen(InputStream inp) {	//       , .    
        vlt=0;
        tsize++;
        try{
            if (((vldt  = inp.read()) & 0x80)!=0){
                vldt &= 0x7F;
                do {
                    vldt = (vldt << 7) + ((vlc = inp.read()) & 0x7F);
                    tsize++;
                    vlt++;
                }while ((vlc & 0x80)!=0 && vlt<10);	//      
                if (vlt>5) System.out.println("error: vlt = "+vlt);
            }
        }catch(Exception e) {}
        return vldt;
    }
    
    
    public String dechex(int b) {
        String st="";
        char[] ch= {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
        int h=b>>4;
        st+=ch[h];
        h=b & 0x0F;
        st+=ch[h];
        return st;
    }
    
    public void load(String file){		//   file      
        try {
            
            //  
            work=false;
            words=new String[0];
            times=new double[0];
            dttime=-2000;
            time=0;
            if (file.equals("?")) {
                file = fileMan.getRandomFileName();
            }
            try{
                if (aPlayer!=null) {
                    aPlayer.stop();
                    aPlayer.close();
                    inp.close();
                }
            } catch (Exception e){}
            myCanvas.removeCommand(stopC);
            song = " "+file.substring(file.lastIndexOf('/')+1,file.length());
            System.gc();
            inp = fileMan.getByteArrayInputStream(file);
            
            int b=0,i,c=0,len;
            double delta=0;
            StringBuffer sb = new StringBuffer();
            double[] ttimes;
            String[] twords;
            int[] lentr = new int[32];	//     words,      
            int ntr = -1;			//. 
            int size,last=0,high,dt;
            
            //   , MIDI    0  1  , ..       
            if ((char)inp.read()!='M' || (char)inp.read()!='T' || (char)inp.read()!='h' || (char)inp.read()!='d' || inp.read()>999 || inp.read()>999 || inp.read()>999 || inp.read()>999 || inp.read()>999 || inp.read()>2) {showerror("   "+file);return;}
            int count= inp.read()*256 + inp.read();	//  
            int timebase = inp.read()*256 + inp.read();	//     ,       ,           timebase  .      ,   ,    120   
            
            long delt=0;
            int[] tempo = new int[2]; tempo[1]=500000;
            int[] tmp;
            int ntempo=0;
            int pred=0;
            
            //      ( MTrk,  delta,  Meta TrkName "Words",    Meta Text,    Meta TrkEnd
            try{
                for (int ii=0;ii<count;ii++) {		//   
                    ntr++;
                    lentr[ntr]=words.length;		//    . 
                    delta=0;
                    delt=0;
                    ntempo=2;
                    pred=0;
                    
//System.out.print("\nnew trk: ");
                    for(i=0;i<4;i++) b=inp.read();	//  : MTrk, size (4 )
                    
                    tsize=0;
                    size=inp.read()*256*256*256 + inp.read()*256*256+inp.read()*256 + inp.read();
                    while(tsize<size) {				//      : varlen, event
                        
                        // -  ,     
                        dt=readvarlen(inp);
                        delt+=dt;
                        
                        //                
                        while (ntempo<tempo.length && delt>tempo[ntempo]) {		//    ,    
//if (istext) System.out.println("delta "+delt+">="+tempo[ntempo]+" calc "+tempo[ntempo]+"-"+pred+" on temp "+tempo[ntempo-1]);
                            delta+=(tempo[ntempo]-pred)*(tempo[ntempo-1]/timebase)/1000;
                            pred=tempo[ntempo];
                            ntempo+=2;
                        }
//if (istext) System.out.println("delta "+delt+", calc "+delt+"-"+pred+" on temp "+tempo[ntempo-1]);
                        delta+=(delt-pred)*(tempo[ntempo-1]/timebase)/1000;	// .  
                        pred=(int)delt;
                        
                        
                        //        (, meta  SysEx)
                        b=inp.read();
                        tsize++;
                        if (b==-1) break;					//   (  ,   )
                        
                        high = b >> 4;
                        switch(high){
                            case 0x0C:
                            case 0x0D:
                                c=inp.read();tsize++;
                                last = high;
                                break;
                            case 0x08:
                            case 0x09:
                            case 0x0A:
                            case 0x0B:
                            case 0x0E:
                                inp.read();inp.read();tsize+=2;
                                last = high;
                                break;
                            default:
                                switch(b){
                                    case 0xFF:
                                        c = inp.read();
                                        tsize++;
                                        if (c==0x51) {				//  SetTempo,         (   )
                                            inp.read();
                                            int ttemp = inp.read()*256*256 + inp.read()*256 + inp.read();
                                            if(ii==0) {				//      
                                                tmp = tempo;
                                                tempo = new int[tmp.length+2];
                                                System.arraycopy(tmp,0,tempo,0,tmp.length);
                                                tempo[tmp.length]=(int)delt;
                                                tempo[tmp.length+1]=ttemp;
//System.out.println("delta "+delt+", new tempo "+tempo[tmp.length+1]);
                                                tmp=null;
                                                ntempo+=2;
                                            }
                                            tsize+=4;
                                            break;
                                        }
                                        len=readvarlen(inp);
                                        tsize+=len;
                                        sb = new StringBuffer();
                                        for(i=0;i<len;i++) {sb.append(decode(inp.read()));}	//FIX: ,    \r   13
                                        
                                        if ((c==0x01 || c==0x05) && sb.length()>0) {		// text || lyrics,       (     )
                                            ttimes=times;
                                            times = new double[ttimes.length+1];
                                            System.arraycopy(ttimes,0,times,0,ttimes.length);
                                            times[ttimes.length]=delta;
                                            ttimes=null;
                                            
                                            twords=words;
                                            words= new String[twords.length+1];
                                            System.arraycopy(twords,0,words,0,twords.length);
                                            words[twords.length]=sb.toString();
                                            twords=null;
                                        }
                                        break;
                                        
                                    case 0xF0:
                                    case 0xF7:
                                        len=readvarlen(inp);
                                        tsize+=len;
                                        for(i=0;i<len;i++) inp.read();	// 
                                        break;
                                        
                                    default:	//     ,     ( )
                                        switch(last){
                                            case 0x0C:
                                            case 0x0D:
                                                break;
                                            default:
                                                inp.read();tsize++;
                                                break;
                                        }//switch(last)
                                }//switch (b)
                        }//switch (high)
                    }//while(true)
                }//for tracks
                
                //        
                int max=0;
                ntr++;
                lentr[ntr]=words.length;	// -   
                ntr=0;
                for (i=0;i<lentr.length-1;i++) if (lentr[i+1]-lentr[i]>max) {max=lentr[i+1]-lentr[i];ntr=i;}
                if (max>0) {
                    ttimes=times;
                    times = new double[max];
                    System.arraycopy(ttimes,lentr[ntr],times,0,max);
                    ttimes=null;
                    
                    twords=words;
                    words= new String[max];
                    System.arraycopy(twords,lentr[ntr],words,0,max);
                    twords=null;
                }//max>0
                
            }catch(Exception e) {}
            System.gc();
            
//for(i=0;i<words.length;i++) System.out.println((int)times[i]+": "+words[i]);
//System.out.println("len times "+times.length+" len words "+words.length);
            
            //  
            try {
                inp.reset();
                aPlayer = Manager.createPlayer(inp,"audio/midi");
                
                aPlayer.realize();	// ,   start()     
                aPlayer.prefetch();
                
                //  realize()
                aVolumeControl = (VolumeControl)aPlayer.getControl("VolumeControl");
                aVolumeControl.setLevel(vol);
                
                //  
                pos=-1;
                postext=0;
                posnext=0;
                
                stopC= new Command("Stop", 1, 2);
                myCanvas.addCommand(stopC);
                aPlayer.start();
                
                time=-1;	//      run()
                
                if(words.length==0) showerror("  "+file+"   Words   ,     "); else Display.getDisplay(this).setCurrent(myCanvas);
                
            } catch (Exception e) {
                e.printStackTrace();
                showerror("   ");}
            
        } catch (IllegalArgumentException iex) {
            showerror(": " + iex.toString());
        }catch(Exception e) {
            e.printStackTrace();
            showerror("   "+file);
        }
        
    }
    
    char decode(int b) {						// windows-1251 -> Unicode
        //  windows-1251
        if (b==-1) return ' '; else			//  
            if (b==10) return '\n'; else		//  
                if (b>31 && b<127) return (char)b; else	//  
                    if (b==168) return ''; else		//    
                        if (b==184) return ''; else
                            if (b>191) return (char)(b-192+0x0410); else //    Unicode   0x0410
                                return ' ';
    }
    
    public void showerror(String txt) {
        Alert alert = new Alert("Error",txt, null, AlertType.ERROR);
        alert.setTimeout(Alert.FOREVER);
        Display.getDisplay(this).setCurrent(alert,myCanvas);
    }
    
    public void commandAction(Command c, Displayable d) {
        //  
        String item = (Flist != null) ? Flist.getString(Flist.getSelectedIndex()) : "";
        
        if (c == exitC) {					//   
            destroyApp(false);
        }
        if (c == openC) {					//       . 
            list("");
        }
        if (c == helpC) {					//          
            Alert alert = new Alert(""," "+sVersion+" \r\nhttp://karaoke-mobile.by.ru\r\n() Blade, blade17@rambler.ru \r\n/ -  \r\n/ - / (  ) \r\nRandom -      \r\n  - Alablaster, alablaster@yandex.", null, AlertType.INFO);
            alert.setTimeout(Alert.FOREVER);
            Display.getDisplay(this).setCurrent(alert);
        }
        if (c == randomC) {					//     
            load("?");
            //Tb.setString(String.valueOf((int)mul));
            //Display.getDisplay(this).setCurrent(Tb);
        }
        if (c == List.SELECT_COMMAND && d == Flist) {		//   
            if (item.endsWith("/") || item.equals("...") || item.endsWith(".zip")) {
                list(item);
            } else {
                load(item);		//   
            }
        }
        if (c == okC) {					// OK
            //mul=Integer.parseInt(Tb.getString());
            list("");
        }
        if (c == stopC) {					// stop
            try{
                myCanvas.removeCommand(stopC);
                aPlayer.stop();
            }catch(Exception e) {}
            words = new String[0];
            times = new double[0];
        }
        if (c == lightC) {					// 
            if (light) {
                light=false;
                Display.getDisplay(this).flashBacklight(0);
                myCanvas.removeCommand(lightC);
                lightC = new Command("Light Off", 1, 5);
                myCanvas.addCommand(lightC);
            } else {
                light=true;
                Display.getDisplay(this).flashBacklight(0x00FFFFFF);
                myCanvas.removeCommand(lightC);
                lightC= new Command("Light On", 1, 5);
                myCanvas.addCommand(lightC);
            }
        }
        if (c==fontC) {
            //   
            int fsize=F.getSize();
            if (fsize==Font.SIZE_SMALL) fsize=Font.SIZE_MEDIUM; else if(fsize==Font.SIZE_MEDIUM) fsize=Font.SIZE_LARGE; else fsize=Font.SIZE_SMALL;
            F = Font.getFont(Font.FACE_PROPORTIONAL,Font.STYLE_BOLD,fsize);
            fh = F.getHeight();
            G1.setFont(F);
            myCanvas.removeCommand(fontC);
            if (fsize==Font.SIZE_SMALL) fontC= new Command("Font Small", 1, 4);
            else if (fsize==Font.SIZE_MEDIUM) fontC= new Command("Font Medium", 1, 4);
            else if (fsize==Font.SIZE_LARGE) fontC= new Command("Font Large", 1, 4);
            myCanvas.addCommand(fontC);
            needpaint=true;
        }
        if (c == cancelC) {					//  
            Display.getDisplay(this).setCurrent(myCanvas);
        }
        
    }
    
    protected void startApp() {
        
        Thread th = new Thread(this);
        th.start();	// ..     this,     KaraokeMIDlet  Runnable,       KaraokeMIDlet.run()
        list("");	//    
    }
    
    protected void pauseApp() {
    }
    
    protected void destroyApp(boolean unconditional) {
        try {
            fileMan.closeZipArchive();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        fileMan = null;
        if (aPlayer != null) {
            try {
                aPlayer.stop();
            } catch (MediaException ex) {
                ex.printStackTrace();
            }
            aPlayer.close();
        }
        aPlayer = null;
        notifyDestroyed();
    }
    public static int getRandom(int n){	//      0-n
        int number = rnd.nextInt();
        if(number<0) number*=-1;
        int t1 = number/n;
        return(int)(number-(t1*n));
    }
    
    
    public KaraokeMIDlet() {				//  ,  
        
        myCanvas=new MyCanvas(this);		//   ...
        myCanvas.addCommand(openC);
        myCanvas.addCommand(randomC);
        myCanvas.addCommand(fontC);
        myCanvas.addCommand(lightC);
        myCanvas.addCommand(helpC);
        myCanvas.addCommand(exitC);
        myCanvas.setCommandListener(this);	//  ,      
        
        //Tb = new TextBox("","",32,2);		// 0-ANY, 2-NUMERIC
        //Tb.addCommand (okC);
        //Tb.addCommand (cancelC);
        //Tb.setCommandListener(this);
        
        
        w = myCanvas.getWidth();			//      ( )
        h = myCanvas.getHeight();
        
        Im1 = Image.createImage(w,h);		//    -  
        G1=Im1.getGraphics();
        F = Font.getFont(Font.FACE_PROPORTIONAL,Font.STYLE_BOLD,Font.SIZE_MEDIUM);
        Fi = Font.getFont(Font.FACE_PROPORTIONAL,0,Font.SIZE_SMALL);
        fh = F.getHeight();
        fhi = Fi.getHeight();
        xt=Fi.stringWidth(" 9:99 / 9:99");
        xt = w-xt;
        
        //Display.getDisplay(this).setCurrent(myCanvas);	//    
    }
    
    public void redraw(Graphics g) {
        //Display.getDisplay(this).callSerially(this);				// FIX:   ,     run()        run(),    
        g.drawImage(Im1,0,0,16|0);			//     ,   ...
    }
    private void list(String path) {
        try {
            fileMan.openSubDirectory(path);
            if (Flist == null) {
                Flist = new List("Karaoke",List.IMPLICIT);
                Flist.addCommand(helpC);
                Flist.addCommand(randomC);
                Flist.addCommand(exitC);
                Flist.setCommandListener(this);
            }
            rebuildList();
        } catch (IOException ex) {
            ex.printStackTrace();
            showerror(ex.toString());
        } catch (SecurityException sex) {
            showerror("    "+path+"\n  ");
        } catch (RuntimeException rex) {
            rex.printStackTrace();
            showerror("     !/n( ZipME)");
            try {
                fileMan.closeZipArchive();
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
    
    private void rebuildList() {
        Flist.deleteAll();
        for (int i = 0;i < fileMan.getListLength();i++) Flist.append(fileMan.getFileName(i),null);
        Display.getDisplay(this).setCurrent(Flist);
        
    }
    private FileManager fileMan = new FileManager(new String[]{"kar"});
    private ByteArrayInputStream inp;
    
}//midlet class
