/*
 * FileManager.java
 *
 * Created on 16  2015 ., 21:12
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.alablaster.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import net.sf.zipme.ZipArchive;
import net.sf.zipme.ZipEntry;

/**
 *
 * @author Alablaster
 */
public class FileManager {
    
    /**
     *  FileManager       .
     * @param types    ,   .
     */
    public FileManager(String[] types) {
        supportedTypes = types;
    }
    /**
     *  
     */
    public FileManager() {
        
    }

    /**
     *      
     */
    private Vector filesVector = new Vector();
    
    /**
     *   ZIP-
     */
    private ZipArchive zipArc;
    
    /**
     *      .
     */
    private FileConnection fileConn;
    
    /**
     *     ZIP-.
     */
    private InputStream zipInput;
    
    /**
     *   .
     */
    private final String PREFIX = "file:///";
    
    /**
     *   , r      .
     *      .
     */
    private String[] supportedTypes;
    
    /**
     *       .
     */
    private String currentDir = "";
    
    /**
     *    zip-.
     */
    private String zipDir = "";
    
    /**
     *  "  ".
     */
    private String backStr = "...";
    
    /**
     *   <I>java.util.Random</I>,       
     * (    -   )
     */
    private Random rand = new Random();
    
    /**
     *        .
     */
    private void refreshList() throws IOException, SecurityException, RuntimeException {
        Enumeration en = null;
        filesVector.removeAllElements(); //   
        if (!isZip(currentDir)) { //  ZIP  
            if (currentDir.equals("")) //    ..
                en = FileSystemRegistry.listRoots(); //    
            else { //  (    )
                fileConn = (FileConnection)Connector.open(PREFIX + currentDir,Connector.READ); //  
                en = fileConn.list(); //     
                fileConn.close(); //  
            }
            sortFiles(en); //  
        } else { //   ZIP -    
            sortZipArchiveFiles(zipArc.entries());
        }
        
    }
    /**
     *      .
     * @param en  <I>java.util.Enumerartiion</I>   
     */
    private void sortFiles(Enumeration en) {
        int insindex = 0; //       Vector
        // 0 -    , 1 -   
        if (!currentDir.equals("")) {
            insindex = 1;
            filesVector.addElement(backStr); //    
            //     -   
        }
        while (en.hasMoreElements()) { //       Enumeration
            String file = en.nextElement().toString(); //     / 
            //     ,      
            if (file.endsWith("/")) {
                filesVector.insertElementAt(file,insindex);
            } else if (isSupportedFile(file) || isZip(file))
                //        ZIP-
                filesVector.addElement(file);
        }
    }
    /**
     *     ZIP-.
     * @param en  <I>java.util.Enumerartiion</I>   
     */
    private void sortZipArchiveFiles(Enumeration en) {
        filesVector.addElement(backStr); //      
        int len = zipDir.length(); //     ZIP-
        
        while (en.hasMoreElements()) { //       Enumeration
            String file = en.nextElement().toString(); //  
            if (file.startsWith(zipDir)) { //   -     
                int firstslash = (file.indexOf("/",len) != -1) ? file.indexOf("/",len) : file.length();
                if ((getNumLevels(zipDir) == getNumLevels(file)) && isSupportedFile(file)) { // 
                    filesVector.addElement(file.substring(len,firstslash));
                }
                if ((getNumLevels(zipDir) + 1 == getNumLevels(file)) && file.endsWith("/")) { // 
                    filesVector.insertElementAt(file.substring(len,file.length()),1);
                }
            }
        }
    }

    /**
     * ,   - ZIP-.
     */
    public boolean isArchiveOpened() {
        if (zipDir.equals("")) return false;
        return true;
    }
    /**
     *    <I>/</I>  .
     * @return    ""  .
     */
    private int getNumLevels(String file) {
        int levls = 0;
        int index =file.indexOf('/');
        while (index != -1) {
            index = file.indexOf('/', index + 1);
            levls++;
        }
        return levls;
    }
    /**
     *     .
     */
    private boolean isSupportedFile(String file) {
        if (!file.endsWith("/") && this.supportedTypes == null && !isZip(file)) return true;
        for (int i = 0; i < supportedTypes.length;i++) if (file.endsWith(supportedTypes[i])) return true;
        return false;
    }
    /**
     *     .   <I>path</I>   .
     * @param path  ,   .
     */
    public void openSubDirectory(String path) throws IOException, SecurityException, RuntimeException {
        if (!path.equals("")){ //     -    
            //       -  
            if (!path.endsWith("/") && !path.equals(backStr) && !isZip(path)) return;
            if (!isZip(currentDir)) { //    zip-
                if (path.equals(backStr)) toUpperDirectory(false); //    
                else currentDir += path; //  
                if (isZip(path)) openZipArchive(); //    zip'
            } else { // zip 
                if (path.equals(backStr)) { //      
                    if (zipDir.length() != 0) toUpperDirectory(true);
                    else closeZipArchive();
                } else zipDir += path; //    ZIP'
            }
        }
        refreshList(); //  
    }
    /**
     *      .
     * @param zip <CODE>true</CODE>       ZIP'.
     */
    private void toUpperDirectory(boolean zip) {
        String dir = zip ? zipDir : currentDir;
        System.out.println("dir before: "+dir);
        dir = dir.substring(0,dir.lastIndexOf('/',dir.length()-2)+1);
        System.out.println("dir after: "+dir);
        if (zip) zipDir = dir;
        else currentDir = dir;
    }
    /**
     *    ZIP-.
     */
    private void openZipArchive() throws IOException {
        fileConn = (FileConnection)Connector.open(PREFIX + currentDir,Connector.READ);
        zipInput = fileConn.openInputStream();
        zipArc = new ZipArchive(zipInput);
    }
    /**
     *    ZIP-.
     */
    public void closeZipArchive() throws IOException {
        zipArc = null;
        if (zipInput != null) zipInput.close();
        zipInput = null;
        if (fileConn != null) fileConn.close();
        fileConn = null;
        zipDir = "";
        toUpperDirectory(false);
        System.gc();
    }
    /**
     *      .
     * @return         .
     */
    public String[] getFilesListAsArray() {
        String[] result = new String[filesVector.capacity()];
        for (int i =0; i < filesVector.capacity(); i++) result[i] = filesVector.elementAt(i).toString();
        return result;
    }
    
    /**
     *      .
     * @return Vector        .
     */
    public Vector getFilesListAsVector() {
        return filesVector;
    }
    /**
     *    <I>name</I> ZIP-.
     * @param name   .
     */
    private boolean isZip(String name) {
        if (name.toLowerCase().endsWith(".zip")) return true;
        return false;
    }
    /**
     *  ByteArrayInputStream (  )     <CODE>file</CODE>   .
     */
    public ByteArrayInputStream getByteArrayInputStream(String file) throws IOException {
        if (file.endsWith("/") || file.equals(backStr)) return null;
        ByteArrayInputStream bais = null;
        byte[] buffer = null;
        if (!isZip(currentDir)) {
            FileConnection fc = (FileConnection)Connector.open(PREFIX + currentDir + file);
            if (!fc.exists()) {
                fc.close();
                return null;
            }
            buffer = new byte[(int)fc.fileSize()];
            InputStream is = fc.openInputStream();
            is.read(buffer);
            is.close();
            fc.close();
        }
        else {
            ZipEntry ze = zipArc.getEntry(zipDir + file);
            InputStream is = zipArc.getInputStream(ze);
            buffer = new byte[(int)ze.getSize()];
            //write(buffer);
            //for (int j = 0;j < buffer.length; j++) buffer[j] = (byte)is.read();
            int br;
            int ind = 0;
            int limit = buffer.length;
            while ((br = is.read(buffer,ind,limit)) != 0){
                ind += br;
                limit -= br;
            }
            is.close();
            is = null;
            ze = null;
        }
        bais = new ByteArrayInputStream(buffer);
        buffer = null;
        System.gc();
        return bais;
    }
    /**
     *         .
     */
    public int getListLength() {
        return filesVector.size();
    }
    public String getFileName(int index) {
        //if ((index < 0) || (index > filesVector.capacity())) return "";
        String result = filesVector.elementAt(index).toString();
        return result;
    }
    /**
     *    
     * (ZIP-    ).
     */
    private boolean hasSupportedFiles() {
        if (this.supportedTypes == null) return true;
        for (int i = 0; i < filesVector.size(); i++) if (isSupportedFile(filesVector.elementAt(i).toString())) return true;
        return false;
    }
    /**
     *       
     * (ZIP-    ).
     * @throws java.lang.IllegalArgumentException      .
     */
    public String getRandomFileName() throws IllegalArgumentException{
        String result = "";
        if (hasSupportedFiles()) {
            do {
                result = filesVector.elementAt(rand.nextInt(filesVector.size())).toString();
            }
            while (!isSupportedFile(result));
        }
        else throw new IllegalArgumentException("    !");
        return result;
    }
    
}
