/*
 * Decompiled with CFR 0.152.
 */
public class ComputerWorm
extends Worm {
    private final int COMPUTER_STATE_STAND_ATTACK;
    private final int COMPUTER_STATE_WALK_ATTACK;
    private final int COMPUTER_STATE_FLEE_ATTACK;
    private final int COMPUTER_STATE_SELECT_ANGLE;
    private final int COMPUTER_STATE_AIM;
    private final int COMPUTER_STATE_FIRE;
    private int computerState = -1;
    private int computerTargetAngle;
    private int computerTargetVelocity;
    private long computerPauseTime;
    private int nearestEnemyDirection;
    private int nearestEnemy;
    private int walkLength;
    private int prevWalkDir;

    public ComputerWorm(boolean bl, int n, boolean bl2) {
        super(bl, n, bl2);
        this.COMPUTER_STATE_STAND_ATTACK = 0;
        this.COMPUTER_STATE_WALK_ATTACK = 1;
        this.COMPUTER_STATE_FLEE_ATTACK = 3;
        this.COMPUTER_STATE_SELECT_ANGLE = 4;
        this.COMPUTER_STATE_AIM = 5;
        this.COMPUTER_STATE_FIRE = 6;
        this.pointerVisible = false;
    }

    private void calcComputerAngle() {
        this.calcNearestEnemy();
        this.computerTargetAngle = this.nearestEnemyDirection == 0 ? 120 + Math.abs(this.random.nextInt()) % 40 - 20 : 60 + Math.abs(this.random.nextInt()) % 40 - 20;
    }

    protected void endTurn() {
        super.endTurn();
        this.computerState = -1;
        this.setIdle();
    }

    private void calcComputerVelocity() {
        int n = 0;
        n = 128;
        int n2 = Integer.MAX_VALUE;
        int n3 = 22;
        while (n3 < 100) {
            int n4 = WeaponIterator.iterate(this.positionX, this.positionY, Game.windFactor, n3 * n >> 8, this.computerTargetAngle, this.game.teams[this.myTeamNo ^ 1]);
            if (n4 < n2) {
                n2 = n4;
                this.computerTargetVelocity = n3;
            }
            ++n3;
        }
    }

    public void calcNearestEnemy() {
        this.nearestEnemy = 200000;
        int n = 0;
        while (n < this.game.teams[this.myTeamNo ^ 1].wormList.length) {
            int n2 = this.game.teams[this.myTeamNo ^ 1].wormList[n].positionX - this.positionX;
            if (Math.abs(n2) < this.nearestEnemy) {
                this.nearestEnemyDirection = n2 < 0 ? 0 : 1;
                this.nearestEnemy = Math.abs(n2);
            }
            ++n;
        }
    }

    private boolean friendlyWormTooClose() {
        int n;
        return !this.game.teams[this.myTeamNo].wormList[0].isDead() && !this.game.teams[this.myTeamNo].wormList[1].isDead() && Math.abs(n = this.game.teams[this.myTeamNo].wormList[0].positionX - this.game.teams[this.myTeamNo].wormList[1].positionX) < 25;
    }

    public void reset(Game game, Landscape landscape, int n, int[] nArray) {
        super.reset(game, landscape, n);
        this.computerState = -1;
    }

    public void activate() {
        super.activate();
        this.adjustCrosshair = false;
        this.computerPauseTime = Worms.getTime();
        int n = Math.abs(this.random.nextInt()) % 3;
        this.calcNearestEnemy();
        this.walkLength = Math.abs(this.random.nextInt()) % 30 + 10;
        if (this.health > 30) {
            if (Math.abs(this.random.nextInt()) % 100 < 85) {
                this.computerState = 0;
                this.calcComputerAngle();
            } else {
                this.computerState = 1;
            }
        } else {
            this.computerState = 3;
        }
        if (Math.abs(this.random.nextInt()) % 8 == 0) {
            this.computerState = 3;
        } else if (Math.abs(this.random.nextInt()) % 8 == 0) {
            this.computerState = 1;
        }
        if (this.friendlyWormTooClose()) {
            this.computerState = Math.abs(this.random.nextInt()) % 4 == 0 ? 1 : 3;
        }
    }

    private void aim() {
        this.computerState = 5;
        this.calcComputerAngle();
    }

    public boolean runFrame() {
        if (super.runFrame()) {
            if (this.falling) {
                return true;
            }
            if (Worms.getTime() - this.computerPauseTime > 2000L) {
                this.turnKeyPressed = true;
                this.pointerActive = false;
                if (this.computerState == 0) {
                    this.aim();
                } else if (this.computerState == 1) {
                    --this.walkLength;
                    int n = this.state == 3 ? 15 : -15;
                    if (this.walkLength <= 0 || this.wormObstructed || this.landscape.getLandHeight(this.positionX + n) < 5) {
                        if (!this.friendlyWormTooClose()) {
                            this.aim();
                        } else {
                            this.computerState = 3;
                        }
                    }
                    this.state = this.nearestEnemyDirection == 0 ? 2 : 3;
                    this.prevWalkDir = this.state;
                } else if (this.computerState == 3) {
                    --this.walkLength;
                    int n = this.state == 3 ? 15 : -15;
                    if (this.walkLength <= 0 || this.wormObstructed || this.landscape.getLandHeight(this.positionX + n) < 5) {
                        this.walkLength = 0;
                        this.aim();
                    }
                    this.state = this.nearestEnemyDirection == 0 ? 3 : 2;
                    this.prevWalkDir = this.state;
                } else if (this.computerState == 5) {
                    if (Math.abs(this.angle - this.computerTargetAngle) < 4) {
                        this.adjustCrosshair = false;
                        this.computerState = 6;
                    } else if (this.angle < this.computerTargetAngle) {
                        this.adjustCrosshair = true;
                        this.state = 4;
                    } else {
                        this.adjustCrosshair = true;
                        this.state = 5;
                    }
                } else if (this.computerState == 6) {
                    if (this.fireVelocityTime == -1L) {
                        this.calcComputerVelocity();
                        this.fireVelocityTime = Worms.getTime();
                        this.state = 6;
                    }
                    if (this.state == 6 && this.calcVelocity() >= this.computerTargetVelocity) {
                        this.fire();
                        if (this.activeWeapon != 4) {
                            this.state = this.direction == 0 ? 0 : 1;
                        } else {
                            this.walkLength = 60;
                            this.computerState = 3;
                        }
                    }
                }
            }
        }
        return true;
    }

    public void keyReleased(int n) {
    }

    public void keyPressed(int n) {
    }
}

