/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

public class Weapon {
    public static boolean wormHit = false;
    public static final int WEAPON_NONE = -1;
    public static final int WEAPON_ROCKET = 0;
    public static final int WEAPON_MORTAR = 1;
    public static final int WEAPON_CLUSTER = 2;
    public static final int WEAPON_GRENADE = 3;
    public static final int WEAPON_DYNAMITE = 4;
    private static final int WEAPON_CLUSTLETS = 5;
    private static final int gravity = -2501;
    private static final int STATE_IDLE = 0;
    private static final int STATE_IN_AIR = 1;
    private static final int STATE_ON_GROUND = 2;
    private static int state;
    private static int collisionX;
    private static int collisionY;
    private static int positionX;
    private static int positionY;
    private static int oldPositionX;
    private static int oldPositionY;
    public static Imp rocket;
    public static Imp grenade;
    public static Imp mortar;
    public static Imp cluster;
    public static Imp clustlet;
    public static Imp dynamite;
    private static final int SMOKE_SIZE = 10;
    private static Landscape landscape;
    private static int initialX;
    private static int initialY;
    private static int time;
    private static int deltaTime;
    private static int[] sinAng;
    private static int[] cosAng;
    private static int[] sinAngleI;
    private static int[] cosAngleI;
    private static int[] gravityI;
    private static int[] gravityAdd;
    private static long launchTime;
    private static int blowUpTime;
    private static int activeWeapon;
    private static Game game;
    private static Random random;
    private static int[] clustletX;
    private static int[] clustletY;
    private static int[] clustletStartFrame;
    private static boolean[] clustletExploded;
    private static int curExplosion;
    private static int[] explosionX;
    private static int[] explosionY;
    private static long[] explosionStartTime;
    public static Imp explosion1;
    public static Imp curExplosionSpr;
    private static int velocity;
    private static int angle;
    private static int vectorX;
    private static int vectorY;
    private static int ox;
    private static int oy;
    private static int vx;
    private static int vy;
    private static int desiredRotFrame;
    private static int curWind;
    private static int windFactor;
    private static int[] smokeTrailX;
    private static int[] smokeTrailY;
    private static int[] smokeTrailSize;
    private static int curTrail;
    private static int weaponIterationCount;
    private static Worm parentWorm;
    public static Image WeaponIcons;
    private static int deviceTimerDivide;
    private static boolean[] explodeTerrain;
    private static int[] explosionFrame;
    private static int ppe_x;
    private static int ppe_y;
    private static int ppe_w;
    private static int ppe_h;
    private static final int explosionFrameCount = 70;
    private static int explosionHeight;
    private static boolean[] doneQuartile1;
    private static boolean[] doneQuartile2;
    private static boolean[] doneQuartile3;
    private static boolean[] doneQuartile4;

    public static void init() {
        curExplosionSpr = explosion1;
        int n = 0;
        while (n < explosionStartTime.length) {
            Weapon.explosionStartTime[n] = -1L;
            ++n;
        }
    }

    public static void fire(Game game, Landscape landscape, Worm worm, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        parentWorm = worm;
        windFactor = n4;
        Weapon.game = game;
        activeWeapon = n;
        if (n5 < 22) {
            n5 = 22;
        }
        if (n == 0 || n == 1 || n == 3 || n == 2) {
            state = 1;
        }
        if (n == 4) {
            state = 2;
        }
        Weapon.landscape = landscape;
        weaponIterationCount = 0;
        vectorX = initialX = n2;
        oldPositionX = initialX;
        positionX = initialX;
        vectorY = initialY = n3;
        oldPositionY = initialY;
        positionY = initialY;
        curWind = 0;
        velocity = n5;
        angle = n6;
        rocket.setFrame((angle + 270) % 360 / 20);
        mortar.setFrame(rocket.getFrame());
        if (bl) {
            launchTime = Worms.getTime();
        }
        curExplosion = 0;
        int n7 = 0;
        while (n7 < explosionStartTime.length) {
            Weapon.explosionStartTime[n7] = -1L;
            ++n7;
        }
        int n8 = 0;
        while (n8 < clustletExploded.length) {
            Weapon.clustletExploded[n8] = false;
            ++n8;
        }
        int n9 = 0;
        while (n9 < clustletStartFrame.length) {
            Weapon.clustletStartFrame[n9] = Math.abs(random.nextInt()) % 3;
            ++n9;
        }
        deltaTime = 30;
        Weapon.sinAng[0] = Game.table[angle % 360] * velocity;
        Weapon.cosAng[0] = Game.table[(angle + 90) % 360] * velocity;
        time = 60;
        sinAng[0] = sinAng[0] * deltaTime;
        cosAng[0] = cosAng[0] * deltaTime;
        Weapon.sinAngleI[0] = 0;
        Weapon.cosAngleI[0] = 0;
        Weapon.gravityAdd[0] = -2501 * deltaTime;
        Weapon.gravityI[0] = 0;
        explosion1.setVisible(false);
        int n10 = 0;
        while (n10 < smokeTrailX.length) {
            Weapon.smokeTrailX[n10] = -1;
            Weapon.smokeTrailY[n10] = -1;
            ++n10;
        }
        curTrail = 0;
    }

    private static void explode(int n, int n2, int n3) {
        if (explosionStartTime[curExplosion %= 3] != -1L) {
            return;
        }
        curExplosionSpr = explosion1;
        Weapon.explosionX[Weapon.curExplosion] = n;
        Weapon.explosionY[Weapon.curExplosion] = n2;
        Weapon.explosionStartTime[Weapon.curExplosion] = Worms.getTime();
        curExplosionSpr.setVisible(true);
        int n4 = 1;
        int n5 = 1;
        if (n3 == 0) {
            explosionHeight = 15;
            n5 = 225;
            n4 = 3276;
        }
        if (n3 == 1) {
            explosionHeight = 35;
            n5 = 625;
            n4 = 3276;
        }
        if (n3 == 2) {
            explosionHeight = 50;
            n5 = 2500;
            n4 = 983;
        }
        int n6 = 0;
        while (n6 < Weapon.game.teams.length) {
            int n7 = 0;
            while (n7 < Weapon.game.teams[n6].wormList.length) {
                Worm worm = Weapon.game.teams[n6].wormList[n7];
                int n8 = worm.positionX - explosionX[curExplosion];
                int n9 = worm.positionY - explosionY[curExplosion];
                int n10 = n8 * n8 + n9 * n9;
                if (n10 < n5) {
                    int n11 = (n5 - n10) * n4 >> 16;
                    worm.healthCountStartTime = Worms.getTime();
                    worm.healthCountDown += n11;
                    wormHit = true;
                }
                ++n7;
            }
            ++n6;
        }
        ++curExplosion;
        curExplosion %= 3;
    }

    private static void weaponDone() {
        boolean bl = true;
        int n = 0;
        while (n < explosionStartTime.length) {
            if (explosionStartTime[n] != -1L) {
                bl = false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < smokeTrailSize.length) {
            if (smokeTrailSize[n2] != 0) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            state = 0;
            game.endTurn(true);
        }
    }

    public static void runFrame() {
        int n;
        block52: {
            block53: {
                block55: {
                    block54: {
                        if (state == 0) {
                            return;
                        }
                        int n2 = 0;
                        while (n2 < smokeTrailSize.length) {
                            int n3 = n2;
                            smokeTrailSize[n3] = smokeTrailSize[n3] - 1;
                            if (smokeTrailSize[n2] < 0) {
                                Weapon.smokeTrailSize[n2] = 0;
                            }
                            ++n2;
                        }
                        if (activeWeapon == -1) {
                            Weapon.weaponDone();
                        }
                        if (state == 2 && activeWeapon != -1) {
                            blowUpTime = 6 - (int)(Worms.getTime() - launchTime) / 1000;
                            positionX = initialX;
                            positionY = initialY;
                            if (activeWeapon == 4) {
                                if (blowUpTime == 0) {
                                    Weapon.explode(positionX, positionY, 2);
                                    activeWeapon = -1;
                                }
                                dynamite.setFrame(Game.curFrame / 4 % Weapon.dynamite.frameCount);
                            }
                        }
                        if (state != 1 || activeWeapon == -1) break block52;
                        if (activeWeapon == 5) break block53;
                        blowUpTime = 3 - (int)(Worms.getTime() - launchTime) / 1000;
                        ++weaponIterationCount;
                        oldPositionX = positionX;
                        oldPositionY = positionY;
                        positionX = initialX + (cosAngleI[0] >> 16) + (curWind >> 8);
                        positionY = initialY - (sinAngleI[0] + (gravityI[0] >> 9) * time >> 16);
                        ox = cosAngleI[0] + (curWind >> 8);
                        oy = sinAngleI[0] + (gravityI[0] * time >> 9);
                        time += deltaTime;
                        curWind += windFactor;
                        sinAngleI[0] = sinAngleI[0] + sinAng[0];
                        cosAngleI[0] = cosAngleI[0] + cosAng[0];
                        gravityI[0] = gravityI[0] + gravityAdd[0];
                        vx = cosAngleI[0] - ox;
                        vy = sinAngleI[0] + (gravityI[0] * time >> 9) - oy;
                        if ((vy >>= 15) > 0 && (vx >>= 15) >= 0) {
                            if (vx > 19) {
                                vx = 19;
                            }
                            if (vy > 19) {
                                vy = 19;
                            }
                            desiredRotFrame = 17 - Game.vectorTable[vy * 20 + vx] / 5120;
                        } else if (vy <= 0 && vx >= 0) {
                            vy = -vy;
                            if (vx > 19) {
                                vx = 19;
                            }
                            if (vy > 19) {
                                vy = 19;
                            }
                            desiredRotFrame = 9 + Game.vectorTable[vy * 20 + vx] / 5120;
                        } else if (vy > 0 && vx < 0) {
                            if ((vx = -vx) > 19) {
                                vx = 19;
                            }
                            if (vy > 19) {
                                vy = 19;
                            }
                            desiredRotFrame = Game.vectorTable[vy * 20 + vx] / 5120;
                        } else if (vy <= 0 && vx < 0) {
                            vy = -vy;
                            if ((vx = -vx) > 19) {
                                vx = 19;
                            }
                            if (vy > 19) {
                                vy = 19;
                            }
                            desiredRotFrame = 9 - Game.vectorTable[vy * 20 + vx] / 5120;
                        }
                        if (rocket.getFrame() < desiredRotFrame) {
                            rocket.setFrame(rocket.getFrame() + 1);
                        } else if (rocket.getFrame() > desiredRotFrame) {
                            rocket.setFrame(rocket.getFrame() - 1);
                        }
                        mortar.setFrame(rocket.getFrame());
                        vectorX = positionX;
                        vectorY = positionY;
                        ++curTrail;
                        Weapon.smokeTrailX[Weapon.curTrail %= Weapon.smokeTrailX.length - 1] = positionX;
                        Weapon.smokeTrailY[Weapon.curTrail] = positionY;
                        if (positionX < 0) break block54;
                        if (positionX > 300) break block54;
                        if (positionY <= 150) break block55;
                    }
                    Weapon.weaponDone();
                    return;
                }
                Weapon.smokeTrailSize[Weapon.curTrail] = 10;
                landscape.center(positionX, positionY);
                if (activeWeapon == 3 || activeWeapon == 2) {
                    Weapon.landscape.circle_init[0] = false;
                    Weapon.landscape.circle_init[1] = false;
                    Weapon.landscape.circle_init[2] = false;
                    Weapon.landscape.circle_init[3] = false;
                    Weapon.landscape.circle_init[4] = false;
                    if (blowUpTime == 0) {
                        Weapon.explode(positionX, positionY, 1);
                        if (activeWeapon == 3) {
                            activeWeapon = -1;
                        }
                        if (activeWeapon == 2) {
                            activeWeapon = 5;
                            initialX = positionX;
                            initialY = positionY;
                            time = 0;
                            n = 0;
                            while (n < explosionStartTime.length) {
                                angle = n < 2 ? Math.abs(random.nextInt()) % 90 : Math.abs(random.nextInt()) % 90 + 270;
                                Weapon.sinAng[n] = Game.table[angle % 360] * 15;
                                Weapon.cosAng[n] = Game.table[(angle + 90) % 360] * 15;
                                time = 60;
                                int n4 = n;
                                sinAng[n4] = sinAng[n4] * deltaTime;
                                int n5 = n;
                                cosAng[n5] = cosAng[n5] * deltaTime;
                                Weapon.sinAngleI[n] = 0;
                                Weapon.cosAngleI[n] = 0;
                                Weapon.gravityAdd[n] = -2501 * deltaTime;
                                Weapon.gravityI[n] = 0;
                                Weapon.clustletX[n] = positionX;
                                Weapon.clustletY[n] = positionY;
                                ++n;
                            }
                        }
                    } else {
                        if (time > 500 && (landscape.earthCollision(positionX - 4, positionY, true, null) || landscape.earthCollision(positionX + 4, positionY, true, null) || landscape.earthCollision(positionX - 4, positionY + 4, true, null) || landscape.earthCollision(positionX + 4, positionY + 4, true, null))) {
                            Weapon.fire(game, landscape, parentWorm, activeWeapon, positionX, positionY - 4, windFactor, velocity / 2 + velocity / 4, angle, false);
                        }
                        if (activeWeapon == 3) {
                            grenade.setFrame(Game.curFrame % Weapon.grenade.frameCount);
                        }
                        if (activeWeapon == 2) {
                            cluster.setFrame(Game.curFrame % Weapon.cluster.frameCount);
                        }
                    }
                }
                if (activeWeapon == 0 || activeWeapon == 1) {
                    Weapon.landscape.circle_init[0] = false;
                    Weapon.landscape.circle_init[1] = false;
                    Weapon.landscape.circle_init[2] = false;
                    Weapon.landscape.circle_init[3] = false;
                    Weapon.landscape.circle_init[4] = false;
                    n = 0;
                    n = weaponIterationCount < 8 ? (int)(CollisionIterator.checkCollision(oldPositionX, oldPositionY, positionX, positionY, landscape, parentWorm) ? 1 : 0) : (int)(CollisionIterator.checkCollision(oldPositionX, oldPositionY, positionX, positionY, landscape, null) ? 1 : 0);
                    if (n != 0) {
                        positionX = CollisionIterator.collisionX;
                        positionY = CollisionIterator.collisionY;
                        if (activeWeapon == 0) {
                            Weapon.explode(positionX, positionY, 1);
                            activeWeapon = -1;
                        }
                        if (activeWeapon == 1) {
                            Weapon.explode(positionX, positionY, 2);
                            activeWeapon = -1;
                        }
                    }
                }
            }
            if (activeWeapon == 5) {
                landscape.center(clustletX[0] + clustletX[1] + clustletX[2] + clustletX[3] >> 2, clustletY[0] + clustletY[1] + clustletY[2] + clustletY[3] >> 2);
                n = 0;
                while (n < clustletY.length) {
                    if (!clustletExploded[n]) {
                        if (!landscape.earthCollision(clustletX[n], clustletY[n], true, null)) {
                            Weapon.clustletX[n] = initialX + (cosAngleI[n] >> 16);
                            Weapon.clustletY[n] = initialY - (sinAngleI[n] + (gravityI[n] >> 9) * time >> 16);
                            if (clustletY[n] > 150) {
                                Weapon.clustletExploded[n] = true;
                            }
                            time += deltaTime;
                            int n6 = n;
                            sinAngleI[n6] = sinAngleI[n6] + sinAng[n];
                            int n7 = n;
                            cosAngleI[n7] = cosAngleI[n7] + cosAng[n];
                            int n8 = n;
                            gravityI[n8] = gravityI[n8] + gravityAdd[n];
                        } else {
                            Weapon.explode(clustletX[n], clustletY[n], 0);
                            Weapon.clustletExploded[n] = true;
                        }
                    }
                    ++n;
                }
                time += deltaTime;
            }
        }
        if (activeWeapon == 5) {
            Weapon.landscape.circle_init[0] = false;
            Weapon.landscape.circle_init[1] = false;
            Weapon.landscape.circle_init[2] = false;
            Weapon.landscape.circle_init[3] = false;
            Weapon.landscape.circle_init[4] = false;
            n = 1;
            int n9 = 0;
            while (n9 < clustletExploded.length) {
                if (!clustletExploded[n9]) {
                    n = 0;
                }
                ++n9;
            }
            if (n != 0) {
                Weapon.weaponDone();
            }
        }
    }

    public static boolean isActive() {
        return state == 1;
    }

    public static boolean isDynamiteActive() {
        return state == 2;
    }

    public static void paint(Graphics graphics) {
        int n;
        rocket.setPosition(positionX - Weapon.rocket.width / 2 + Landscape.levelX, positionY - Weapon.rocket.height / 2 + Landscape.levelY);
        mortar.setPosition(positionX - Weapon.mortar.width / 2 + Landscape.levelX, positionY - Weapon.mortar.height / 2 + Landscape.levelY);
        grenade.setPosition(positionX - Weapon.grenade.width / 2 + Landscape.levelX, positionY - Weapon.grenade.height / 2 + Landscape.levelY);
        cluster.setPosition(positionX - Weapon.cluster.width / 2 + Landscape.levelX, positionY - Weapon.cluster.height / 2 + Landscape.levelY);
        dynamite.setPosition(positionX - Weapon.dynamite.width / 2 + Landscape.levelX, positionY - Weapon.dynamite.height / 2 + Landscape.levelY);
        int n2 = smokeTrailX.length - 1;
        while (n2 > 0) {
            if (smokeTrailX[n2] != -1 && smokeTrailSize[n2] <= 8) {
                graphics.setColor(255 - (10 - smokeTrailSize[n2]) * 10, 255 - (10 - smokeTrailSize[n2]) * 10, 255 - (10 - smokeTrailSize[n2]) * 10);
                graphics.fillArc(smokeTrailX[n2] + Landscape.levelX - smokeTrailSize[n2] / 2, smokeTrailY[n2] + Landscape.levelY - smokeTrailSize[n2] / 2, smokeTrailSize[n2], smokeTrailSize[n2], 0, 360);
            }
            --n2;
        }
        if (state == 1) {
            if (activeWeapon == 0) {
                rocket.paint(graphics);
            }
            if (activeWeapon == 1) {
                mortar.paint(graphics);
            }
            if (activeWeapon == 3) {
                grenade.paint(graphics);
            }
            if (activeWeapon == 2) {
                cluster.paint(graphics);
            }
            if (activeWeapon == 5) {
                n = 0;
                while (n < clustletX.length) {
                    if (!clustletExploded[n]) {
                        clustlet.setPosition(clustletX[n] + Landscape.levelX - Weapon.clustlet.width / 2, clustletY[n] + Landscape.levelY - Weapon.clustlet.height / 2);
                        clustlet.setFrame((Game.curFrame + clustletStartFrame[n]) % Weapon.clustlet.frameCount);
                        clustlet.paint(graphics);
                    }
                    ++n;
                }
            }
            if (blowUpTime > 0) {
                if (activeWeapon == 3) {
                    FontRender.writeString(graphics, "" + blowUpTime, Weapon.grenade.positionX - 6, Weapon.grenade.positionY - 6);
                }
                if (activeWeapon == 2) {
                    FontRender.writeString(graphics, "" + blowUpTime, Weapon.grenade.positionX - 6, Weapon.grenade.positionY - 6);
                }
            }
        }
        if (state == 2) {
            if (activeWeapon == 4) {
                dynamite.paint(graphics);
            }
            FontRender.writeString(graphics, "" + blowUpTime, Weapon.dynamite.positionX + 2, Weapon.dynamite.positionY - 10);
        }
        n = 0;
        while (n < explosionStartTime.length) {
            if (explosionStartTime[n] != -1L) {
                Weapon.explosionFrame[n] = (int)(Worms.getTime() - explosionStartTime[n]) / deviceTimerDivide;
                if (explosionFrame[n] <= 70) {
                    curExplosionSpr.setPosition(explosionX[n] + Landscape.levelX - 17, explosionY[n] + Landscape.levelY - 17);
                    Weapon.paintPhattExplosions(graphics, explosionFrame[n], explosionX[n] + Landscape.levelX - explosionHeight / 2, explosionY[n] + Landscape.levelY - explosionHeight / 2, explosionHeight, explosionHeight, n);
                } else if (explosionFrame[n] > 70) {
                    if (Menu.vibratorEnabled()) {
                        Game.vibrationOFF();
                    }
                    wormHit = false;
                    if (landscape != null && !doneQuartile4[n]) {
                        landscape.mapCircle_quartile4(n, explosionX[n], explosionY[n], explosionHeight);
                    }
                    Weapon.doneQuartile1[n] = false;
                    Weapon.doneQuartile2[n] = false;
                    Weapon.doneQuartile3[n] = false;
                    Weapon.doneQuartile4[n] = false;
                    Weapon.explosionStartTime[n] = -1L;
                    Weapon.explodeTerrain[n] = true;
                }
            }
            ++n;
        }
    }

    public static void reset() {
        state = 0;
        int n = 0;
        while (n < smokeTrailX.length) {
            Weapon.smokeTrailX[n] = -1;
            Weapon.smokeTrailY[n] = -1;
            ++n;
        }
        curTrail = 0;
    }

    public static void paintPhattExplosions(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            int n7;
            int n8;
            if (n > 70) {
                return;
            }
            if (n < 30) {
                n8 = 1;
                n7 = 0;
                graphics.setColor(255, 255, 230);
                if (explodeTerrain[n6]) {
                    landscape.paint_explosion(n6, explosionX[n6], explosionY[n6], explosionHeight);
                    Weapon.explodeTerrain[n6] = false;
                    if (Menu.soundEnabled()) {
                        try {
                            Game.sound_EXPLOSION.start();
                        }
                        catch (MediaException mediaException) {
                            // empty catch block
                        }
                    }
                    if (Menu.vibratorEnabled() && wormHit) {
                        Worms.vibratorStartTime = Worms.getTime();
                        Worms.WormsDisplay.vibrate(500);
                    }
                }
            } else if (n < 40) {
                n8 = 2;
                n7 = n2 / 5 * n8;
                graphics.setColor(225, 225, 225);
                curExplosionSpr.setFrame(1);
                curExplosionSpr.paint(graphics);
                if (!doneQuartile1[n6]) {
                    landscape.mapCircle_quartile1(n6, explosionX[n6], explosionY[n6], explosionHeight);
                    Weapon.doneQuartile1[n6] = true;
                    Game.vibrationOFF();
                }
            } else if (n < 50) {
                n8 = 3;
                n7 = n2 / 5 * n8;
                graphics.setColor(200, 200, 200);
                if (!doneQuartile2[n6]) {
                    landscape.mapCircle_quartile2(n6, explosionX[n6], explosionY[n6], explosionHeight);
                    Weapon.doneQuartile2[n6] = true;
                    Game.vibrationOFF();
                }
            } else if (n < 60) {
                n8 = 4;
                n7 = n2 / 5 * n8;
                graphics.setColor(175, 175, 175);
                if (!doneQuartile3[n6]) {
                    landscape.mapCircle_quartile3(n6, explosionX[n6], explosionY[n6], explosionHeight);
                    Weapon.doneQuartile3[n6] = true;
                    Game.vibrationOFF();
                }
            } else {
                n8 = 5;
                n7 = n2 / 5 * n8;
                graphics.setColor(150, 150, 150);
                if (!doneQuartile4[n6]) {
                    landscape.mapCircle_quartile4(n6, explosionX[n6], explosionY[n6], explosionHeight);
                    Weapon.doneQuartile4[n6] = true;
                    Game.vibrationOFF();
                }
            }
            graphics.fillArc(n2 + n7 / 2, n3 + n7 / 2, n4 - n7, n5 - n7, 0, 360);
            if (n8 < 3) {
                curExplosionSpr.setFrame(2);
                curExplosionSpr.paint(graphics);
            } else if (n8 == 3) {
                int n9 = n / 5;
                graphics.setColor(150, 150, 0);
                graphics.drawArc(n2, n3, n4, n5, 0, 360);
                graphics.setColor(200, 200, 0);
                graphics.drawArc(n2 - n9, n3 - n9, n4 + 2 * n9, n5 + 2 * n9, 0, 360);
                graphics.setColor(255, 255, 100);
                graphics.drawArc(n2 - 2 * n9, n3 - 2 * n9, n4 + 4 * n9, n5 + 4 * n9, 0, 360);
            } else if (n8 == 4) {
                int n10 = n / 5;
                graphics.setColor(100, 100, 0);
                graphics.drawArc(n2, n3, n4, n5, 0, 360);
                graphics.setColor(150, 50, 50);
                graphics.drawArc(n2 - n10, n3 - n10, n4 + 2 * n10, n5 + 2 * n10, 0, 360);
                graphics.setColor(200, 200, 200);
                graphics.drawArc(n2 - 2 * n10, n3 - 2 * n10, n4 + 4 * n10, n5 + 4 * n10, 0, 360);
            } else if (n8 == 5) {
                int n11 = n / 5;
                graphics.setColor(150, 150, 150);
                graphics.drawArc(n2 - n11, n3 - n11, n4 + 2 * n11, n5 + 2 * n11, 0, 360);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        sinAng = new int[4];
        cosAng = new int[4];
        sinAngleI = new int[4];
        cosAngleI = new int[4];
        gravityI = new int[4];
        gravityAdd = new int[4];
        random = new Random();
        clustletX = new int[4];
        clustletY = new int[4];
        clustletStartFrame = new int[4];
        clustletExploded = new boolean[4];
        explosionX = new int[4];
        explosionY = new int[4];
        explosionStartTime = new long[4];
        smokeTrailX = new int[15];
        smokeTrailY = new int[15];
        smokeTrailSize = new int[15];
        deviceTimerDivide = 30;
        explodeTerrain = new boolean[]{true, true, true, true};
        explosionFrame = new int[]{0, 0, 0, 0};
        doneQuartile1 = new boolean[]{false, false, false, false};
        doneQuartile2 = new boolean[]{false, false, false, false};
        doneQuartile3 = new boolean[]{false, false, false, false};
        doneQuartile4 = new boolean[]{false, false, false, false};
    }
}

