/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.collections;

import java.util.Hashtable;

public class Cache {
    private int max;
    private Hashtable cache;
    private Item mru;
    private Item lru;

    public Cache(int maxCapacity) {
        this.cache = new Hashtable(maxCapacity * 2);
        this.mru = null;
        this.lru = null;
        this.setMaxCapacity(maxCapacity);
    }

    public void clear() {
        this.cache.clear();
        this.mru = null;
        this.lru = null;
    }

    public int size() {
        return this.cache.size();
    }

    public int getMaxCapacity() {
        return this.max;
    }

    public void setMaxCapacity(int maxCapacity) {
        if (maxCapacity < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = this.cache.size() - maxCapacity; i > 0; --i) {
            this.cache.remove(this.lru.key);
            this.lru.previous.next = null;
            this.lru = this.lru.previous;
        }
        this.max = maxCapacity;
    }

    public void add(Object key, Object data) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.max > 0) {
            Item item = new Item();
            int cacheSize = this.cache.size();
            if (cacheSize > this.max) {
                throw new IllegalStateException();
            }
            Object existing = this.get(key);
            if (existing != null) {
                if (existing != data) {
                    Item i = (Item)this.cache.get(key);
                    i.data = data;
                }
            } else {
                if (cacheSize == this.max) {
                    this.cache.remove(this.lru.key);
                    if (this.lru.previous != null) {
                        this.lru.previous.next = null;
                    }
                    this.lru = this.lru.previous;
                }
                item.key = key;
                item.data = data;
                item.next = this.mru;
                item.previous = null;
                if (this.cache.size() == 0) {
                    this.lru = item;
                } else {
                    this.mru.previous = item;
                }
                this.mru = item;
                this.cache.put(key, item);
            }
        }
    }

    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Object o = this.cache.get(key);
        if (o == null) {
            return null;
        }
        Item item = (Item)o;
        if (this.mru != item) {
            if (this.lru == item) {
                this.lru = item.previous;
            }
            if (item.next != null) {
                item.next.previous = item.previous;
            }
            item.previous.next = item.next;
            this.mru.previous = item;
            item.previous = null;
            item.next = this.mru;
            this.mru = item;
        }
        return item.data;
    }

    private static final class Item {
        public Object key;
        public Object data;
        public Item next;
        public Item previous;

        private Item() {
        }
    }
}

