/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationImpl;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.logging.Log;

public class MockLocationProvider
extends LocationProvider {
    private int state = 2;
    private LocationListener listener;
    private Location location;

    public void setState(int state) {
        if (state != 3 && state != 2 && state != 1) {
            throw new IllegalArgumentException("state was invalid.  It must be OUT_OF_SERVICE, TEMPORARILY_UNAVAILABLE, or AVAILABLE.");
        }
        if (this.state != state) {
            this.state = state;
            if (this.listener != null) {
                try {
                    this.listener.providerStateChanged(this, state);
                }
                catch (Throwable t) {
                    Log.warn("Unhandled exception in LocationProvider.providerStateChanged to " + state, t);
                }
            }
        }
    }

    public void setLocation(QualifiedCoordinates coordinates, float speed) {
        if (coordinates == null) {
            throw new IllegalArgumentException("coordinates cannot be null.");
        }
        this.setState(1);
        if (this.listener != null) {
            this.location = new LocationImpl(coordinates, speed, Float.NaN, System.currentTimeMillis());
            try {
                this.listener.locationUpdated(this, this.location);
            }
            catch (Throwable t) {
                Log.warn("Unhandled exception in LocationProvider.locationUpdated\n" + this.location, t);
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public Location getLocation(int timeout) throws LocationException, InterruptedException {
        if (this.state == 3) {
            throw new LocationException("Mock provider is out of service");
        }
        if (this.location == null) {
            throw new LocationException("Mock provider has not had location set yet");
        }
        return this.location;
    }

    protected Location getLastKnownLocationToProvider() {
        return this.location;
    }

    public void setLocationListener(LocationListener locationlistener, int interval, int timeout, int maxAge) {
        this.listener = locationlistener;
    }

    public void reset() {
        this.setState(2);
        this.setState(1);
    }

    public void close() {
        this.setState(3);
        this.location = null;
    }
}

