/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Graphics;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;
import org.j4me.ui.components.Label;

public class CheckBox
extends Component {
    private static final double CHECKBOX_TO_FONT_RATIO = 0.7;
    private Label label = new Label();
    private boolean checked;

    public String getLabel() {
        String l = this.label.getLabel();
        if (l == null) {
            l = "";
        }
        return l;
    }

    public void setLabel(String value) {
        this.label.setLabel(value);
        this.invalidate();
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    protected void showNotify() {
        this.label.visible(true);
        super.showNotify();
    }

    protected void hideNotify() {
        this.label.visible(false);
        super.hideNotify();
    }

    protected void paintComponent(Graphics g, Theme theme, int width, int height, boolean selected) {
        int checkboxSide = this.checkboxSideSize(theme);
        int y = (height - checkboxSide) / 2;
        int offset = CheckBox.paintRect(g, theme, 0, y, checkboxSide, checkboxSide, selected);
        if (this.checked) {
            int checkColor = theme.getHighlightColor();
            g.setColor(checkColor);
            int checkOffset = offset + 1;
            int fillSide = checkboxSide - 2 * checkOffset;
            g.fillRect(checkOffset, y + checkOffset, fillSide, fillSide);
        }
        int lx = (int)((double)checkboxSide * 1.5);
        int lw = width - lx;
        int[] lDimensions = this.label.getPreferredSize(theme, lw, height);
        int lh = lDimensions[1];
        int ly = (height - lh) / 2;
        this.label.paint(g, theme, this.getScreen(), lx, ly, lw, lh, selected);
    }

    private int checkboxSideSize(Theme theme) {
        int fontHeight = theme.getFont().getHeight();
        int checkboxSide = (int)((double)fontHeight * 0.7);
        return checkboxSide;
    }

    protected int[] getPreferredComponentSize(Theme theme, int viewportWidth, int viewportHeight) {
        int checkboxSide = this.checkboxSideSize(theme);
        int[] labelDimensions = this.label.getPreferredSize(theme, viewportWidth - checkboxSide, viewportHeight);
        int height = Math.max(checkboxSide, labelDimensions[1]);
        height += height % 2;
        return new int[]{viewportWidth, height};
    }

    public boolean acceptsInput() {
        return true;
    }

    public void keyPressed(int keyCode) {
        if (keyCode > 0 || keyCode == -8) {
            this.checked = !this.checked;
            this.repaint();
        }
        super.keyPressed(keyCode);
    }

    public void pointerPressed(int x, int y) {
        this.checked = !this.checked;
        this.repaint();
        super.pointerPressed(x, y);
    }
}

