/*
 * Decompiled with CFR 0.152.
 */
package hideme;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class FileList
extends Hashtable {
    private static final String STORE_NAME = "HideMeFiles";
    private boolean init = false;

    private void init() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            RecordEnumeration e = store.enumerateRecords(null, null, false);
            while (e.hasNextElement()) {
                int recordId = e.nextRecordId();
                byte[] aux = store.getRecord(recordId);
                super.put(new Integer(recordId), new String(aux, 0, aux.length));
            }
            store.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        this.init = true;
    }

    public boolean isDir(String fileName) {
        return fileName.endsWith("/");
    }

    public boolean isDir(int recordId) {
        String fileName;
        if (!this.init) {
            this.init();
        }
        return (fileName = (String)this.get(new Integer(recordId))) != null && fileName.endsWith("/");
    }

    public String get(int recordId) {
        if (!this.init) {
            this.init();
        }
        return (String)this.get(new Integer(recordId));
    }

    public String remove(int recordId) {
        return (String)this.remove(new Integer(recordId));
    }

    public Object remove(Object arg) {
        if (!this.init) {
            this.init();
        }
        if (arg instanceof Integer) {
            try {
                RecordStore store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                store.deleteRecord(((Integer)arg).intValue());
                store.closeRecordStore();
            }
            catch (RecordStoreException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            return super.remove(arg);
        }
        throw new RuntimeException("\u0422\u043e\u043b\u044c\u043a\u043e \u0446\u0435\u043b\u044b\u0435");
    }

    public int add(String fileName) {
        int ret;
        byte[] data = fileName.getBytes();
        try {
            RecordStore store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            ret = store.addRecord(data, 0, data.length);
            store.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        super.put(new Integer(ret), fileName);
        return ret;
    }

    public Object put(Object key, Object value) {
        throw new IllegalArgumentException("\u041d\u0435 \u0434\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f");
    }

    public Enumeration elements() {
        if (!this.init) {
            this.init();
        }
        return super.elements();
    }

    public Enumeration keys() {
        if (!this.init) {
            this.init();
        }
        return super.keys();
    }
}

