/*
 * Flash block driver
 * Copyright (C) 1999-2000 Nicolas Pitre <nico@cam.org>
 *
 * This is a block device driver for Intel Flash memory.
 */


/* 
 * Partition definitions... 
 */
#if defined( CONFIG_SA1100_VICTOR )

#define FLASH_PARTITIONS	4
static int flash_length[FLASH_PARTITIONS] = { 0x10000, 0x40000, 0x1a0000, 0x10000 };

#elif defined( CONFIG_SA1100_THINCLIENT ) || (CONFIG_SA1100_GRAPHICSCLIENT)

#define FLASH_PARTITIONS	3
// static int flash_length[FLASH_PARTITIONS] = { 0x80000, 0x780000, 0x800000 };
static int flash_length[FLASH_PARTITIONS] = { 0x100000, 0x300000, 0xc00000 };


#elif defined( CONFIG_VIPCI )

#define FLASH_PARTITIONS	4
static int flash_length[FLASH_PARTITIONS] = { 0x10000, 0x80000, 0x730000, 0x40000 };

#elif defined( CONFIG_SA1100_BITSY )

#define FLASH_PARTITIONS	6
static int flash_length[FLASH_PARTITIONS] = { 0x00040000, 0x00080000, 0x00040000, 0x00700000, 0x00800000, 0x01000000 };

#elif defined( CONFIG_ARCH_PERSONAL_SERVER )

#define FLASH_PARTITIONS	4
static int flash_length[FLASH_PARTITIONS] = { 0x00020000, 0x000e0000, 0x00600000, 0x00200000 };

#else
#error Missing partition definition
#endif


/*
 *  Macros to toggle WP and VPP pins for programming flash
 */
#ifdef CONFIG_SA1100_VICTOR
#define GPIO_FLASH_WP	(GPIO_GPIO4|GPIO_GPIO5)
#define WP_VPP_ON()	GPSR = GPIO_FLASH_WP
#define WP_VPP_OFF()	GPCR = GPIO_FLASH_WP
#else
#define WP_VPP_ON()
#define WP_VPP_OFF()
#endif


/*
 * Flash access methods
 * (FLASH_SECTSIZE would benifit from autodetection... or validation at least)
 */
#if defined( CONFIG_SA1100_VICTOR )

#define FLASH_SECTSIZE		(64*1024)
#define _CMD( x )  (x)

typedef unsigned short FLASH_t;

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	return (FLASH_t *)(base + i);
}

#elif defined( CONFIG_SA1100_ASSABET )

/* two paralel 16-bit access */
#define FLASH_SECTSIZE		(2*64*1024)
#define _CMD( x )  ((x)|((x)<<16))

typedef unsigned int FLASH_t;

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	return (FLASH_t *)(base + i);
}

#elif defined( CONFIG_SA1100_THINCLIENT ) || defined(CONFIG_SA1100_GRAPHICSCLIENT) || defined(CONFIG_SA1100_BITSY) || defined(CONFIG_ARCH_PERSONAL_SERVER)

/* two paralel 16-bit access */
#define FLASH_SECTSIZE		(2*128*1024)
#define _CMD( x )  ((x)|((x)<<16))

typedef unsigned int FLASH_t;

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	return (FLASH_t *)(base + i);
}

#elif defined( CONFIG_VIPCI1 )

#define FLASH_SECTSIZE		(64*1024)
#define _CMD( x )  (x)

typedef unsigned char FLASH_t;

#include <asm/dec21285.h>

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	*CSR_ROMWRITEREG = i;
	i &= ~(4-sizeof(FLASH_t));
	return (FLASH_t *)(base + i);
}

#elif defined( CONFIG_VIPCI2 )

/* two paralel 16-bit access */
#define FLASH_SECTSIZE		(2*64*1024)
#define _CMD( x )  ((x)|((x)<<16))

typedef unsigned int FLASH_t;

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	return (FLASH_t *)(base + i);
}

#else
#error Missing pointer access definition
#endif


