/*
 * arch/arm/mm/mm-lusl7200.c
 *
 * Extra MM routines for L7200 architecture
 *
 * Copyright (C) 2000 Steve Hill (sjhill@cotw.com)
 */

#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/page.h>
#include <asm/proc/domain.h>
#include <asm/setup.h>

#include "map.h"

static struct map_desc l7200_io_desc[] __initdata = {
	{ IO_BASE,	IO_START,	IO_SIZE,	DOMAIN_IO, 0, 1 ,0 ,0},
	{ IO_BASE_2,	IO_START_2,	IO_SIZE_2,	DOMAIN_IO, 0, 1 ,0 ,0},
	LAST_DESC
};

void __init l7200_map_io(void)
{
	iotable_init(l7200_io_desc);
}

