/*****************************************************************************/

/*
 *
 *	Pseudo Ethernet driver as used with the Compaq iPAQ
 *	to give the iPAQ network connectivity over USB.
 *	Modified from the prolific npl-2302 driver plusb.c
 *	This driver will either become a generic network driver
 *	or merged back into the plusb.c code. It is too early
 *	to tell.
 *
 *      plusb.c  --  prolific pl-2302 driver.
 *
 *      Copyright (C) 2000  Deti Fliegl (deti@fliegl.de)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *
 */

/*****************************************************************************/

#include <linux/module.h>
#include <linux/socket.h>
#include <linux/miscdevice.h>
#include <linux/list.h>
#include <linux/vmalloc.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <asm/uaccess.h>
#include <asm/atomic.h>
#include <linux/delay.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#define DEBUG
#include <linux/usb.h>

#include "usbh_h3600.h"

/* --------------------------------------------------------------------- */

#define NRPLUSB 4

#define	USB_VENDOR_COMPAQ  1183
#define PRODUCT_ID 0x505A
unsigned int readendp , writeendp;	/* CF added */
int plusb_net_init(struct net_device *);
/*-------------------------------------------------------------------*/

static int tx_test(urb_t *);

static unsigned int pktcnt=0;
static plusb_t plusb[NRPLUSB];

/* --------------------------------------------------------------------- */
static int plusb_add_buf_tail (plusb_t *s, struct list_head *dst, struct list_head *src)
{
	unsigned long flags;
	struct list_head *tmp;
	int ret = 0;

	spin_lock_irqsave (&s->lock, flags);

	if (list_empty (src)) {
		// no elements in source buffer
		ret = -1;
		goto err;
	}
	tmp = src->next;
	list_del (tmp);
	list_add_tail (tmp, dst);

  err:	spin_unlock_irqrestore (&s->lock, flags);
	return ret;
}
/*-------------------------------------------------------------------*/

static int plusb_my_bulk(plusb_t *s, int pipe, void *data, int size, int *actual_length)
{
	int ret;

	dbg("plusb_my_bulk: pipe=%04x len:%d data=%p usbdev=%p",
		pipe,size,data,s->usbdev);

	ret=usb_bulk_msg(s->usbdev, pipe, data, size, actual_length, 1000);
	if(ret<0) {
		err("plusb: usb_bulk_msg failed(%d)",ret);
	}
	
	if( ret == -EPIPE ) {
		warn("CLEAR_FEATURE request to remove STALL condition.");
		if(usb_clear_halt(s->usbdev, usb_pipeendpoint(pipe)))
			err("request failed");
		}

	dbg("plusb_my_bulk: finished act: %d", *actual_length);		
	return ret;
}

/* --------------------------------------------------------------------- */

static void plusb_bh(void *context)
{
	plusb_t *s=context;
	struct net_device_stats *stats=&s->net_stats;
	int ret=0;
	int actual_length;
	skb_list_t *skb_list;
	struct sk_buff *skb;

	dbg("plusb_bh: i:%d",in_interrupt());

	while(!list_empty(&s->tx_skb_list)) {

/* took out as this is not generic
		dbg("plusb_bh: checking status = %04x (%p)",s->status,s);
		if(!(s->status&_PLUSB_TXOK))
			break; 
*/
		
		skb_list = list_entry (s->tx_skb_list.next, skb_list_t, skb_list);
		if(!skb_list->state) {
			dbg("plusb_bh: not yet ready");
			schedule();
			continue;
		}

		skb=skb_list->skb;
		/* CF changed _PLUSB_BULKOUTP to writeendp */
		dbg("plusb_bh: Tx len=%d\n",skb->len);
		ret=plusb_my_bulk(s, usb_sndbulkpipe (s->usbdev, writeendp),
		                  skb->data, skb->len, &actual_length);
	
		if(ret || skb->len != actual_length ||!(skb->len%64)) {
			dbg("plusb_bh: going again");
			plusb_my_bulk(s, usb_sndbulkpipe (s->usbdev, writeendp),
		              NULL, 0, &actual_length);
		}

		if(!ret) {
			stats->tx_packets++;
			stats->tx_bytes+=skb->len;
                }
		else {
			dbg("plusb_bh: registering errors");
			stats->tx_errors++;
			stats->tx_aborted_errors++;
		}

		dbg("plusb_bh: dev_kfree_skb");

		dev_kfree_skb(skb);
		skb_list->state=0;
		plusb_add_buf_tail (s, &s->free_skb_list, &s->tx_skb_list);	
	}

	dbg("plusb_bh: finished");
	s->in_bh=0;
}

/* --------------------------------------------------------------------- */

static int plusb_net_xmit(struct sk_buff *skb, struct net_device *dev)
{
	plusb_t *s=dev->priv;
	skb_list_t *skb_list;
	int ret=NET_XMIT_SUCCESS;

	dbg("plusb_net_xmit: len:%d i:%d",skb->len,in_interrupt());

        if(!s->connected || list_empty(&s->free_skb_list)) {
		ret=NET_XMIT_CN;
		goto lab;
	}	

	plusb_add_buf_tail (s, &s->tx_skb_list, &s->free_skb_list);
	skb_list = list_entry (s->tx_skb_list.prev, skb_list_t, skb_list);
	skb_list->skb=skb;
	skb_list->state=1;

lab:
	if(s->in_bh)
		return ret;

	dbg("plusb_net_xmit: queue_task");

	s->in_bh=1;
	queue_task(&s->bh, &tq_scheduler);

	dbg("plusb_net_xmit: finished");
	return ret;

}

/* --------------------------------------------------------------------- */
static void plusb_rx_complete(urb_t *purb)
{
	int i,len;
	unsigned char * ptr;
	int start;
#if 1
	int ret;
	plusb_t *s=purb->context;
#endif
	/* CF stub for now */
	len = purb->actual_length;
	ptr = (unsigned char *)purb->transfer_buffer;

#if 0
	printk("\nplusb_rx_complete: status:%d length:%d byte=%02x %02x\n",
		purb->status,len,*ptr,*(ptr+1));
#endif

#if 1

	if( !purb->status )
	{
	    unsigned char expected;

#if 0
	    start = (pktcnt) ? 0 : 2;	/* remember the header */
#else
	    start=2;
#endif
	    for(i=start ; i < len ; i++ )
	    {
		expected = (i % 0x100);		/* byte wrap round */
		if ( *(ptr + i ) != expected )
		{
		    printk("\nRXTEST expected = %02x got %02x\n",i,*(ptr+i) );
		    return;
		}
	    }
	}
	else
	{
	    printk("FAILED URB status > 0 \n");
	    return;
	}

	printk("[%d]RXOK %d bytes\n",pktcnt++,len);
#endif

#if 1
	s->rxbulkurb->actual_length=0;
	ret=usb_submit_urb(s->rxbulkurb);
	if(ret && ret!=-EBUSY)
	{
		printk("open: rxbulkurb submit failed\n");
	}
	tx_test(s->txbulkurb);
#endif


}

static void plusb_tx_complete(urb_t *purb)
{
	/* CF stub for now */
#if 1
	printk("\nTX_COMPLETE\n");
#else
	printk("plusb_tx_complete: status:%d length:%d",
		purb->status,purb->actual_length);

	/* This is a half duplex test but we should be queueing the tx pkts*/
	/* Fire another one  Should be queueing multiple packets!!*/
	/* may not be able to do this if we are still in an IRQ context */
#endif
}

static void plusb_bulk_complete(urb_t *purb)
{
	plusb_t *s=purb->context;

	dbg("plusb_bulk_complete: status:%d length:%d",purb->status,purb->actual_length);
	if(!s->connected)
		return;

	if( !purb->status) {
		struct sk_buff *skb;
		unsigned char *dst;
		int len=purb->transfer_buffer_length;
		struct net_device_stats *stats=&s->net_stats;
		int ret;	/* CF added this */

		skb=dev_alloc_skb(len);

		if(!skb) {
			err("plusb_bulk_complete: dev_alloc_skb(%d)=NULL, dropping frame",len);
			stats->rx_dropped++;
			return;
		}

		dbg("RX:>>>>>>>> LEN=%d <<<<<<<<<< \n",len);

		/* CF added this */
		if (1)
		{
			/* put the mac addresses back in, over the top of the
			* size that was sent over.
			*/
			unsigned char *mac_header;
			int idx;
			struct net_device *nd = &s->net_dev;
			dbg("copying mac address\n");

			mac_header = skb_push(skb, (2*ETH_ALEN)-2);
			for (idx=0;idx<ETH_ALEN;idx++)
			{
			    mac_header[idx] = nd->dev_addr[idx];
			    mac_header[idx+ETH_ALEN] = s->client_addr[idx];
			}
			skb->ip_summed = CHECKSUM_UNNECESSARY;
		}
		/* end of CF add */
		dst=(char *)skb_put(skb, len);
		memcpy( dst, purb->transfer_buffer, len);

		skb->dev=&s->net_dev;
		skb->protocol=eth_type_trans(skb, skb->dev);
		stats->rx_packets++;
		stats->rx_bytes+=len;
		netif_rx(skb);
		/* CF??? itsy NULLs the skt buff here */
		/* CF added this to requeue the urb */
		ret=usb_submit_urb(s->rxbulkurb);
		if(ret && ret!=-EBUSY) {
			err("plusb_int_complete: usb_submit_urb failed");
		}
	}
	else
		purb->status=0;
}

/* --------------------------------------------------------------------- */

#if 0
static void plusb_int_complete(urb_t *purb)
{
	plusb_t *s=purb->context;
	s->status=((unsigned char*)purb->transfer_buffer)[0]&255;
#if 0
	if((s->status&0x3f)!=0x20) {
		warn("invalid device status %02X", s->status);
		return;
	}
#endif	
	if(!s->connected)
		return;

	if(s->status&_PLUSB_RXD) {
		int ret;
		
		if(s->bulkurb->status) {
			err("plusb_int_complete: URB still in use");
			return;
		}
		
		ret=usb_submit_urb(s->bulkurb);
		if(ret && ret!=-EBUSY) {
			err("plusb_int_complete: usb_submit_urb failed");
		}
	}
		
	if(purb->status || s->status!=160)
		dbg("status: %p %d buf: %02X", purb->dev, purb->status, s->status);
}

#endif

/* --------------------------------------------------------------------- */

static void plusb_free_all(plusb_t *s)
{
	struct list_head *skb;
	skb_list_t *skb_list;
	
	dbg("plusb_free_all");
	run_task_queue(&tq_immediate);	

#if 0
	if(s->txbulkurb) {
		/* CF??? NOT LINKED YET */
		dbg("unlink txbulkurb");
		usb_unlink_urb(s->txbulkurb);
	}
#endif
	if(s->txbulkurb && s->txbulkurb->transfer_buffer) {
		dbg("kfree txbulkurb->transfer_buffer");
		kfree(s->txbulkurb->transfer_buffer);
		s->txbulkurb->transfer_buffer=NULL;
	}
	
	if(s->txbulkurb) {
		dbg("free_urb txbulkurb");
		usb_free_urb(s->txbulkurb);
		s->txbulkurb=NULL;
	}

	if(s->rxbulkurb) {
		dbg("unlink rxbulkurb");
		usb_unlink_urb(s->rxbulkurb);
	}
	
	if(s->rxbulkurb && s->rxbulkurb->transfer_buffer) {
		dbg("kfree rxbulkurb->transfer_buffer");
		kfree(s->rxbulkurb->transfer_buffer);
		s->rxbulkurb->transfer_buffer=NULL;
	}
	if(s->rxbulkurb) {
		dbg("free_urb rxbulkurb");
		usb_free_urb(s->rxbulkurb);
		s->rxbulkurb=NULL;
	}
	
	while(!list_empty(&s->free_skb_list)) {
		skb=s->free_skb_list.next;
		list_del(skb);
		skb_list = list_entry (skb, skb_list_t, skb_list);
		kfree(skb_list);
	}

	while(!list_empty(&s->tx_skb_list)) {
		skb=s->tx_skb_list.next;
		list_del(skb);
		skb_list = list_entry (skb, skb_list_t, skb_list);
		kfree(skb_list);	
	}
	dbg("plusb_free_all: finished");	
}

/*-------------------------------------------------------------------*/

static int plusb_alloc(plusb_t *s)
{
	int i;
	int rxlen,ret;	/* CF added */
	skb_list_t *skb;
	unsigned char * txbuff, *rxbuff ;	/* CF added */

	dbg("plusb_alloc");
	
	printk("plusb_alloc: allocating %d skb_list_t\n",_SKB_NUM);
	for(i=0 ; i < _SKB_NUM ; i++) {
		skb=kmalloc(sizeof(skb_list_t), GFP_KERNEL);
		if(!skb) {
			err("kmalloc for skb_list failed");
			goto reject;
		}
		memset(skb, 0, sizeof(skb_list_t));
		list_add(&skb->skb_list, &s->free_skb_list);
	}

/* -----------------RXBULKURB ---------------- */
#if 1
	rxlen = 16384;
#else
	rxlen = _BULK_DATA_RX_LEN;
#endif
	/* I am using this for INT xfers as well */
	s->rxbulkurb = usb_alloc_urb(0);
	if (!s->rxbulkurb) {
		err("TX:No free urbs available");
		goto reject;
	}
	rxbuff=kmalloc(rxlen, GFP_KERNEL);
	if(!rxbuff)
	{
		err("RX: kmalloc failed");
		goto reject;
	}
#if 1
	FILL_BULK_URB(s->rxbulkurb, s->usbdev, 
		usb_rcvbulkpipe(s->usbdev, readendp),
		rxbuff,	rxlen, plusb_rx_complete, s);
#else
	FILL_INT_URB(s->rxbulkurb, s->usbdev, 
		usb_rcvintpipe(s->usbdev, readendp),
		rxbuff,	rxlen, plusb_rx_complete, s,100);
#endif
#if 0
	s->rxbulkurb->next=NULL;
	s->rxbulkurb->transfer_flags=USB_URB_EARLY_COMPLETE;
#endif
	/* Finally Submit it */
#if 1
	ret=usb_submit_urb(s->rxbulkurb);
	if(ret && ret!=-EBUSY)
	{
		printk("open: rxbulkurb submit failed\n");
		plusb_free_all(s);
		return -EINVAL;
	}
	if( ret == -EBUSY) printk("RXURB BUSY\n");
	printk("RXBULK URB SUBMITTED rxlen=%d\n",rxlen);
#endif
/* -----------------TXBULKURB ---------------- */
	s->txbulkurb = usb_alloc_urb(0);
	if (!s->txbulkurb) {
		err("TX:No free urbs available");
		goto reject;
	}
	txbuff=kmalloc(_BULK_DATA_TX_LEN, GFP_KERNEL);
	if(!txbuff)
	{
		err("TX: kmalloc failed");
		goto reject;
	}
	FILL_BULK_URB(s->txbulkurb, s->usbdev, 
		usb_sndbulkpipe(s->usbdev, writeendp),
		txbuff,	_BULK_DATA_TX_LEN, plusb_tx_complete, s);

	dbg("plusb_alloc: finished");
	
	return 0;

  reject:
  	dbg("plusb_alloc: failed");
	
	plusb_free_all(s);
	return -ENOMEM;
}

int tx_test(urb_t * purb)
{
	int i,ret,txlen;	/* CF added this */
	char * pTx;


	if (!purb )
	{
		printk("PANIC NULL URB\n");
		return -1;
	}

	/* CF added this for test */
#if 1
	txlen=64;	/* USED to kick off TXTEST */
#else
	txlen=16257;	/* max len - 128 + 1 */
#endif
	pTx = (char *)purb->transfer_buffer;
	memset (pTx, 0, txlen);
	for(i=0; i < txlen ; i++)
		*(pTx + i) = i;

	*pTx = (unsigned char) (txlen & 0x00ff);
	*(pTx+1) = (unsigned char) ( (txlen & 0xff00) >> 8) ;
#if 0
	printk("\n-------start---------");
	for(i=0 ; i < txlen ; i++)
		printk("%02x :",*(pTx + i) );
	printk("\n-------end---------");
#endif

#if 0
	/* The send should take care of calbacks and receives? */
	ret=usb_bulk_msg(s->usbdev, usb_sndbulkpipe (s->usbdev, writeendp),
		"Hello world",txlen,&len,500);
	if(ret<0) {
		err("plusb: open:usb_bulk_msg failed(%d)",ret);
	}
#else
	/* submit Tx buffer */
	purb->transfer_buffer_length=txlen;
	ret=usb_submit_urb(purb);
	if(ret && ret!=-EBUSY) {
		err("txbulkurb submit failed\n");
		return -1;
	}

	printk("Tx %d bytes successfully transmitted\n",txlen);
#endif
	return 0;
}

/*-------------------------------------------------------------------*/

static int plusb_net_open(struct net_device *dev)
{
	plusb_t *s=dev->priv;
#if 0
	int ret;
	unsigned char buff[64];
	unsigned int actual_len=0;
	wait_queue_head_t waitq;	
	init_waitqueue_head(&waitq);	
#endif
	
	dbg("plusb_net_open");
	
	if(plusb_alloc(s))
		return -ENOMEM;


/* CF TEST --------------------*/
	/* submit Rx buffer */
#if 0
	ret=usb_submit_urb(s->rxbulkurb);
	if(ret && ret!=-EBUSY)
	{
		printk("_open: rxbulkurb submit failed\n");
		plusb_free_all(s);
		return -EINVAL;
	}
	if( ret == -EBUSY) printk("RXURB BUSY\n");
	printk("successfully submitted rxbulkurb\n");

	/* Send a packet */
	printk("Sleeping....");
	interruptible_sleep_on_timeout(&waitq, (5 * HZ) );	
#endif
	pktcnt=0;	/* TEST */
	tx_test(s->txbulkurb);	/* send a packet */
	printk("away\n....");
/* CF TEST --------------------*/

#if 0
	ret=usb_bulk_msg(s->usbdev,
			usb_rcvbulkpipe (s->usbdev, readendp),
			buff,
			64,
			&actual_len,
			1000);
	if(ret<0) {
		printk("plusb: usb_bulk_msg failed(%d)",ret);
	}
	else
		printk("Len returned=%d Data %02x:%02x\n",
			actual_len,buff[0],buff[1]);
#endif

	s->opened=1;

	MOD_INC_USE_COUNT;
	
	/* CF dbg("plusb_net_open: success"); */
	printk("plusb_net_open: success\n");
	
	return 0;
	
}

/* --------------------------------------------------------------------- */

static int plusb_net_stop(struct net_device *dev)
{
	plusb_t *s=dev->priv;
	
	dbg("plusb_net_stop");	
	
	plusb_free_all(s);
	s->opened=0;
	MOD_DEC_USE_COUNT;
	dbg("plusb_net_stop:finished");
	return 0;
}

/* --------------------------------------------------------------------- */

static struct net_device_stats *plusb_net_get_stats(struct net_device *dev)
{
	plusb_t *s=dev->priv;
	
	dbg("net_device_stats");
	
	return &s->net_stats;
}

/* --------------------------------------------------------------------- */

static plusb_t *plusb_find_struct (void)
{
	int u;

	for (u = 0; u < NRPLUSB; u++) {
		plusb_t *s = &plusb[u];
		if (!s->connected)
			return s;
	}
	return NULL;
}

/* --------------------------------------------------------------------- */

static void plusb_disconnect (struct usb_device *usbdev, void *ptr)
{
	plusb_t *s = ptr;

	dbg("plusb_disconnect");
	s->connected = 0;
	
	plusb_free_all(s);

	if(!s->opened && s->net_dev.name) {
		dbg("unregistering netdev: %s",s->net_dev.name);
		unregister_netdev(&s->net_dev);
		s->net_dev.name[0] = '\0';
	}
	
	dbg("plusb_disconnect: finished");
	MOD_DEC_USE_COUNT;
}

/* --------------------------------------------------------------------- */

int plusb_net_init(struct net_device *dev)
{
	plusb_t *s=dev->priv;

	dbg("plusb_net_init");
	
/* removed by C Flynn
	dev->flags = IFF_POINTOPOINT|IFF_NOARP;
*/

	/* CF added */
	dev->dev_addr[0] = 0x40;
	dev->dev_addr[1] = 0;
	dev->dev_addr[2] = 0;
	dev->dev_addr[3] = 0;
	dev->dev_addr[4] = 0xff;
	dev->dev_addr[5] = 1; /*usbd_info.address;*/
   
	/* we know the host mac address because it is derived from
	* the USB address.
	*/
	s->client_addr[0] = 0x40;
	s->client_addr[1] = 0;
	s->client_addr[2] = 0;
	s->client_addr[3] = 0;
	s->client_addr[4] = 0;
	s->client_addr[5] = 1;/*usbd_info.address;*/

	dev->open=plusb_net_open;
	dev->stop=plusb_net_stop;
	dev->hard_start_xmit=plusb_net_xmit;
	dev->get_stats	= plusb_net_get_stats;
	ether_setup(dev);
	/* CF??? check queue_len is after ether_setup */
	dev->tx_queue_len = 0;
	
	dbg("plusb_net_init: finished");
	return 0;
}

/* --------------------------------------------------------------------- */

static void *plusb_probe (struct usb_device *usbdev, unsigned int ifnum)
{
	plusb_t *s;
	int i;
	/* __u8 endpAddr; */
	unsigned char ep_dir = 0;			/* CF added */
	unsigned char ep_attr = 0;			/* CF added */
	struct usb_interface_descriptor *interface;	/* CF added */
	struct usb_endpoint_descriptor *endpoint;	/* CF added */

	dbg("plusb: probe: vendor id 0x%x, device id 0x%x ifnum:%d",
	  usbdev->descriptor.idVendor, usbdev->descriptor.idProduct, ifnum);

	if (usbdev->descriptor.idVendor != USB_VENDOR_COMPAQ || usbdev->descriptor.idProduct > PRODUCT_ID )
	{
		printk("Probe: Unknown device connected\n");
		return NULL;
	}

	/* We don't handle multiple configurations */
	if (usbdev->descriptor.bNumConfigurations != 1)
		return NULL;

	s = plusb_find_struct ();
	if (!s)
		return NULL;

	s->usbdev = usbdev;

	printk("usb_set_configuration:bConfigVal=%d\b",
		usbdev->config[0].bConfigurationValue);
	if (usb_set_configuration (s->usbdev, usbdev->config[0].bConfigurationValue) < 0) {
		err("set_configuration failed");
		return NULL;
	}

#if 0
	/* CF??? this fails */
	if (usb_set_interface (s->usbdev, 0, 0) < 0) {
		err("set_interface failed");
		return NULL;
	}
#endif

		
#if 0
	/* CF get endpoint info assumes only 1 read and write endpoint*/
       for (i=0; i < usbdev->config[0].interface[0].altsetting[0].bNumEndpoints;
            i++)
       {
          endpAddr=usbdev->config[0].interface[0].altsetting[0].endpoint[i].bEndpointAddress;
          switch (endpAddr)
          {
             case 0x01 :
                 /* this is out write endpoint */
                 writeendp = endpAddr;
                break;
             case 0x82 :
                readendp = endpAddr;
                break;
              default:
                  break;
          }
       }
#else

#if 0
/*
 * Endpoints from <linux/usb.h>
 */
#define USB_ENDPOINT_NUMBER_MASK        0x0f    /* in bEndpointAddress */
#define USB_ENDPOINT_DIR_MASK           0x80

#define USB_ENDPOINT_XFERTYPE_MASK      0x03    /* in bmAttributes */
#define USB_ENDPOINT_XFER_CONTROL       0
#define USB_ENDPOINT_XFER_ISOC          1
#define USB_ENDPOINT_XFER_BULK          2
#define USB_ENDPOINT_XFER_INT           3

#endif

	interface = &usbdev->actconfig->interface[ifnum].altsetting[0];
	for (i = 0; i < interface->bNumEndpoints; ++i)
	{
	    endpoint = &interface->endpoint[i];
	    ep_dir = endpoint->bEndpointAddress & USB_ENDPOINT_DIR_MASK;
	    ep_attr = endpoint->bmAttributes & USB_ENDPOINT_XFERTYPE_MASK;

	    switch( ep_attr )
	    {
		case USB_ENDPOINT_XFER_BULK:
		    if( ep_dir )
		    {
	        	dbg("IN:BULK\n");
	        	readendp = endpoint->bEndpointAddress;
					 /* USB_ENDPOINT_NUMBER_MASK; */
		    }
		    else
		    {
	        	dbg("OUT:BULK\n");
	        	writeendp = endpoint->bEndpointAddress;
					 /* USB_ENDPOINT_NUMBER_MASK; */
		    }
		    break;
		case USB_ENDPOINT_XFER_INT:
		    if( ep_dir )
		    {
	        	dbg("IN:INT\n");
	        	readendp = endpoint->bEndpointAddress;
			/* CF TEST */
		    }
		    else
		    {
	        	dbg("OUT:INT\n");
		    }
		    break;
		case USB_ENDPOINT_XFER_CONTROL:
		    if( ep_dir )
		    {
	        	dbg("IN:CONTROL\n");
		    }
		    else
		    {
	        	dbg("OUT:CONTROL\n");
		    }
		    break;
		case USB_ENDPOINT_XFER_ISOC:
		    if( ep_dir )
		    {
	        	dbg("IN:ISOC\n");
		    }
		    else
		    {
	        	dbg("OUT:ISOC\n");
		    }
		    break;
		default:
	        	dbg("WARNING unrecognised endpoint\n");
	    }
	
	    dbg(" endpoint address = %04x\n",endpoint->bEndpointAddress);
	    dbg("endpoint.wMaxPacketSize=%d\n",endpoint->wMaxPacketSize);

	}

#endif

	printk("writeendp=%08x readendp=%08x\n",writeendp,readendp);
	s->connected = 1;

	if(s->opened) {
		dbg("net device already allocated, restarting USB transfers");
		plusb_alloc(s);
	}

	info("bound to interface: %d dev: %p", ifnum, usbdev);

#if 1
	if(!s->net_dev.name[0]) {
		strcpy(s->net_dev.name, "nusb%d");
		printk("Chasbo: %s registered\n",s->net_dev.name);
		s->net_dev.init=plusb_net_init;
		s->net_dev.priv=s;
		if(!register_netdev(&s->net_dev))
			info("registered: %s", s->net_dev.name);
		else {
			err("register_netdev failed");
			s->net_dev.name[0] = '\0';
		}
	}
#endif
	MOD_INC_USE_COUNT;
	return s;
}
/* --------------------------------------------------------------------- */

static struct usb_driver plusb_driver =
{
	name: "plusb",
	probe: plusb_probe,
	disconnect: plusb_disconnect,
};

/* --------------------------------------------------------------------- */

int __init plusb_init (void)
{
	unsigned u;
	dbg("plusb_init");
	
	/* initialize struct */
	for (u = 0; u < NRPLUSB; u++) {
		plusb_t *s = &plusb[u];
		memset (s, 0, sizeof (plusb_t));
		s->bh.routine = (void (*)(void *))plusb_bh;
		s->bh.data = s;
		INIT_LIST_HEAD (&s->tx_skb_list);
		INIT_LIST_HEAD (&s->free_skb_list);
		spin_lock_init (&s->lock);
	}

	/* register misc device */
	usb_register (&plusb_driver);

	dbg("plusb_init: driver registered");

	return 0;
}

/* --------------------------------------------------------------------- */

void __exit plusb_cleanup (void)
{
	unsigned u;

	dbg("plusb_cleanup");
	for (u = 0; u < NRPLUSB; u++) {
		plusb_t *s = &plusb[u];
		if(s->net_dev.name[0]) {
			dbg("unregistering netdev: %s",s->net_dev.name);
			unregister_netdev(&s->net_dev);
		}
	}
	usb_deregister (&plusb_driver);
	dbg("plusb_cleanup: finished");
}

/* --------------------------------------------------------------------- */

#ifdef MODULE
MODULE_AUTHOR ("Deti Fliegl, deti@fliegl.de");
MODULE_DESCRIPTION ("PL-2302 USB Interface Driver for Linux (c)2000");

/* --------------------------------------------------------------------- */
/* int __init init_module (void) */
int init_module (void)
{
	return plusb_init ();
}
/* --------------------------------------------------------------------- */
void __exit cleanup_module (void)
{
	plusb_cleanup ();
}

#endif

/* --------------------------------------------------------------------- */
