/*
 * linux/include/asm-arm/arch-sa1100/dma.h
 *
 * SA1100 DMA routines
 *
 * Copyright (C) 2000 Nicolas Pitre
 *
 * NOTE: only request_dma() and free_dma() calls to the generic API are 
 *       supported ATM.
 */

#ifndef __ASM_ARCH_DMA_H
#define __ASM_ARCH_DMA_H

#include "hardware.h"


/*
 * This is the maximum DMA address that can be DMAd to.
 */
#define MAX_DMA_ADDRESS		0xffffffff


/*
 * The SA1100 has six internal DMA channels.
 */
#define MAX_DMA_CHANNELS	6


/*
 * All possible devices a DMA channel can be attached to.
 */
typedef enum {
	DMA_Ser0UDCWr  = DDAR_Ser0UDCWr,   /* Ser. port 0 UDC Write */
	DMA_Ser0UDCRd  = DDAR_Ser0UDCRd,   /* Ser. port 0 UDC Read */
	DMA_Ser1UARTWr = DDAR_Ser1UARTWr,  /* Ser. port 1 UART Write */
	DMA_Ser1UARTRd = DDAR_Ser1UARTRd,  /* Ser. port 1 UART Read */
	DMA_Ser1SDLCWr = DDAR_Ser1SDLCWr,  /* Ser. port 1 SDLC Write */
	DMA_Ser1SDLCRd = DDAR_Ser1SDLCRd,  /* Ser. port 1 SDLC Read */
	DMA_Ser2UARTWr = DDAR_Ser2UARTWr,  /* Ser. port 2 UART Write */
	DMA_Ser2UARTRd = DDAR_Ser2UARTRd,  /* Ser. port 2 UART Read */
	DMA_Ser2HSSPWr = DDAR_Ser2HSSPWr,  /* Ser. port 2 HSSP Write */
	DMA_Ser2HSSPRd = DDAR_Ser2HSSPRd,  /* Ser. port 2 HSSP Read */
	DMA_Ser3UARTWr = DDAR_Ser3UARTWr,  /* Ser. port 3 UART Write */
	DMA_Ser3UARTRd = DDAR_Ser3UARTRd,  /* Ser. port 3 UART Read */
	DMA_Ser4MCP0Wr = DDAR_Ser4MCP0Wr,  /* Ser. port 4 MCP 0 Write (audio) */
	DMA_Ser4MCP0Rd = DDAR_Ser4MCP0Rd,  /* Ser. port 4 MCP 0 Read (audio) */
	DMA_Ser4MCP1Wr = DDAR_Ser4MCP1Wr,  /* Ser. port 4 MCP 1 Write */
	DMA_Ser4MCP1Rd = DDAR_Ser4MCP1Rd,  /* Ser. port 4 MCP 1 Read */
	DMA_Ser4SSPWr  = DDAR_Ser4SSPWr,   /* Ser. port 4 SSP Write (16 bits) */
	DMA_Ser4SSPRd  = DDAR_Ser4SSPRd    /* Ser. port 4 SSP Read (16 bits) */
} dma_device_t;


typedef void (*dma_callback_t)( void *buf_id, int size );


int sa1100_request_dma(dmach_t *channel, const char *device_id);
int sa1100_dma_set_callback( dmach_t channel, dma_callback_t cb );
int sa1100_dma_set_device( dmach_t channel, dma_device_t device );
int sa1100_dma_set_spin( dmach_t channel, dma_addr_t addr, int size );
int sa1100_dma_queue_buffer( dmach_t channel, void *buf_id, 
			     dma_addr_t data, int size );
int sa1100_dma_flush_all( dmach_t channel );
void sa1100_free_dma(dmach_t channel);


#endif /* _ASM_ARCH_DMA_H */
