/*
 * Itsy console stuff
 * Copyright (c) Compaq Computer Corporation, 1998, 1999
 *
 * Author: Lawrence S. Brakmo
 *
 * $Log: itsy_console.h,v $
 * Revision 1.1  2000/09/01 12:43:29  jamey
 * added itsy params-program to boot linux 2.4.x
 *
 * Revision 1.1.1.2  2000/02/10 02:18:16  grunwald
 * *** empty log message ***
 *
 * Revision 2.4  2000/01/19  18:25:41  kerr
 * More copyright conformance.
 *
 * Revision 2.3  1999/12/23  01:28:25  kerr
 * Updated Copyright information for entire source tree.
 *
 * Revision 2.2  1999/10/09  02:59:50  brakmo
 * Added support for backlight (ioctl to turn on/off and fix colormap).
 *
 * Revision 2.1  1999/05/12 18:01:09  caw
 * Included changes from itsy_sessions branch.
 *
 * Revision 1.1.2.1  1999/04/21  01:23:40  brakmo
 * Renamed files from *brutus* into itsy_*. Added itsy_adc.h
 *
 *
 */

#ifndef itsy_console_h
#define itsy_console_h



#define FRAME_BUFFER_SECT_ADDR_NB 0xde000000 
#define FRAME_BUFFER_SECT_ADDR_B  (FRAME_BUFFER_SECT_ADDR_NB + (1<<PGDIR_SHIFT))

#define FRAME_BUFFER_ADDR FrameBuffer 	/* Can be anyplace in RAM */
					/* FrameBuffer defined in brutus.c*/
#define BITS_PER_PIXEL			4

#define SCREEN_SIZE_H 			320
#define FRAME_BUFFER_SIZE_H 		((((SCREEN_SIZE_H * BITS_PER_PIXEL)/8)+\
					  15)  & ~0xf)

#define SCREEN_SIZE_V 			200

#define FONT_CHAR_WIDTH_PIXELS 		8
#define FONT_CHAR_HEIGHT_PIXELS 	8
#define NUM_ROWS (SCREEN_SIZE_V / FONT_CHAR_HEIGHT_PIXELS)
#define NUM_COLS (SCREEN_SIZE_H / FONT_CHAR_WIDTH_PIXELS)

#define RESERVE_TOP_PIXEL_ROWS		0
#define RESERVE_BOTTOM_PIXEL_ROWS	24

#if BITS_PER_PIXEL==8
#define PALETTE_NUM_ENTRIES 		256	 
#define LINUX_WHITE_INDEX 		0xfc
#define LCD_PBS_PALETTE			(1<<12)
#else
#if BITS_PER_PIXEL==4
#define PALETTE_NUM_ENTRIES 		16
#define LINUX_WHITE_INDEX 		7
#define LCD_PBS_PALETTE			0
#else
#define PALETTE_NUM_ENTRIES		16
#define LINUX_WHITE_INDEX		0
#define LCD_PBS_PALETTE			(1<<13)
#endif
#endif

#define PALETTE_OFFSET (PALETTE_NUM_ENTRIES*sizeof(short))

/* Note: The frame buffer's address low for bits must be zero */
struct FrameBuffer {
  unsigned short palette [PALETTE_NUM_ENTRIES];
  unsigned char pixel[SCREEN_SIZE_V][FRAME_BUFFER_SIZE_H];
  unsigned char dummy[32]; /* Need extra 16 bytes at end of pixels for DMA overrun */
};

extern volatile struct FrameBuffer *FrameBuffer;   /*  cacheable,  bufferable */
extern volatile struct FrameBuffer *FrameBufferNB; /* !cacheable, !bufferable */
extern volatile struct FrameBuffer *FrameBufferB;  /* !cacheable */

extern volatile struct FrameBuffer *FrameBuffer2;
extern volatile struct FrameBuffer *FrameBuffer2B;
extern volatile struct FrameBuffer *FrameBuffer3;
extern volatile struct FrameBuffer *FrameBuffer3B;
extern volatile struct FrameBuffer *CurFrameBuffer;
extern volatile int CurFbn;
extern volatile int backlightFlag;

extern int FrameBufferSize;

#define LCD_STATE_OFF	  0
#define LCD_STATE_ON	  1
#define LCD_STATE_STATIC  2
/*
 * LCD_STATE_ON means the LCD is on with non-static image 
 * LCD_STATE_STATIC means the LCD is on with a static image (power saving state)
 * LCD_STATE_OFF means the LCD is off
 */

extern int LcdState;

#define IS_LCD_ON()     (LcdState == LCD_STATE_ON)
#define IS_LCD_OFF()    (LcdState == LCD_STATE_OFF)
#define IS_LCD_STATIC() (LcdState == LCD_STATE_STATIC)

void backlightFixColormap(volatile struct FrameBuffer *);
void lcdSwitchFB(struct FrameBuffer *, int);
void lcdOn(void);
void lcdStatic(int);


/*
 * Used in params.c
 *
 */
#define I_bytes_per_char_h 	((BITS_PER_PIXEL * FONT_CHAR_WIDTH_PIXELS)/8)
#define I_bytes_per_char_v	(FONT_CHAR_HEIGHT_PIXELS)
#define I_video_size_row 	((SCREEN_SIZE_H * BITS_PER_PIXEL)/8)
#define I_VIDMEM(addr) 		(((char *) addr) + PALETTE_OFFSET\
				 + RESERVE_TOP_PIXEL_ROWS * \
				 FRAME_BUFFER_SIZE_H)
#define I_video_num_cols	(SCREEN_SIZE_H / FONT_CHAR_WIDTH_PIXELS)
#define I_video_num_rows	((SCREEN_SIZE_V - RESERVE_TOP_PIXEL_ROWS - \
				  RESERVE_BOTTOM_PIXEL_ROWS) \
				  / FONT_CHAR_HEIGHT_PIXELS)



#endif
