/*
 * drivers/pcmcia/sa1100_graphicsclient.c
 *
 * PCMCIA implementation routines for Graphics Client Plus
 *
 */
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/delay.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/arch/pcmcia.h>

#define	S0_CD_IRQ		60				// Socket 0 Card Detect IRQ
#define	S0_STS_IRQ		55				// Socket 0 PCMCIA IRQ

static volatile unsigned long *PCMCIA_Status = 
		((volatile unsigned long *) ADS_p2v(_ADS_CS_STATUS));

static volatile unsigned long *PCMCIA_Power = 
		((volatile unsigned long *) ADS_p2v(_ADS_CS_PR));

static int gcplus_pcmcia_init(struct pcmcia_init *init)
{
  int irq, res;

  /* Enable CF bus: */
  if (!(*PCMCIA_Status & ADS_CS_PR_A_5V_POWER)) {
	  *PCMCIA_Status |= ADS_CS_PR_A_5V_POWER;
	  mdelay(300);		// 300 msec
  }

  *PCMCIA_Status &= ~ ADS_CS_PR_A_RESET;
  udelay(12);			// 12 usec

  *PCMCIA_Status |= ADS_CS_PR_A_RESET;
  mdelay(30);		// 30 msec

  mdelay(1500);			// 1500 msec
 
  // 7/13/00 Woojung
  // Must check PCMCIA is ready or not.
  
  /* Register interrupts */
  irq = S0_CD_IRQ;
  res = request_irq(irq, init->handler, SA_INTERRUPT, "PCMCIA 0 CD", NULL);
  if (res < 0) {
	  printk(KERN_ERR "%s: Request for IRQ %lu failed\n", __FUNCTION__, irq);
	  return	-1;
  }
  /*
  irq = S0_STS_IRQ;
  res = request_irq(irq, init->handler, SA_INTERRUPT, "PCMCIA 0 STS", NULL);
  if (res < 0) {
	  printk(KERN_ERR "%s: Request for IRQ %lu failed\n", __FUNCTION__, irq);
	  return	-1;
  }
  */

  return 1;			// 1 PCMCIA Slot
}

static int gcplus_pcmcia_shutdown(void)
{
  /* disable IRQs */
  free_irq( S0_STS_IRQ, NULL);
  free_irq( S0_CD_IRQ, NULL);
  
  /* Shutdown PCMCIA power */
  *PCMCIA_Power = ~0x03;
  mdelay(2);						// 2msec
  *PCMCIA_Power &= ~0x03;

  return 0;
}

static int gcplus_pcmcia_socket_state(struct pcmcia_state_array
				       *state_array){
  unsigned long levels;

  if(state_array->size<1) return -1;

  memset(state_array->state, 0, 
	 (state_array->size)*sizeof(struct pcmcia_state));

  levels=*PCMCIA_Status;

  state_array->state[0].detect=(levels & ADS_CS_ST_A_CD)?1:0;
  state_array->state[0].ready=(levels & ADS_CS_ST_A_READY)?1:0;
  state_array->state[0].bvd1= 0;
  state_array->state[0].bvd2= 0;
  state_array->state[0].wrprot=0;
  state_array->state[0].vs_3v=0;
  state_array->state[0].vs_Xv=0;

  return 1;
}

static int gcplus_pcmcia_get_irq_info(struct pcmcia_irq_info *info)
{
	if (info->sock > 1)
		return -1;

	if (info->sock == 0)
		info->irq = S0_STS_IRQ;

  	return 0;
}

static int gcplus_pcmcia_configure_socket(const struct pcmcia_configure
					   *configure)
{
  unsigned long flags;

  if(configure->sock>1) return -1;

  save_flags_cli(flags);

  switch (configure->vcc) {
  case 0:
    break;

  case 50:
	break;

  case 33:
    break;

  default:
    printk(KERN_ERR "%s(): unrecognized Vcc %u\n", __FUNCTION__,
	   configure->vcc);
    restore_flags(flags);
    return -1;
  }

  /* Silently ignore Vpp, output enable, speaker enable. */

  restore_flags(flags);

  return 0;
}

struct pcmcia_low_level gcplus_pcmcia_ops = { 
  gcplus_pcmcia_init,
  gcplus_pcmcia_shutdown,
  gcplus_pcmcia_socket_state,
  gcplus_pcmcia_get_irq_info,
  gcplus_pcmcia_configure_socket
};

