/*****************************************************************************/

/*
 *
 *	Copyright (C) Compaq Computer Corporation, 1998, 1999
 *
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*****************************************************************************/

#include <linux/kernel.h>
#include <linux/malloc.h>
#include <linux/skbuff.h>
#include <linux/interrupt.h>
#include <linux/netdevice.h>
#include <asm/io.h>
#include <asm/dma.h>
#include <asm/system.h>

#include "usbc_h3600_ctl.h"
#include "usbc_h3600_dbg.h"

#define DMA_IN_COUNT_MAX usbd_info.tx_pktsize
#define MAXIN_PACKET_SZ  usbd_info.tx_pktsize
#define TX_BUFFER_SIZE (4*PAGE_SIZE)	/* added by C Flynn */

/*
 * globals
 */
static int dmachn_tx=-1;
static int dmachn_tx_inuse = 0;
static int tx_size=0;

#ifdef TXTEST
static struct tq_struct tx_task;
#endif

#define TEST_PKT_SIZE	16384
static unsigned int send_len=0;
/* TODO there is only one send_skb so we must remember to release it 
	immediately after a packet has been submitted to the USB link
*/
static struct sk_buff *send_skb = NULL;
static char *send_page=NULL;
static char *send_txbuf=NULL;
static char *phys_start=NULL;	/* global base phys buf */
static char *phys_txbuf=NULL;	/* global variable phys buf */

extern unsigned int address;

/*
 * prototypes
void * _get_dma_address_sa1100(dmach_t channel);
 */
void set_dma_mode_sa1100(int channel, int addr);
int enable_dma_sa1100(dmach_t channel,void * ptr, unsigned size);
int disable_dma_sa1100 (dmach_t );
int get_dma_residue_sa1100(dmach_t channel);

#ifdef TXTEST
void ep2_tx_test_complete(void *data);	/* TXTEST REMOVE WHEN DONE */
#else
void ep2_complete_task(void *data);
#endif

/*
 * Initialise the DMA system to use the given chn for receiving
 * packets over endpoint 2.
 *
 * chn     : the dma channel to use.
 * returns : 0 if ok, -1 if channel couldn't be used.
 * TXTEST - this gets called direct from ep1_test_task()
 *		so we need to set send_len.
 * CF??? The caller of this function MUST check the return status.
 */
int 
ep2_init(int chn)
{
#ifdef TXTEST
    int i=0;
#endif

    dmachn_tx = chn;

    if (send_page == NULL)
    {
	dma_addr_t dmaphys = 0;
	send_page = (char *)consistent_alloc(GFP_KERNEL,
					TX_BUFFER_SIZE, &dmaphys);
	if( send_page )
	{
	    phys_start = phys_txbuf = (char *)dmaphys;	
	    send_txbuf=send_page;		/* CF added BUG? */
#ifdef TXTEST
	    /* TXTEST WARNING REMOVE WHEN DONE */
	    /*
		Note if send_len is a multiple of the pktsize
		you will not get the final irq when send_len
		decrements to zero, so make send_len % pktsize + 1
	    */
	    send_len = TEST_PKT_SIZE;	/* TXTEST REMOVE */
	    printk("TXTEST buffer setup>>>>%p>>>>>>>\n",phys_start);
	    for(i=0 ; i < send_len ; i++)
		phys_txbuf[i]=i;
#endif
	    phys_txbuf[0] = (unsigned char) (send_len & 0x00ff);
	    phys_txbuf[1] = (unsigned char) ( (send_len & 0xff00) >> 8);

        }
	else
	{
	    printk("PANIC CANT ALLOCATE TX BUFFER >>>>>>>>>>\n");
	    return -1;
	}
    }
    send_skb = NULL;	/* ep2_init */
    return 0;
}

/*
 * Setup the transmit DMA buffers with the first packet off the 
 * send queue, if the queue is empty, or if a DMA packet has already
 * been setup for send, this will not change the DMA setup.
 *
 */
void 
ep2_stop(void)
{
   disable_dma_sa1100(dmachn_tx);
}

/*
 * Setup the transmit DMA buffers with the first packet off the 
 * send queue, if the queue is empty, or if a DMA packet has already
 * been setup for send, this will not change the DMA setup.
 *
 * TXTEST
 * Initialise our alloced buffer :len:len:2:3:4:5:.......:len:
 * Call ep2_start directly from _open() entry point.
 * send_len is set by ep2_init() CF?? and must be removed.
 *
 */
int 
ep2_start(void)
{
    int idx = 0;
    int retval = -1;
    static unsigned int pktcnt= -1; /* when incremented for first time = 0*/
    
    ++pktcnt;
#ifdef TXTEST
    if ((dmachn_tx>=0) && !(dmachn_tx_inuse) )
#else
    if ((dmachn_tx>=0) && !(dmachn_tx_inuse) && (send_skb))
#endif
    {
        CHECK_ADDRESS;
	/*
		DMA is stopped. We are transmitting ('X'byte) packets
		until send_len becomes zero. We either
		(a)Kick start DMA for another packet or
		(b)queue our completion task when the packet has been sent.
		The completion task is really a callback function which
			is called when all of our 'send_len' bytes have
			been transmitted.
	*/
        if (send_len == 0)
        {
	    /* send_len has been decremented to zero meaning our packet 
		has been sent.Now schedule the completion task ep2_complete_task
		WARNING only works if (send_len % pktsize) = 0
	    */
#ifdef TXTEST
            if (tx_task.sync == 0)
            {
                tx_task.next = NULL;
                tx_task.sync = 0;
                tx_task.routine =  ep2_tx_test_complete;
                tx_task.data = (void *) NULL;
                queue_task(&tx_task, &tq_scheduler);
		/*
		Remove the need for a complete task except in test TODO TODO 
                tx_task.routine =  ep2_complete_task;
		*/
                retval = 0;
            }
            else
            {
                printk("USB Send : Start.. not sending\n");
            }
#else
	    /* just copy ep2_complete_task to here */
            struct net_device *dev = send_skb->dev;

            usbd_info.eth_stats.tx_packets++;
            dev_kfree_skb_any(send_skb);
            send_skb = NULL;

            if (netif_queue_stopped(dev))	/* ep2_start */
                netif_wake_queue(dev);
	    retval=0;
#endif
        }
        else
        {
	    /* Kick start the DMA to send another packet */
            /* setup DMA so the packet will be sent. */
            if (usbd_info.tx_pktsize <= send_len)
            {
                tx_size = usbd_info.tx_pktsize;
            }
            else
            {
                tx_size = send_len;
            }
            /* must tell both the UDC system and the dma system
             * how much to transfer.
             */
            do 
            {
                idx++;
                *(UDCIMP) = (unsigned int) (tx_size-1);
            } while ((*(UDCIMP) != (unsigned int) (tx_size-1)) &&
                     (idx < 1000));
	    if( idx >= 1000 ) printk("EP2_START unable to set UDCIMP");

	    /*
	     TODO check status from enable_dma_sa1100
	    * These printks are OK for send_len < 64
	    */
	    
#if 0
	    printk("PKT %d SIZE=%d LEFT=%d PHYSP=%p \n",
			pktcnt,tx_size,(send_len-tx_size),phys_txbuf);
	    for(idx=0 ; idx < 8 ; idx++)
		printk("%02x:",phys_txbuf[idx]);
#endif

	    /* Do this before dma is started */
#if 0
	    printk("\nDMA residue=%d PHYS_TXBUF=%p\n",
		get_dma_residue_sa1100( dmachn_tx ),
		get_dma_address_sa1100( dmachn_tx ) );
#endif

            enable_dma_sa1100(dmachn_tx, phys_txbuf,tx_size);
            dmachn_tx_inuse = 1;

	    if( pktcnt )
	    {
	    /* Update the pointers */
            send_txbuf += tx_size;
            phys_txbuf += tx_size;
            send_len = send_len - tx_size;
	    }


            retval = 0;
        }
    }
    else
    {
	printk("\nWARNING dmachn_tx is IN use\n");
    }
    CHECK_ADDRESS;
    return retval;
}

/*
 * reset any txpkts, it will be up to the client driver to free up the send
 * queue.
 */
void
ep2_reset(void)
{
    CHECK_ADDRESS;
    printk("RESET\n");
    if (dmachn_tx >= 0)
    {
        disable_dma_sa1100(dmachn_tx);
        /* reset dma */
        set_dma_mode_sa1100(dmachn_tx, 0);
        set_dma_mode_sa1100(dmachn_tx, DMA_UDC_TRANSMIT);
    }

    /* stall and unstall */
    do
    {
        *(UDCCS2) |= UDCCS2_FST;
    } while (!(*(UDCCS2) & UDCCS2_FST));
    do
    {
        *(UDCCS2) &= ~UDCCS2_FST;
    } while (*(UDCCS2) & UDCCS2_FST);

    
    /* clear the tx list */
    if (send_skb)
    {
#if 0	/* old */
	send_skb->dev->tbusy = 0;
#else	/* new */
	netif_start_queue(send_skb->dev);    /* ep2_reset */	
#endif
        dev_kfree_skb(send_skb/*, FREE_WRITE*/);
        send_skb = NULL;	/* ep2_reset */
        send_txbuf = send_page;
        phys_txbuf = phys_start;
    }

    dmachn_tx_inuse = 0;
    
/*	
    TODO TODO 
    if (usbd_info.dev->tbusy == 1)
    {
        printk("reset still tbusy\n");
        usbd_info.dev->tbusy = 0;
        mark_bh(NET_BH);
     }
*/

}

void
ep2_int_hndlr(unsigned int status)
{
    unsigned int ep2_status;
    int idx;

    CHECK_ADDRESS;
    if (*(UDCAR) > 100)
    {
	printk("UDCAR = %02x:",usbd_info.address);
        *(UDCAR) = usbd_info.address;
    }
    
    ep2_status = *(UDCCS2);
    /* printk("EP2S:%08x:",ep2_status); */

    if (dmachn_tx>=0)
    {
        if (ep2_status & UDCCS2_TPC)
        {
            disable_dma_sa1100(dmachn_tx);
            /* must have a completed transfer */ 
        }
        else
        {
            printk("ERROR: TPC not set %x\n", ep2_status);
        }

        usbd_info.usb_stats.inpkts++;

	/* Clear the TCP bit the usual way */
        idx = 0;
        do
        {
            idx++;
            *(UDCCS2) |= UDCCS2_TPC;
        } while ((*(UDCCS2) & UDCCS2_TPC) && (idx<10000));
        if (idx >= 10000) printk("USB Send : loop overrun\n");

        /* enable DMA if an error occurred. */
        if (ep2_status & (UDCCS2_TPE | UDCCS2_TUR | UDCCS2_SST))
        {
            /* circumventing ep2_start, don't worry about
             * dmachn_tx_inuse
	     * This sends the previous packet.
             */
	    void * tx_ptr = phys_txbuf-tx_size;
            printk("USB Send : Transmit error %x\n", ep2_status);
	    /*
            set_dma_addr(dmachn_tx, 
                         virt_to_phys((void *) (send_txbuf-tx_size)));
	    */
            do 
            {
                idx++;
                *(UDCIMP) = (unsigned int) (tx_size-1);
            } while ((*(UDCIMP) != (unsigned int) (tx_size-1)) &&
                     (idx < 1000));
	    /*
	    TODO check status from enable_dma_sa1100()
            set_dma_count(dmachn_tx, tx_size);
            enable_dma(dmachn_tx);
	    */
            enable_dma_sa1100(dmachn_tx, tx_ptr,tx_size);
        }
        else
        {
            if (ep2_status & (UDCCS2_TPC))
            {
                /* no errors, schedule the control to free the packet
                 * at a later time.
                 */
                dmachn_tx_inuse = 0;
                ep2_start();
            }
        }
    }
    else
    {
        printk("USB Send : interrupt before initialised %x\n", ep2_status);
    }    
    CHECK_ADDRESS;
}
/* TXTEST - does nothing */
void
ep2_tx_test_complete(void *data)
{
    static int counter=0;	/* packet counter */
    printk("\n[%d]TXOK %d\n",counter,TEST_PKT_SIZE);
    send_len = TEST_PKT_SIZE;
    /* Need to do this since we dont have wrap round buffers */
    phys_txbuf = phys_start;
    ++counter;
    ep2_start();	/* kick off anothe packet ping */
}

#if 0
/* 
 * called after a block has been transmitted, will call the blocks
 * asynchronous callback function at schedule time rather than interrupt
 * time....
 */
void
ep2_complete_task(void *data)
{
    struct net_device *dev;

    /* DEBUG_KPrint(DEBUG_SEND, ("ep2_complete_task %p\n", send_skb)); */

    CHECK_ADDRESS;
    /* ensure block is finished... */
    if ((send_skb) && (send_len == 0))
    {
	dev = send_skb->dev;

        /* a transmission is over, tell we are no longer busy */
        usbd_info.eth_stats.tx_packets++;
        dev_kfree_skb(send_skb/*, FREE_WRITE*/);
        send_skb = NULL;

#if 0	/* old */
	send_skb->dev->tbusy = 0;
	mark_bh(NET_BH);
#else	/* new */
	netif_start_queue(send_skb->dev); /* ep2_complete */	
	if (netif_queue_stopped(dev))
	    netif_wake_queue(dev);
#endif

    }
    else
    {
	printk("WARNING: send_skb = %p send_len=%d\n",send_skb,send_len);
    }
}
#endif

/*
 * send a block across the bus.
 * Called by network layer (usbc_h3600_eth.c)
 */
int
usb_transmit_skb(struct sk_buff *skb)
{    
    int status = -1;
    struct net_device *dev = skb->dev;

    CHECK_ADDRESS;
    
    /* the block must have a buffer, length, and callback */
    if (send_skb == NULL)
    {
	netif_stop_queue(dev);
        send_skb = skb;
        /* copy the buffer into the send page...
         * I can't corrupt the actual skb because
         * it is used after I am finished with it, so I make
         * a copy.
         */
        send_len = send_skb->len-10;
        if (send_len > PAGE_SIZE)
        {
            printk("copying more than a page ...\n");
        }
	/* This is copying the skb data field starting at skb.data[10]
	   TODO remove this magic number and associate it with Ethel Allen
	   TODO #define USB_PRUNE (ETH_ALEN *2 ) - 2;
	   TODO Strip the Ethernet Src & Dest fields but leave room for the
	   TODO USB length field (2-octets)
	*/
        memcpy(send_page, (send_skb->data+10), send_len);
        send_txbuf = send_page;
        phys_txbuf = phys_start;

	/*Insert the USB packet length so it can be decoded by the receiver
	  Actually the host doesn't need it. It is used ONLY by the iPAQ
	  receive code.
	*/
        send_page[0] = (char) (send_len & 0x00ff);
        send_page[1] = (char) ((send_len & 0xff00) >> 8) ;

#if 0
	/* ------- print the 1st 34 bytes of raw TX packet ---------- */
	{
	unsigned int i,txlen;
	printk("TX:[%d]",send_len);
	txlen = (send_len > 20 ) ? 20 : send_len;
	for(i=0 ; i < txlen ; i++)
		printk("%02x:",(unsigned char)send_page[i]);
	}
	/* ------- print the raw packet ---------- */
#endif

        /* if the packet is aligned on a 256 byte boundary then send
         * an extra byte so the host doesn't stall.
	 * TODO TODO what is this 256 got to do with stalling?
         */
        if ((send_len % 256) == 0)
        {
            /* this doesn't work because the skb has been
             * allocated for the exact length. Doesn't matter
             * what I send though..
             */
            DEBUG_KPrint(DEBUG_SEND, ("256 byte aligned send.\n"));
            send_len++;
        }
            
        /* flush the cache of the transmit page. */
/*        processor.u.armv3v4._flush_cache_area((unsigned int) send_page,
          PAGE_SIZE, 0);*/
	/* CF start the DMA transfer */
	/* flush_cache_all(); */	 /* TODO TODO is this correct?*/
        status = ep2_start();
    }
    else
    {
	printk("WARNING: send_skb == NULL\n");
#if 0
	/* dump some bytes of raw data from skb*/
	{
		unsigned char * ptr = skb->data;
		unsigned int len,i;
	  	/* remember IP=20 followed by 8byte ICMP if ping */
		len = (skb->len > 34 ) ? 34 : skb->len;
		printk("SKB[%d]",skb->len);
		for(i=0; i < len ; i++)
		    printk("%02x:",*(ptr+i) );
		printk("\n");
	}
	/* dump the raw data */
#endif

    }

    if (status < 0)
    {
        printk("ERROR: from ep2_start\n");
#if 0	/* old */
	skb->dev->tbusy = 0;
	/* new  TODO TODO do we need a netif_start_queue here? */
	netif_start_queue(skb->dev);	
#endif
        dev_kfree_skb(skb/*, FREE_WRITE*/);
#if 0	/* old */
        mark_bh(NET_BH);
#else
	if (netif_queue_stopped(dev))
	    netif_wake_queue(dev);
#endif

    }
    return status;
}



