
#include "mq2hw.h"

/* new mq200 register dump for 640x480-256 color */
/* Power Management registers(0000)(20) */
#define MQ_PM_COUNT 8
unsigned long MQ_PM[]={ 0x00000904, 0x05000271, 0x00000271, 0x00000271, 
                        0x00000271, 0x00000271, 0x00A30930, 0x00000000}; 
unsigned long MQ_PM_MASK[] = {0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
							  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff};

/* Memory Controller registers(4000)(14) */
unsigned long MQ_MM[]={ 0x6D6AABFB, 0x4143E086, 0x6D6AABFF, 0x6D6AABFF, 
    0x6D60010D};

/* Graphics Controller 1 registers(a000)(40) */
/* HW cursor bit off and registers about HW cursors are not skipped */
#define MQ_GC1_COUNT 0x40
unsigned long MQ_GC1[]={ 0x01020039, 0x00000B01, 0x0280031E, 0x01DF020C, 
                         0x02F00290, 0x01EC01EA, 0x01EC01EA, 0x01EC0065, 
                         0x027F0000, 0x01DF0000, 0x84000800, 0x80010000, 
                         0x80000000, 0x00008800, 0x00000280, 0x00000280};
unsigned long MQ_GC1_MASK[] = {0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                        0xffffffff, 0xffffffff, 0, 0,
                        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                        0xffffffff, 0xffffffff, 0xffffffff, 0};


/* Graphics Controller 2 registers(a080)(40) */
#define MQ_GC2_COUNT 0x40
unsigned long MQ_GC2[]={ 0x00000000, 0x00000000, 0x00000400, 0x00000104,
                         0x04400000, 0x09080100, 0x09080100, 0x09080000,
                         0x00010002, 0x02800040, 0x00000814, 0x00190000,
                         0x00000000, 0x00022000, 0x00000280, 0x00000280};
unsigned long MQ_GC2_MASK[] = {0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                        0xffffffff, 0xffffffff, 0, 0,
                        0xffffffff, 0xffffffff, 0xffffffff, 0xfffffff,
                        0xffffffff, 0xffffffff, 0xffffffff, 0xfffffff};



/* Flat Panel Controller registers(E000)(DC) */
#define MQ_FPC_COUNT  0xdc
unsigned long MQ_FPC[]={0x00434365, 0x000400A0, 0x00000000, 0x07000000,
                        0x00BD0000, 0x00000004, 0x00000004, 0x00000004,
                        0x00000004, 0x00000004, 0x00000004, 0x00000004, 
                        0x00000004, 0x00000004, 0x00000004, 0x00005CA1, 
                        0x97A4C5F8, 0x61E3DB02, 0xD3E081BC, 0x25A79F46, 
                        0x4A791825, 0xBC3E06DF, 0x0E3D5C61, 0xF87A429B, 
                        0xF1C2A39E, 0x0785BD64, 0xB586E7DA, 0x43C1F920, 
                        0x2C1F7E43, 0xDA5860B9, 0x685B3A07, 0x9E1C24FD, 
                        0xE0D3B28F, 0x1694AC75, 0xA497F6CB, 0x52D0E831, 
                        0x3D0E6F52, 0xCB4971A8, 0x794A2B16, 0x8F0D35EC, 
                        0x86B5D4E9, 0x70F2CA13, 0xC2F190AD, 0x34B68E57, 
                        0x5B680934, 0xAD2F17CE, 0x1F2C4D70, 0xE96B538A, 
                        0x80800000, 0x88888420, 0x94A49248, 0xAAAAAA54, 
                        0x6B5B55AB, 0x77776DB7, 0x7F7F7BDF};

/* Color Pallette registers(10000)(400) */
#define MQ_CP_COUNT 0x400
unsigned long MQ_CP[]={                       
0xFF000000, 0xFFFFFFFF, 0xFF906335, 0xFFD9D8D5, 
0xFFC00000, 0xFF585858, 0xFF58A8FF, 0xFFFF0000, 
0xFFA4A0A0, 0xFFA8DCFF, 0xFFB4B3B0, 0xFF6C6B6A, 
0xFF808080, 0xFF0000FF, 0xFFC8C8C8, 0xFF00FFFF, 
0xFFC0C0C0, 0xFFDCFFFF, 0xFF7F7F7F, 0xFFFF7F7F, 
0xFF00C000, 0xFF808000, 0xFF7FFF7F, 0xFFFFFF7F, 
0xFF7F7FFF, 0xFFFF7FFF, 0xFF7FFFFF, 0xFF007F00, 
0xFFC0C000, 0xFF00FF00, 0xFF008000, 0xFF404000, 
0xFF004000, 0xFF800000, 0xFFC0FFC0, 0xFF303030, 
0xFFDCDCDC, 0xFF2B0000, 0xFF560000, 0xFF007FFF, 
0xFF7F7F00, 0xFF7F007F, 0xFF007F7F, 0xFF7F0000, 
0xFF00007F, 0xFF00C0C0, 0xFF0000C0, 0xFFC0FFFF, 
0xFFC0C0FF, 0xFF0080FF, 0xFF000080, 0xFF008080, 
0xFFFFC0C0, 0xFFFFFF00, 0xFF0058C0, 0xFFFFFFC0, 
0xFFF9F8F4, 0xFF7FFF00, 0xFF7F00FF, 0xFF00FF7F, 
0xFF003333, 0xFFFF6666, 0xFF66FF66, 0xFFFFFF66, 
0xFF6666FF, 0xFFFF66FF, 0xFF66FFFF, 0xFF333300, 
0xFF000033, 0xFF004040, 0xFFFF00FF, 0xFF0099FF, 
0xFF666666, 0xFFCC9966, 0xFFCC9999, 0xFF999999, 
0xFF996666, 0xFFCCCCCC, 0xFF999966, 0xFFCCCC99, 
0xFF330099, 0xFF6666CC, 0xFF3333CC, 0xFF9999CC, 
0xFF663366, 0xFFCCCCFF, 0xFF3300CC, 0xFF330066, 
0xFF6633CC, 0xFFFFFFCC, 0xFF333399, 0xFFFFCCFF, 
0xFF9966CC, 0xFFCCCC00, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000};

/* Device Configuration (14000) (8) */
unsigned long MQ_DC[]= {0x0EF2082A, 0x00000020};

/* PCI Configuration (16000) (44) */
unsigned long MQ_PCI[]={ 0x02004D51, 0x02800002, 0x03800002, 0x00000000, 
 0xF0C00000, 0xF0800000, 0x00000000, 0x00000000, 
 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
 0x00000000, 0x00000040, 0x00000000, 0x0000010A, 
 0x06210001};

/* currently, we just assign a specific base address(should read from PCI conf*/
#define MQ_PM_BASE  0x0000
#define MQ_GC1_BASE 0xa000
#define MQ_GC2_BASE 0xa080
#define MQ_FPC_BASE 0xe000
#define MQ_CP_BASE  0x10000

void my_setmq_pm(void)
{
  int i;

  for (i=0; i<(MQ_PM_COUNT/4); i++)
  if (MQ_PM_MASK[i])
    REG32((MQ_PM_BASE+i*4), (MQ_PM[i] & MQ_PM_MASK[i])
						| (READ32(MQ_PM_BASE+i) & (~MQ_GC1_MASK[i])));
}

void my_setmq_gc1(void)
{
  int i;

  for (i=0; i<(MQ_GC1_COUNT/4); i++)
  if (MQ_GC1_MASK[i])
    REG32((MQ_GC1_BASE+i*4), (MQ_GC1[i] & MQ_GC1_MASK[i])
                         | (READ32(MQ_GC1_BASE+i) & (~MQ_GC1_MASK[i])));

}
void my_setmq_gc2(void)
{
  int i;

  for (i=0; i<(MQ_GC2_COUNT/4); i++)
  if (MQ_GC2_MASK[i])
    REG32((MQ_GC2_BASE+i*4), (MQ_GC2[i] & MQ_GC2_MASK[i])
                         | (READ32(MQ_GC2_BASE+i) & (~MQ_GC2_MASK[i])));

}
void my_setmq_fpc(void)
{
  int i;

  for (i=0; i<(MQ_FPC_COUNT/4); i++)
    REG32((MQ_FPC_BASE+i*4), (MQ_FPC[i]));

}
void my_setmq_cp(void)
{
  int i;

  for (i=0; i<(MQ_CP_COUNT/4); i++)
    REG32((MQ_CP_BASE+i*4), (MQ_CP[i]));

}
