/*
 *  linux/include/asm-arm/arch-integrator/io.h
 *
 *  Copyright (C) 1999 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARM_ARCH_IO_H
#define __ASM_ARM_ARCH_IO_H

#define IO_SPACE_LIMIT 0xffff

#define __io_pci(a)		(PCI_IO_VADDR + (a))
#define __mem_pci(a)		((unsigned long)(a))
#define __mem_isa(a)		(PCI_MEMORY_VADDR + (unsigned long)(a))

#define __arch_getb(a)		(*(volatile unsigned char *)(a))
#define __arch_getl(a)		(*(volatile unsigned int  *)(a))

extern __inline__ unsigned int __arch_getw(unsigned long a)
{
	unsigned int value;
	__asm__ __volatile__("ldr%?h	%0, [%1, #0]	@ getw"
		: "=r" (value)
		: "r" (a));
	return value;
}

#define __arch_putb(v,a)	(*(volatile unsigned char *)(a) = (v))
#define __arch_putl(v,a)	(*(volatile unsigned int  *)(a) = (v))

extern __inline__ void __arch_putw(unsigned int value, unsigned long a)
{
	__asm__ __volatile__("str%?h	%0, [%1, #0]	@ getw"
		: : "r" (value), "r" (a));
}

#define inb(p)			__arch_getb(__io_pci(p))
#define inw(p)			__arch_getw(__io_pci(p))
#define inl(p)			__arch_getl(__io_pci(p))

#define outb(v,p)		__arch_putb(v,__io_pci(p))
#define outw(v,p)		__arch_putw(v,__io_pci(p))
#define outl(v,p)		__arch_putl(v,__io_pci(p))

/*
 * ioremap support - validate a PCI memory address, and convert it
 * to a physical address for the page tables.
 */
#define valid_ioaddr(iomem,size) ((iomem) < 0x80000000 && (iomem) + (size) <= 0x80000000)
#define io_to_phys(iomem)	((iomem) + PCI_MEMORY_VADDR)

/*
 * ioremap takes a PCI memory address, as specified in
 * linux/Documentation/IO-mapping.txt
 */
#define __arch_ioremap(off,size,nocache)			\
({								\
	unsigned long _off = (off), _size = (size);		\
	void *_ret = (void *)0;					\
	if (valid_ioaddr(_off, _size))				\
		_ret = __ioremap(io_to_phys(_off), _size, 0);	\
	_ret;							\
})

#endif
