/*
*
* Driver for H3600 Extension Packs
*
* Copyright 2000 Compaq Computer Corporation.
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author: Jamey Hicks.
*
*/
#ifndef _INCLUDE_H3600_SLEEVE_H_
#define _INCLUDE_H3600_SLEEVE_H_


enum sleeve_vendor {
        SLEEVE_NO_VENDOR = 0,
        COMPAQ_VENDOR_ID = 0x1125,
        CRL_VENDOR_ID = 0xFFFF,
        SLEEVE_ANY_ID = -1,
};

enum sleeve_device {
        SLEEVE_NO_DEVICE = 0,
        SINGLE_COMPACTFLASH_SLEEVE = 0xCF11,
        SINGLE_PCMCIA_SLEEVE = 0xD7C3,
        MERCURY_BACKPAQ = 0xFFFF,
};

struct sleeve_device_id {
	unsigned int vendor, device;		/* Vendor and device ID or SLEEVE_ANY_ID */
	unsigned int subvendor, subdevice;	/* Subsystem ID's or SLEEVE_ANY_ID */
	unsigned long driver_data;		/* Data private to the driver */
};

struct sleeve_driver;
struct sleeve_dev {
	struct sleeve_driver *driver;	/* which driver has allocated this device */
	struct proc_dir_entry *procent;	/* device entry in /proc/bus/sleeve */
	unsigned short	vendor;
	unsigned short	device;
	unsigned short	subsystem_vendor;
	unsigned short	subsystem_device;
	void		*driver_data;	/* data private to the driver */
	char		name[80];	/* device name */
};

struct sleeve_driver {
   struct list_head node;
   char *name;
   const struct sleeve_device_id *id_table;     /* NULL if wants all devices */
   int (*probe)(struct sleeve_dev *dev, const struct sleeve_device_id *did);  /* New device inserted */
   void (*remove)(struct sleeve_dev *dev);
   void (*suspend)(struct sleeve_dev *dev);
   void (*resume)(struct sleeve_dev *dev);
};

int h3600_sleeve_register_driver(struct sleeve_driver *drv);
void h3600_sleeve_unregister_driver(struct sleeve_driver *drv);

#endif /* _INCLUDE_H3600_SLEEVE_H_ */
