#ifndef __SA1100_FRONTLIGHT_H
#define __SA1100_FRONTLIGHT_H

/*************************************************************
 *  IOCTL calls for fronlight driver
 *
 *    _SA1100_FL_IOCTL_ON:  enables the frontlight (ignores arg)
 *    _SA1100_FL_IOCTL_OFF: disables the frontlight (ignores arg)
 *    _SA1100_FL_IOCTL_INTENSITY:  sets the intensity where the
 *      argument is a value between 0..100  (see sa1100_fl_setintenisty)
 *
 *************************************************************/

#define _SA1100_FL_IOCTL_ON		1
#define _SA1100_FL_IOCTL_OFF		2
#define _SA1100_FL_IOCTL_INTENSITY	3


/*************************************************************
 * Set the intensity for the frontlight, any value between 0..100
 */

int sa1100_fl_setintensity(int intensity); 

/*************************************************************
 * Turn on the frontlight
 */

int sa1100_fl_enable(void);

/*************************************************************
 * Turn off the frontlight
 */

int sa1100_fl_disable(void);

#endif /*  __SA1100_FRONTLIGHT_H  */
