/*
 * drivers/pcmcia/sa1100_backpaq.c
 *
 * PCMCIA implementation routines for Compaq CRL Mercury BackPAQ
 *
 */
#include <linux/config.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/sched.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/arch/pcmcia.h>
#include <asm/arch/h3600-sleeve.h>

extern void sa1100_bitsy_change_sleeves(int);
static int __devinit cf_probe_sleeve(struct sleeve_dev *sleeve_dev, const struct sleeve_device_id *ent)
{
        sprintf(sleeve_dev->name, "CompactFlash Sleeve");
        printk(__FUNCTION__ ": dev->name=%s\n", sleeve_dev->name);
        sa1100_bitsy_change_sleeves(SINGLE_COMPACTFLASH_SLEEVE);
        return 0;
}

static void __devexit cf_remove_sleeve(struct sleeve_dev *sleeve_dev)
{
        printk(__FUNCTION__ ": dev->name=%s\n", sleeve_dev->driver->name);
        sa1100_bitsy_change_sleeves(SLEEVE_NO_DEVICE);
}

static struct sleeve_device_id cf_tbl[] __devinitdata = {
        { COMPAQ_VENDOR_ID, SINGLE_COMPACTFLASH_SLEEVE, 0, 0, 0 },
        { 0, }
};

static struct sleeve_driver cf_driver = {
        name:   "Compaq Compact Flash Sleeve",
        id_table: cf_tbl,
        probe: cf_probe_sleeve,
        remove: cf_remove_sleeve,
};

static int __devinit pcmcia_probe_sleeve(struct sleeve_dev *sleeve_dev, const struct sleeve_device_id *ent)
{
        sprintf(sleeve_dev->name, "PC Card Sleeve");
        printk(__FUNCTION__ ": dev->name=%s\n", sleeve_dev->name);
        sa1100_bitsy_change_sleeves(SINGLE_PCMCIA_SLEEVE);
        return 0;
}

static void __devexit pcmcia_remove_sleeve(struct sleeve_dev *sleeve_dev)
{
        printk(__FUNCTION__ ": dev->name=%s\n", sleeve_dev->name);
        sa1100_bitsy_change_sleeves(SLEEVE_NO_DEVICE);
}

static struct sleeve_device_id pcmcia_tbl[] __devinitdata = {
        { COMPAQ_VENDOR_ID, SINGLE_PCMCIA_SLEEVE, 0, 0, 0 },
        { 0, }
};

static struct sleeve_driver pcmcia_driver = {
        name:   "Compaq PC Card Sleeve",
        id_table: pcmcia_tbl,
        probe: pcmcia_probe_sleeve,
        remove: pcmcia_remove_sleeve,
};

static int __devinit backpaq_probe_sleeve(struct sleeve_dev *sleeve_dev, const struct sleeve_device_id *ent)
{
        sprintf(sleeve_dev->name, "Compaq Mercury Backpaq");
        printk(__FUNCTION__ ": dev->name=%s\n", sleeve_dev->name);
        sa1100_bitsy_change_sleeves(MERCURY_BACKPAQ);
        return 0;
}

static void __devexit backpaq_remove_sleeve(struct sleeve_dev *sleeve_dev)
{
        printk(__FUNCTION__ ": dev->name=%s\n", sleeve_dev->name);
        sa1100_bitsy_change_sleeves(SLEEVE_NO_DEVICE);
}

static struct sleeve_device_id backpaq_tbl[] __devinitdata = {
        { SLEEVE_ANY_ID, MERCURY_BACKPAQ, 0, 0, 0 },
        { 0, }
};

static struct sleeve_driver backpaq_driver = {
        name:   "Compaq Mercury Backpaq",
        id_table: backpaq_tbl,
        probe: backpaq_probe_sleeve,
        remove: backpaq_remove_sleeve,
};

int __init backpaq_init_module(void)
{
        h3600_sleeve_register_driver(&cf_driver);
        h3600_sleeve_register_driver(&pcmcia_driver);
        h3600_sleeve_register_driver(&backpaq_driver);
	return 0;
}

void backpaq_cleanup_module(void)
{
	printk(__FUNCTION__ ":\n");
        h3600_sleeve_unregister_driver(&cf_driver);
        h3600_sleeve_unregister_driver(&pcmcia_driver);
        h3600_sleeve_unregister_driver(&backpaq_driver);
}

module_init(backpaq_init_module);
module_exit(backpaq_cleanup_module);

