/*
 *  linux/include/asm-arm/arch-clps711x/irq.h
 *
 *  Copyright (C) 2000 Deep Blue Solutions Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <asm/hardware.h>

static void mask_irq_int1(unsigned int irq)
{
	INTMR1 &= ~(1 << irq);
}

static void mask_ack_irq_int1(unsigned int irq)
{
	INTMR1 &= ~(1 << irq);

	switch (irq) {
	case IRQ_CSINT:  COEOI  = 0; break;
	case IRQ_TC1OI:  TC1EOI = 0; break;
	case IRQ_TC2OI:  TC2EOI = 0; break;
	case IRQ_RTCMI:  RTCEOI = 0; break;
	case IRQ_TINT:   TEOI   = 0; break;
	case IRQ_UMSINT: UMSEOI = 0; break;
	case IRQ_SSEOTI: SYNCIO = 0; break;
	}
}

static void unmask_irq_int1(unsigned int irq)
{
	INTMR1 |= 1 << irq;
}

static void mask_irq_int2(unsigned int irq)
{
	INTMR2 &= ~(1 << (irq - 16));
}

static void mask_ack_irq_int2(unsigned int irq)
{
	INTMR2 &= ~(1 << (irq - 16));

	switch (irq) {
	case IRQ_KBDINT: KBDEOI = 0; break;
	}
}

static void unmask_irq_int2(unsigned int irq)
{
	INTMR2 |= 1 << (irq - 16);
}

static __inline__ void irq_init_irq(void)
{
	unsigned int i;

	for (i = 0; i < NR_IRQS; i++) {
	        if (INT1_IRQS & (1 << i)) {
		        irq_desc[i].valid	= 1;
			irq_desc[i].probe_ok	= 1;
			irq_desc[i].mask_ack	= (INT1_ACK_IRQS & (1 << i)) ?
						   mask_ack_irq_int1 :
						   mask_irq_int1;
			irq_desc[i].mask	= mask_irq_int1;
			irq_desc[i].unmask	= unmask_irq_int1;
		}
		if (INT2_IRQS & (1 << i)) {
		        irq_desc[i].valid	= 1;
			irq_desc[i].probe_ok	= 1;
			irq_desc[i].mask_ack	= (INT2_ACK_IRQS & (1 << i)) ?
						   mask_ack_irq_int2 :
						   mask_irq_int2;
			irq_desc[i].mask	= mask_irq_int2;
			irq_desc[i].unmask	= unmask_irq_int2;
		}			
	}

	/*
	 * Disable interrupts
	 */
	INTMR1 = INTMR2 = 0;

	/*
	 * Clear down any pending interrupts
	 */
	COEOI = TC1EOI = TC2EOI = RTCEOI = TEOI = UMSEOI = SYNCIO = KBDEOI = 0;
}

#define fixup_irq(i)	(i)
