/*
 *  linux/include/asm-arm/arch-clps711x/uncompress.h
 *
 *  Copyright (C) 2000 Deep Blue Solutions Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <asm/hardware/ep7212.h>

#define EP7212_BASE EP7212_PHYS_BASE

#if 1
#define SYSFLGx	SYSFLG2
#define UARTDRx	UARTDR2
#else
#define SYSFLGx	SYSFLG1
#define UARTDRx	UARTDR1
#endif

/*
 * This does not append a newline
 */
static void puts(const char *s)
{
	char c;

	while ((c = *s++) != '\0') {
		while (SYSFLGx & SYSFLG_UTXFF);
		UARTDRx = c;

		if (c == '\n') {
			while (SYSFLGx & SYSFLG_UTXFF);
			UARTDRx = '\r';
		}
	}
	while (SYSFLGx & SYSFLG_UBUSY);
}

/*
 * nothing to do
 */
#define arch_decomp_setup()

#define arch_decomp_wdog()
