/*
 *  linux/include/asm-arm/arch-integrator/irq.h
 *
 *  Copyright (C) 1999 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <asm/arch/platform.h>

/* 
 * All IO addresses are mapped onto VA 0xFFFx.xxxx, where x.xxxx
 * is the (PA >> 12).
 *
 * Setup a VA for the Integrator interrupt controller (for header #0,
 * just for now).
 *
 */
#define VA_IC_BASE              IO_ADDRESS(INTEGRATOR_IC_BASE) 
#define WriteIC(r,v)            *(volatile unsigned int *)(VA_IC_BASE+(r)) = (v)
#define ReadIC(r)               *(volatile unsigned int *)(VA_IC_BASE+(r))

#define VA_CMIC_BASE            IO_ADDRESS(INTEGRATOR_HDR_BASE) + INTEGRATOR_HDR_IC_OFFSET
#define WriteCMIC(r,v)          *(volatile unsigned int *)(VA_CMIC_BASE+(r)) = (v)
#define ReadCMIC(r)             *(volatile unsigned int *)(VA_CMIC_BASE+(r))

#define BUILD_IRQ(s,n,m)

extern void IRQ_interrupt(void);
extern void timer_IRQ_interrupt(void);
extern void fast_IRQ_interrupt(void);
extern void bad_IRQ_interrupt(void);
extern void probe_IRQ_interrupt(void);

#define ALLPCI ( (1 << IRQ_PCIINT0) | (1 << IRQ_PCIINT1) | (1 << IRQ_PCIINT2) | (1 << IRQ_PCIINT3) ) 

static __inline__ void mask_irq(unsigned int irq)
{
        WriteIC(IRQ_ENABLE_CLEAR, 1 << irq) ;
}

static __inline__ void unmask_irq(unsigned int irq)
{
        WriteIC(IRQ_ENABLE_SET, 1 << irq) ;
}
 
static __inline__ unsigned long get_enabled_irqs(void)
{
	return ReadIC(IRQ_STATUS);
}

static __inline__ void irq_init_irq(void)
{
	unsigned int i;

	for (i = 0; i < NR_IRQS; i++) {
	        if (((1 << i) && INTEGRATOR_SC_VALID_INT) != 0) {
		        irq_desc[i].valid	= 1;
			irq_desc[i].probe_ok	= 1;
			irq_desc[i].mask_ack	= mask_irq;
			irq_desc[i].mask	= mask_irq;
			irq_desc[i].unmask	= unmask_irq;
		}
	}

	/* Disable all interrupts initially. */
	/* Do the core module ones */
	WriteCMIC(IRQ_ENABLE_CLEAR, 0xFFFFFFFF) ;

	/* do the header card stuff next */
	WriteIC(IRQ_ENABLE_CLEAR, 0xFFFFFFFF) ;
	WriteIC(FIQ_ENABLE_CLEAR, 0xFFFFFFFF) ;
}

static inline int fixup_irq(unsigned int irq)
{
        return irq ;
}
