/*
 *  linux/include/asm-arm/hardware/clps7111.h
 *
 *  This file contains the hardware definitions of the CLPS7111 internal
 *  registers.
 *
 *  Copyright (C) 2000 Deep Blue Solutions Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_HARDWARE_CLPS7111_H
#define __ASM_HARDWARE_CLPS7111_H

#define CLPS7111_PHYS_BASE	(0x80000000)

#ifndef __ASSEMBLY__
#include <asm/types.h>

#define CLPS7111_REG(type,off)	(*(volatile type *)(CLPS7111_BASE + off))
#else
#define CLPS7111_REG(type,off)	(off)
#endif

#define PADR		CLPS7111_REG(u8 , 0x0000)
#define PBDR		CLPS7111_REG(u8 , 0x0001)
#define PDDR		CLPS7111_REG(u8 , 0x0003)
#define PADDR		CLPS7111_REG(u8 , 0x0040)
#define PBDDR		CLPS7111_REG(u8 , 0x0041)
#define PDDDR		CLPS7111_REG(u8 , 0x0043)
#define PEDR		CLPS7111_REG(u8 , 0x0080)
#define PEDDR		CLPS7111_REG(u8 , 0x00c0)
#define SYSCON1		CLPS7111_REG(u32, 0x0100)
#define SYSFLG1		CLPS7111_REG(u32, 0x0140)
#define MEMCFG1		CLPS7111_REG(u32, 0x0180)
#define MEMCFG2		CLPS7111_REG(u32, 0x01c0)
#define DRFPR		CLPS7111_REG(u32, 0x0200)
#define INTSR1		CLPS7111_REG(u32, 0x0240)
#define INTMR1		CLPS7111_REG(u32, 0x0280)
#define LCDCON		CLPS7111_REG(u32, 0x02c0)
#define TC2D		CLPS7111_REG(u32, 0x0340)
#define RTCDR		CLPS7111_REG(u32, 0x0380)
#define RTCMR		CLPS7111_REG(u32, 0x03c0)
#define PMPCON		CLPS7111_REG(u32, 0x0400)
#define CODR		CLPS7111_REG(u32, 0x0440)
#define UARTDR1		CLPS7111_REG(u32, 0x0480)
#define UBLCR1		CLPS7111_REG(u32, 0x04c0)
#define SYNCIO		CLPS7111_REG(u32, 0x0500)
#define PALLSW		CLPS7111_REG(u32, 0x0540)
#define PALMSW		CLPS7111_REG(u32, 0x0580)
#define STFCLR		CLPS7111_REG(u32, 0x05c0)
#define BLEOI		CLPS7111_REG(u32, 0x0600)
#define MCEOI		CLPS7111_REG(u32, 0x0640)
#define TEOI		CLPS7111_REG(u32, 0x0680)
#define TC1EOI		CLPS7111_REG(u32, 0x06c0)
#define TC2EOI		CLPS7111_REG(u32, 0x0700)
#define RTCEOI		CLPS7111_REG(u32, 0x0740)
#define UMSEOI		CLPS7111_REG(u32, 0x0780)
#define COEOI		CLPS7111_REG(u32, 0x07c0)
#define HALT		CLPS7111_REG(u32, 0x0800)
#define STDBY		CLPS7111_REG(u32, 0x0840)

#define FBADDR		CLPS7111_REG(u32, 0x1000)
#define SYSCON2		CLPS7111_REG(u32, 0x1100)
#define SYSFLG2		CLPS7111_REG(u32, 0x1140)
#define INTSR2		CLPS7111_REG(u32, 0x1240)
#define INTMR2		CLPS7111_REG(u32, 0x1280)
#define UARTDR2		CLPS7111_REG(u32, 0x1480)
#define UBLCR2		CLPS7111_REG(u32, 0x14c0)
#define SS2DR		CLPS7111_REG(u32, 0x1500)
#define SRXEOF		CLPS7111_REG(u32, 0x1600)
#define SS2POP		CLPS7111_REG(u32, 0x16c0)
#define KBDEOI		CLPS7111_REG(u32, 0x1700)

#define SYSCON1_KBDSCAN(x)	((x) & 15)
#define SYSCON1_KBDSCANMASK	(15)
#define SYSCON1_TC1M		(1 << 4)
#define SYSCON1_TC1S		(1 << 5)
#define SYSCON1_TC2M		(1 << 6)
#define SYSCON1_TC2S		(1 << 7)
#define SYSCON1_UART1EN		(1 << 8)
#define SYSCON1_BZTOG		(1 << 9)
#define SYSCON1_BZMOD		(1 << 10)
#define SYSCON1_DBGEN		(1 << 11)
#define SYSCON1_LCDEN		(1 << 12)
#define SYSCON1_CDENTX		(1 << 13)
#define SYSCON1_CDENRX		(1 << 14)
#define SYSCON1_SIREN		(1 << 15)
#define SYSCON1_ADCKSEL(x)	(((x) & 3) << 16)
#define SYSCON1_ADCKSEL_MASK	(3 << 16)
#define SYSCON1_EXCKEN		(1 << 18)
#define SYSCON1_WAKEDIS		(1 << 19)
#define SYSCON1_IRTXM		(1 << 20)

#define SYSFLG_UBUSY		(1 << 11)
#define SYSFLG_URXFE		(1 << 22)
#define SYSFLG_UTXFF		(1 << 23)

#define SYSCON2_SERSEL		(1 << 0)
#define SYSCON2_KBD6		(1 << 1)
#define SYSCON2_DRAMZ		(1 << 2)
#define SYSCON2_KBWEN		(1 << 3)
#define SYSCON2_SS2TXEN		(1 << 4)
#define SYSCON2_PCCARD1		(1 << 5)
#define SYSCON2_PCCARD2		(1 << 6)
#define SYSCON2_SS2RXEN		(1 << 7)
#define SYSCON2_UART2EN		(1 << 8)
#define SYSCON2_SS2MAEN		(1 << 9)
#define SYSCON2_OSTB		(1 << 12)
#define SYSCON2_CLKENSL		(1 << 13)
#define SYSCON2_BUZFREQ		(1 << 14)

#endif /* __ASM_HARDWARE_CLPS7111_H */
