/*
 *  linux/include/asm-arm/hardware/ep7212.h
 *
 *  This file contains the hardware definitions of the EP7212 internal
 *  registers.
 *
 *  Copyright (C) 2000 Deep Blue Solutions Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_HARDWARE_EP7212_H
#define __ASM_HARDWARE_EP7212_H

/*
 * define EP7212_BASE to be the base address of the region
 * you want to access.
 */

#define EP7212_PHYS_BASE	(0x80000000)

/*
 * The first group of registers (0x0000 through 0x1fff)
 * are CL-PS7111 compatible
 */
#define CLPS7111_BASE		EP7212_BASE
#include <asm/hardware/clps7111.h>

#ifndef __ASSEMBLY__
#include <asm/types.h>

#define EP7212_REG(type,off)	(*(volatile type *)(EP7212_BASE + off))
#else
#define EP7212_REG(type,off)	(off)
#endif

/*
 * These registers are specific to the EP7212 only
 */
#define DAIR		EP7212_REG(u32, 0x2000)
#define DAIR0		EP7212_REG(u32, 0x2040)
#define DAIDR1		EP7212_REG(u32, 0x2080)
#define DAIDR2		EP7212_REG(u32, 0x20c0)
#define DAISR		EP7212_REG(u32, 0x2100)
#define SYSCON		EP7212_REG(u32, 0x2200)
#define INTSR3		EP7212_REG(u32, 0x2240)
#define INTMR3		EP7212_REG(u32, 0x2280)
#define LEDFLSH		EP7212_REG(u32, 0x22c0)

#endif /* __ASM_HARDWARE_EP7212_H */
