/*
 *  linux/arch/arm/mach-clps711x/arch.c
 *
 *  Copyright (C) 2000 Deep Blue Solutions Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/init.h>

#include <asm/setup.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>

extern void clps711x_init_irq(void);
extern void p720t_map_io(void);

static void __init
fixup_p720t(struct machine_desc *desc, struct param_struct *params,
	    char **cmdline, struct meminfo *mi)
{
	params->u1.s.page_size		= 4096;
	params->u1.s.nr_pages		= 4096;
	params->u1.s.mem_fclk_21285	= 0;
	params->u1.s.rd_start		= 0;
	params->u1.s.ramdisk_size	= 0;
	params->u1.s.flags		= 0;
	params->u1.s.system_rev		= 0;
	params->u1.s.system_serial_low	= 0;
	params->u1.s.system_serial_high	= 0;
	params->u1.s.rootdev		= 0x0100;

	strcpy(params->commandline, *cmdline);
	strcat(params->commandline, "init=/bin/sh");
}

MACHINE_START(P720T, "ARM-Prospector720T")
	MAINTAINER("ARM Ltd/Deep Blue Solutions Ltd")
	BOOT_MEM(0xc0000000, 0x80000000, 0xff000000)
	BOOT_PARAMS(0xc0000100)
	FIXUP(fixup_p720t)
	MAPIO(p720t_map_io)
	INITIRQ(clps711x_init_irq)
MACHINE_END
