/*
 *  linux/drivers/block/omniiop.c
 *
 */

#undef REALLY_SLOW_IO		/* most systems can safely undef this */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/kernel.h>
#include <linux/timer.h>
#include <linux/mm.h>
#include <linux/interrupt.h>
#include <linux/major.h>
#include <linux/errno.h>
#include <linux/genhd.h>
#include <linux/malloc.h>
#include <linux/pci.h>
#include <linux/delay.h>

#include <asm/byteorder.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/bitops.h>

/*#include <ide.h>
#include <ide_modes.h>*/

#ifdef CONFIG_KMOD
#include <linux/kmod.h>
#endif /* CONFIG_KMOD */
#if 0
#include <asm/arch/omnimeter.h>
#endif

static int bioptrace = 0;
int detailedtrace=0; /* jca */
static int jcacommand;
void jcaoutb(long p, unsigned char data)
{
static int jcacount;
	if (jcacommand == p && data == 0x20 && jcacount++ > 2)
		bioptrace = 0;
	if (bioptrace) {
		printk("jcaoutb(%lx, %x)\n", p, data);
		//jca if (jcacommand == p && data == 0x20) __backtrace();
	}
	if (jcacommand == p) {
		if (data == 0x20)
			printk("R");
		else if (data == 0x30)
			printk("W");
		//else if (!bioptrace)
			//printk("jcaoutb(%lx, %x)\n", p, data);
	}

	if((p >= PCCard0IOBase) && (p <= PCCard0IOBase+SocketIOWindowLen))
	{
		data=((p - PCCard0IOBase) + 0x00) | ((data << 8) & 0xFF00);
		p=PCCardIndexRegister;
	}
	else if((p >= PCCard1IOBase) && (p <= PCCard1IOBase+SocketIOWindowLen))
	{
		data=((p - PCCard1IOBase) + 0x40) | ((data << 8) & 0xFF00);
		p=PCCardIndexRegister;
	}
	else if (! (p & 0xffff0000)) p |= PCCard0IOBase;
	//printk("jcaoutb(%lx, %lx)\n",p,data);
if (detailedtrace)
printk("jcaoutb(%lx, %lx)\n",p,data);
	*(volatile unsigned char *)(p) = data;
}

unsigned char jcainb(long p)
{
int ret;

	if (! (p & 0xffff0000)) p |= PCCard0IOBase;
	ret = *(volatile unsigned char *)(p);
	if (bioptrace)
		printk("jcainb(%lx)=%x\n", p, ret & 0xff);
if (detailedtrace)
printk("jcainb(%lx)=%x\n", p, ret & 0xff);
	return ret;
}

void jcaoutw(long p, unsigned short data)
{
	if (! (p & 0xffff0000)) p |= PCCard0IOBase;
if (detailedtrace)
if(data != 0) printk("jcaoutw(%lx,%lx)\n",p,data);
	*(volatile unsigned short *)(p) = data;
}


unsigned char jaginb_p(long PCregister,int socket)
{
  int ret;
  //select the appropriate register
  *(volatile char *)(PCCardIndexRegister) = socket*0x40 + (PCregister & 0x00FF);
  //read the data from the data register
  ret = *(volatile unsigned char *)(PCCardIndexRegister + 0x1);
if (detailedtrace)
printk("jaginb_p(%x,%x)=%x\n", PCregister, socket, ret);
  return ret;
}

unsigned short jcainw(long p)
{
int ret;

	if (! (p & 0xffff0000)) p |= PCCard0IOBase;
	ret = *(volatile unsigned short *)(p);
if (detailedtrace)
printk("jcainw(%lx)=%x\n",p,ret);
	return ret;
}

#define SMBInput() WritePort32(GPDR, ReadPort32(GPDR) & (~GPIO_sda));
#define SMBOutput() WritePort32(GPDR, ReadPort32(GPDR) |   GPIO_sda);
#define PSize(bpp)			(sizeof(short) << bpp)
#define FBSize(w, h, bpp)	(h * ((w * bpp) >> 3))

int GetCPUMHz(void)
{
static const int PLLSpeeds[] = { 59,74,89,103,118,133,148,162,177,192,206 };
	return PLLSpeeds[ReadPort32(PPCR) & 0x0000000F];
}
static unsigned int GetPCD(unsigned int pcdAt59)
{
	return ((GetCPUMHz() * (pcdAt59 + 2)) - 118) / 59;		// this returns '58'
}
static void SMBDelay(void)
{
unsigned int endDelay  = ReadPort32(OSCR) + 20; // delay a bit > 5us
	while (ReadPort32(OSCR) > endDelay)
		// for counter roll-over, careful that interrupts don't mess this up
		;
	while (ReadPort32(OSCR) < endDelay)
		;
}
static void WriteSMBData(unsigned short k)
{
	WritePort32((k ? GPSR : GPCR), GPIO_sda);
	SMBDelay();
}
static unsigned char ReadSMBData(void)
{
	return ((ReadPort32(GPLR) & GPIO_sda) != 0);
}
static void SMBClockRise(void)
{
    WritePort32(GPSR, GPIO_scl);
	SMBDelay();
}
static void SMBClockFall(void)
{
    WritePort32(GPCR, GPIO_scl);
	SMBDelay();
}
static unsigned char ReadSMB_ack(void)
{
	unsigned char i;
	SMBInput();
	SMBClockFall();
	SMBClockRise();
	i = ReadSMBData();
	SMBClockFall();
	return (!i);
}
static void WriteCompleteSMBAddress(unsigned char address)
{
	int i;
	for(i = 7; i >= 0; i--) {
	  	SMBClockFall();
	  	WriteSMBData((unsigned char) (address >> i) & 0x1);/* send address */
	  	SMBClockRise();
	}
}
static void WriteSMBStopCondition(void)
{
	SMBClockFall();
   	WriteSMBData(0);
	SMBClockRise();
   	WriteSMBData(1);
}
static unsigned char ReadSMB(unsigned char address)
{
	int i;
	unsigned char data;
   	WriteSMBData(0);
	WriteCompleteSMBAddress((address << 1) | 0x01);
   	ReadSMB_ack();
	for(i=7, data=0; i>=0; i--) {
	  	SMBClockFall();
		data <<= 1;					// first time thru, this does nothing
	  	data |= ReadSMBData();		// get bit
	  	SMBClockRise();
	}
	SMBOutput();
	WriteSMBStopCondition();
  	return data;
}
static void WriteSMB(unsigned char address, unsigned char data)
{
	int i;
   	WriteSMBData(0);
	WriteCompleteSMBAddress((address << 1) & 0xFE);
   	ReadSMB_ack();
	SMBOutput();
	for(i = 7; i >= 0; i--) {
	  	SMBClockFall();
	  	WriteSMBData((unsigned char)(data >> i) & 0x1);		 /* send data */
	  	SMBClockRise();
	}
   	ReadSMB_ack();
	SMBOutput();
	WriteSMBStopCondition();
}
void SMBOn(unsigned char SMBaddress)
{
	WriteSMB(SMBaddress, (ReadSMB(SMBaddress) & 0x1F) | 0xE0);
}
void SMBOff(unsigned char SMBaddress)
{
	WriteSMB(SMBaddress, (ReadSMB(SMBaddress) & 0x1F) | 0xA0);
}
void SetSMB(unsigned char SMBaddress, unsigned int dacValue)
{
	WriteSMB(SMBaddress, (dacValue & 0x1F) | 0xE0);
}

#define WritePort32(port,value) (port = (value))
#define ReadPort32(port) (port)

static void ComInit(void)
{
static int initprintf_flag = 0;
if (!initprintf_flag) {
	initprintf_flag = 1;
	WritePort32(ICMR, 0x00000000);	// disables all interrupts which kills the Angel serial interrupt
	WritePort32(Ser1SDCR0, ReadPort32(Ser1SDCR0) | 0x01);/* set up SDLC SUS bit for UART tx/rx */
	WritePort32(Ser1UTCR3, 0x00);	/* disable tx and rx bits and interrupts */
	WritePort32(Ser1UTSR0, 0xFF);	/* clear */
	WritePort32(Ser1UTCR0, 0x08);	/* 8 bit, no parity, 1 stop */
	WritePort32(Ser1UTCR1, 0x00);	/* upper baud rate select */
#define BAUD_38400                      0x005
#define BAUD_19200                      0x00b
#define BAUD_9600                       0x017
#define BAUD_2400                       0x05F 
	WritePort32(Ser1UTCR2, BAUD_9600);
	WritePort32(Ser1UTCR3, 0x03);	/* enable rx and tx */
}
} 
int ComCheckByte(void)
{
    return ReadPort32(Ser1UTSR1) & UTSR1_RNE;
}
unsigned char ComReadByte(void)
{
	return ReadPort32(Ser1UTDR);
}
static void ComPutByte(unsigned char ch)
{
	ComInit();
	while (!(ReadPort32(Ser1UTSR1) & UTSR1_TNF)) ;	/* wait until ready */
	WritePort32(Ser1UTDR, ch);
}
void ComPutChar(unsigned char ch)
{
	if (ch == '\n')
		ComPutByte('\r');
	ComPutByte(ch);
}
void memdump(unsigned char *p, int len, char *title)
{
int i;

    i = 0;
    while (len > 0) {
		if ((i & 0xf) == 0) {
	    	if (i > 0)
				printk("\n");
	    	printk("%s: ",title);
		}
		printk("%02x ", *p++);
		i++;
		len--;
    }
    printk("\n");
}

int ioptrace = 0;
int bops_readb(unsigned char *r)
{
int data, i, j, k;
unsigned short *rp;

data = *r & 0xff;
#if 1
#if 0
if ((long)r >= PCCard0MemBase && (long)r <= PCCard1MemBase && ((long)r & 0xff == 0)) {
#else
if (0 && (long)r == PCCard0MemBase) {
#endif
	ioptrace = 0;
	i = 0;
	rp = (unsigned short *)r;
	for (j = 0; j < 100; j++) {
		printk ("[%x] %x len %x:", ((int)&rp[i]) - 0xf4000000, rp[i]&0xff, rp[i+1]&0xff);
		if ((rp[i]&0xff) == 0xff)
			break;
		for (k = 0; k < (rp[i+1]&0xff); k++)
			printk(" %x", rp[i+2+k]&0xff);
		printk("\n");
		i += 2 + (rp[i+1] & 0xff);
	}
	printk("\n");
}
#endif
if (detailedtrace)
printk("bops_readb(%x)=%x\n", r, data);
return data;
}
int bops_readl(int r)
{
printk("bops_readl: %x (%x)\n", (int)__builtin_return_address(0), r);
return -1;
}
int bops_writeb(char value, char *place)
{
if (detailedtrace)
printk("bops_writeb(%x,%x)\n", value, place);
*place = value;
//jca printk("bops_writeb: %x (%x, %x)\n", __builtin_return_address(0), value, place);
return 0;
}

static int *jcaget_page(void)
{
register unsigned int i;
	__asm__ volatile (
	"mrc	p15, 0, %0, c2, c0, 0"
	: "=r" (i));
return (int *)(i & 0xffffc000);
}
void jcaprint_page(unsigned long arg_address)
{
int *pagep = jcaget_page();
int i = (arg_address >> 20);

printk ("jcaprint_page(%x) %x page[%x]=%x\n", arg_address, i, pagep, pagep[i]);
}
