/*
 * Itsy USB debug macros
 *
 * Copyright (c) Compaq Computer Corporation, 1999
 *
 * Debug printing work using an integer bit mask. The level may be modified
 * at module loadtime using
 *
 * insmod usbd-itsy usbd_dbglvl=??
 *
 * where the value you set dbglvl is determined by the definitions below.
 * 
 * nothing of critical importance should be printed using these macros.
 *
 */

#ifndef USB_DBG_H
#define USB_DBG_H

extern int usbd_dbglvl;

#define USBD_DEBUG

#define DEBUG_DEFAULT         0x0

#define DEBUG_ETH             0x01
#define DEBUG_SEND            0x02
#define DEBUG_RECV            0x04
#define DEBUG_EP0             0x08
#define DEBUG_CTL             0x10

#define DEBUG_CTL_IMPORTANT   0x0100
#define DEBUG_CTL_DIAGNOSTIC  0x0200

#ifndef DBGSTR_PREFIX
#define DBGSTR_PREFIX "usb_net_func: "
#endif

#ifdef USBD_DEBUG

#define DEBUG_KPrintCond( ilev, cond, _x_) \
	if( (usbd_dbglvl & ilev) && ( cond )) { \
			printk( DBGSTR_PREFIX ); \
			printk _x_ ; \
	}


#define DEBUG_KPrint( ilev, _x_)  DEBUG_KPrintCond( ilev, 1, _x_ )


#else

#define DEBUG_KPrintCond( ilev, cond, _x_)
#define DEBUG_KPrint( ilev, _x_)

#endif

#endif

#if 0
#undef DEBUG_KPrint
#define DEBUG_KPrint( ilev, _x_)  printk _x_
#endif
