/*
 *
 * Definitions for Mercury BackPAQ
 *
 * Copyright 2000 Compaq Computer Corporation.
 *
 * Copying or modifying this code for any purpose is permitted,
 * provided that this copyright notice is preserved in its entirety
 * in all copies or modifications.  COMPAQ COMPUTER CORPORATION
 * MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS
 * OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR
 * PURPOSE.
 *
 * Author: Jamey Hicks.
 *
 */

#ifndef _INCLUDE_BACKPAQ_H_
#define _INCLUDE_BACKPAQ_H_

struct mercury_backpaq_sysctl {
   short vendorid;
   short pad0;
   short deviceid;
   short pad1;
   short option;
   short pad2;
   short gas_gauge;
   short pad3;
   short pcmcia_power;
   short pad4;
   short flash_control;
   short pad5;
   short audio_control;
   short pad6;
   short accelerometer;
   short pad7;
   short fpga;
   short pad8;
   ...
   long socket[2];
};

#define BACKPAQ_SYSCTL_BASE 0xf2000000 /* static memory bank 4 */ 

#define BACKPAQ_OPTION_OPT_ON (1 << 0)
#define BACKPAQ_OPTION_DC_IN  (1 << 1)
#define BACKPAQ_OPTION_MCHG   (1 << 2)
#define BACKPAQ_OPTION_EBAT   (1 << 3)
#define BACKPAQ_OPTION_ETMI   (1 << 4)
#define BACKPAQ_OPTION_ETMO   (1 << 5)
#define BACKPAQ_OPTION_5VEN   (1 << 6)
#define BACKPAQ_OPTION_CCLKEN (1 << 7)

#define BACKPAQ_GASGAUGE_BDIR (1 << 0)
#define BACKPAQ_GASGAUGE_BSCL (1 << 1)
#define BACKPAQ_GASGAUGE_BSDA (1 << 2)

#define BACKPAQ_PCMCIA_AEN0   (1 << 0)
#define BACKPAQ_PCMCIA_AEN1   (1 << 1)
#define BACKPAQ_PCMCIA_A5VEN  (1 << 2)
#define BACKPAQ_PCMCIA_A3VEN  (1 << 3)
#define BACKPAQ_PCMCIA_BEN0   (1 << 4)
#define BACKPAQ_PCMCIA_BEN1   (1 << 5)
#define BACKPAQ_PCMCIA_B5VEN  (1 << 6)
#define BACKPAQ_PCMCIA_B3VEN  (1 << 7)

#define BACKPAQ_FLASH_RESET0  (1 << 0)
#define BACKPAQ_FLASH_RESET1  (1 << 1)
#define BACKPAQ_FLASH_STATUS0 (1 << 2)
#define BACKPAQ_FLASH_STATUS1 (1 << 3)
#define BACKPAQ_FLASH_VPPEN   (1 << 4)

#define BACKPAQ_AUDIO_CLKEN   (1 << 0)
#define BACKPAQ_AUDIO_AMPEN   (1 << 1)
#define BACKPAQ_AUDIO_AGCSTAT (1 << 2)

#define BACKPAQ_SOCKET_INPACK (1 << 0)
#define BACKPAQ_SOCKET_SPKR   (1 << 1)
#define BACKPAQ_SOCKET_VS1    (1 << 2)
#define BACKPAQ_SOCKET_VS2    (1 << 3)
#define BACKPAQ_SOCKET_SPKR   (1 << 4)
#define BACKPAQ_SOCKET_SKTSEL (1 << 5)
#define BACKPAQ_SOCKET_CD0    (1 << 6)
#define BACKPAQ_SOCKET_CD1    (1 << 7)

#endif
