/*
 *  linux/drivers/block/jornada720.c
 *
 */

#undef REALLY_SLOW_IO		/* most systems can safely undef this */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/kernel.h>
#include <linux/timer.h>
#include <linux/mm.h>
#include <linux/interrupt.h>
#include <linux/major.h>
#include <linux/errno.h>
#include <linux/genhd.h>
#include <linux/malloc.h>
#include <linux/pci.h>
#include <linux/delay.h>

#include <asm/byteorder.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/bitops.h>

#ifdef CONFIG_KMOD
#include <linux/kmod.h>
#endif /* CONFIG_KMOD */

#define MCU_GetBatteryData  0xc0
#define MCU_GetScanKeyCode	0x90
#define MCU_GetTouchSamples	0xa0
#define MCU_SetContrast     0xD1
#define MCU_SetBrightness   0xD3
#define MCU_TxDummy         0x11
#define MCU_ErrorCode       0x00
#define SA1100_PPDR_LFCLK 	0x400

#define mcu_read() mcu_byte(MCU_TxDummy)

static char mcu_invert[256];

static int mcu_byte(int arg_data)
{
int i;

	while ((Ser4SSSR & SSSR_TNF) == 0);
	i = 0;
	while ((GPLR & 0x400) && i++ < 400000)
		; /* wait for MCU */
	if (i >= 400000) {
		printk("mcu_byte: timed out\n");
        return -1;
    }
	Ser4SSDR = mcu_invert[arg_data] << 8;
	udelay(100);
	while ((Ser4SSSR & SSSR_RNE) == 0);
	i = Ser4SSDR;
	if (i > 0xff)
		printk("mcu_byte: read %x\n", i);
	return mcu_invert[ i & 0xff ];
}

static void mcu_start(int arg_data)
{
int i;

	jornada720_mcu_init();
	GPCR = 0x02000000; /* clear -> enable */
#if 0
	udelay(100);
#endif
	i = mcu_byte(arg_data);
	if (i != MCU_TxDummy)
		printk("mcu_start: [%x] bad start %x\n", arg_data, i);
}

static void mcu_end(void)
{
#if 0
	udelay(100);
#endif
	GPSR = 0x02000000; /* set */
}

void jornada720_mcu_init(void)
{
int i;
static int initialized = 0;
unsigned char temp_data[256];
TS_RET ret;

	if (initialized)
		return;
	initialized = 1;
	PPSR &= ~(SA1100_PPDR_LFCLK | 0x80 | 0x10);
	PPDR |= SA1100_PPDR_LFCLK | 0x80 | 0x10;
	printk ("[%s]: sa1111_init_hw entry\n", __FILE__);
	/* Take the MCU out of reset mode */
	PPSR |= SA1100_PPDR_LFCLK;
	printk ("now wait after reset done\n");
	for (i = 0; i <= 255; i++)
		mcu_invert[i] = ( ((0x80 & i) >> 7) | ((0x40 & i) >> 5)
		  | ((0x20 & i) >> 3) | ((0x10 & i) >> 1) | ((0x08 & i) << 1)
		  | ((0x04 & i) << 3) | ((0x02 & i) << 5) | ((0x01 & i) << 7) );

	GPSR = 0x02000000; /* set */
	GPDR |= 0x02000000; /* GPIO(25) low -> enable MCU */
	Ser4SSCR0 = 0x0307;
	Ser4MCCR0 = 0;
	Ser4SSSR = 0;	/* remove any rcv overrun errors */
	Ser4SSCR1 = 0x18;
	Ser4SSCR0 = 0x0387;

	/* drain any data already there */
	while (Ser4SSSR & SSSR_RNE)  i = Ser4SSDR;

	jornada720_battery();
	jornada720_getkey(temp_data, sizeof(temp_data));
	jornada720_gettouch(&ret);
}

void jornada_contrast(int arg_contrast)
{
int i;

	mcu_start(MCU_SetContrast);
	i = mcu_byte(arg_contrast);
	mcu_end();
}

void jornada720_battery(void)
{
	mcu_start(MCU_GetBatteryData);
	printk("get2 bat %x\n", mcu_read());
	printk("get3 bat %x\n", mcu_read());
	printk("get4 bat %x\n", mcu_read());
	mcu_end();
}

int jornada720_getkey(unsigned char *data, int size)
{
int this_count, i, j;

    /* Flush any pending input. */
	mcu_start(MCU_GetScanKeyCode);
	this_count = mcu_read();
	i = this_count;
	while (i-- > 0) {
		j = mcu_read();
		if (size-- > 0)
			*data++ = j;
	}
	mcu_end();
	return this_count;
}

void jornada720_gettouch(TS_RET *ret)
{
int x1, x2, x3, y1, y2, y3;
int i;

	mcu_start(MCU_GetTouchSamples);
	x1 = mcu_read();
	x2 = mcu_read();
	x3 = mcu_read();
	i = mcu_read();
	x1 |= (i & 3) << 8;
	x2 |= (i & 0xc) << 6;
	x3 |= (i & 0x30) << 4;
	y1 = mcu_read();
	y2 = mcu_read();
	y3 = mcu_read();
	i = mcu_read();
	y1 |= (i & 3) << 8;
	y2 |= (i & 0xc) << 6;
	y3 |= (i & 0x30) << 4;
	mcu_end();
	printk("x %x %x %x y %x %x %x\n", x1, x2, x3, y1, y2, y3);
	ret->x = x3;
	ret->y = y3;
	ret->pressure = 1;
}

void memdump(unsigned char *p, int len, char *title)
{
int i;

    i = 0;
    while (len > 0) {
		if ((i & 0xf) == 0) {
	    	if (i > 0)
				printk("\n");
	    	printk("%s: ",title);
		}
		printk("%02x ", *p++);
		i++;
		len--;
    }
    printk("\n");
}

void jcatracebozo(void)
{
__backtrace();
return;
}
